/*
 * Decompiled with CFR 0.152.
 */
package org.fao.oaipmh.requests;

import java.nio.file.Path;
import java.util.Map;
import org.fao.geonet.exceptions.XSDValidationErrorEx;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.fao.geonet.utils.Xml;
import org.fao.geonet.utils.XmlRequest;
import org.fao.oaipmh.exceptions.OaiPmhException;
import org.fao.oaipmh.responses.AbstractResponse;
import org.fao.oaipmh.util.Lib;
import org.jdom.Content;
import org.jdom.Element;

public abstract class AbstractRequest {
    private final XmlRequest transport;
    private Path schemaPath;

    public AbstractRequest(GeonetHttpRequestFactory transport) {
        this.transport = transport.createXmlRequest();
    }

    public AbstractRequest(XmlRequest transport) {
        this.transport = transport;
    }

    public Path getSchemaPath() {
        return this.schemaPath;
    }

    public void setSchemaPath(Path schemaPath) {
        this.schemaPath = schemaPath;
    }

    public XmlRequest getTransport() {
        return this.transport;
    }

    public abstract String getVerb();

    public abstract AbstractResponse execute() throws Exception;

    protected Element sendRequest(Map<String, String> params) throws Exception {
        this.transport.clearParams();
        for (Map.Entry<String, String> param : params.entrySet()) {
            this.transport.addParam(param.getKey(), (Object)param.getValue());
        }
        this.transport.addParam("verb", (Object)this.getVerb());
        Element response = this.transport.execute();
        if (!Lib.isRootValid(response)) {
            throw new Exception("Response is not in OAI-PMH format");
        }
        try {
            Xml.validate((Element)response);
        }
        catch (XSDValidationErrorEx e) {
            response.addContent((Content)new Element("error").setText(e.getMessage()));
        }
        OaiPmhException.unmarshal(response);
        return response;
    }
}

