/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.transform.transforms.latest;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class LatestConfig
implements ToXContentObject {
    private static final String NAME = "latest_config";
    private static final ParseField UNIQUE_KEY = new ParseField("unique_key", new String[0]);
    private static final ParseField SORT = new ParseField("sort", new String[0]);
    private final List<String> uniqueKey;
    private final String sort;
    private static final ConstructingObjectParser<LatestConfig, Void> PARSER = new ConstructingObjectParser("latest_config", true, args -> new LatestConfig((List)args[0], (String)args[1]));

    public static LatestConfig fromXContent(XContentParser parser) {
        return (LatestConfig)PARSER.apply(parser, null);
    }

    LatestConfig(List<String> uniqueKey, String sort) {
        this.uniqueKey = uniqueKey;
        this.sort = sort;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(UNIQUE_KEY.getPreferredName(), this.uniqueKey);
        builder.field(SORT.getPreferredName(), this.sort);
        builder.endObject();
        return builder;
    }

    public List<String> getUniqueKey() {
        return this.uniqueKey;
    }

    public String getSort() {
        return this.sort;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        LatestConfig that = (LatestConfig)other;
        return Objects.equals(this.uniqueKey, that.uniqueKey) && Objects.equals(this.sort, that.sort);
    }

    public int hashCode() {
        return Objects.hash(this.uniqueKey, this.sort);
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), UNIQUE_KEY);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), SORT);
    }

    public static class Builder {
        private List<String> uniqueKey;
        private String sort;

        public Builder setUniqueKey(String ... uniqueKey) {
            return this.setUniqueKey(Arrays.asList(uniqueKey));
        }

        public Builder setUniqueKey(List<String> uniqueKey) {
            this.uniqueKey = uniqueKey;
            return this;
        }

        public Builder setSort(String sort) {
            this.sort = sort;
            return this;
        }

        public LatestConfig build() {
            return new LatestConfig(this.uniqueKey, this.sort);
        }
    }
}

