/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class GetDatafeedRequest
extends ActionRequest
implements ToXContentObject {
    public static final ParseField DATAFEED_IDS = new ParseField("datafeed_ids", new String[0]);
    public static final ParseField ALLOW_NO_MATCH = new ParseField("allow_no_match", new String[0]);
    public static final String EXCLUDE_GENERATED = "exclude_generated";
    private static final String ALL_DATAFEEDS = "_all";
    private final List<String> datafeedIds;
    private Boolean allowNoMatch;
    private Boolean excludeGenerated;
    public static final ConstructingObjectParser<GetDatafeedRequest, Void> PARSER = new ConstructingObjectParser("get_datafeed_request", true, a -> new GetDatafeedRequest(a[0] == null ? new ArrayList() : (List)a[0]));

    public static GetDatafeedRequest getAllDatafeedsRequest() {
        return new GetDatafeedRequest(ALL_DATAFEEDS);
    }

    public GetDatafeedRequest(String ... datafeedIds) {
        this(Arrays.asList(datafeedIds));
    }

    GetDatafeedRequest(List<String> datafeedIds) {
        if (datafeedIds.stream().anyMatch(Objects::isNull)) {
            throw new NullPointerException("datafeedIds must not contain null values");
        }
        this.datafeedIds = new ArrayList<String>(datafeedIds);
    }

    public List<String> getDatafeedIds() {
        return this.datafeedIds;
    }

    public void setAllowNoMatch(boolean allowNoMatch) {
        this.allowNoMatch = allowNoMatch;
    }

    public Boolean getAllowNoMatch() {
        return this.allowNoMatch;
    }

    public void setExcludeGenerated(boolean excludeGenerated) {
        this.excludeGenerated = excludeGenerated;
    }

    public Boolean getExcludeGenerated() {
        return this.excludeGenerated;
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    public int hashCode() {
        return Objects.hash(this.datafeedIds, this.excludeGenerated, this.allowNoMatch);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || other.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        GetDatafeedRequest that = (GetDatafeedRequest)((Object)other);
        return Objects.equals(this.datafeedIds, that.datafeedIds) && Objects.equals(this.allowNoMatch, that.allowNoMatch) && Objects.equals(this.excludeGenerated, that.excludeGenerated);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (!this.datafeedIds.isEmpty()) {
            builder.stringListField(DATAFEED_IDS.getPreferredName(), this.datafeedIds);
        }
        if (this.allowNoMatch != null) {
            builder.field(ALLOW_NO_MATCH.getPreferredName(), this.allowNoMatch);
        }
        builder.endObject();
        return builder;
    }

    static {
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), DATAFEED_IDS);
        PARSER.declareBoolean(GetDatafeedRequest::setAllowNoMatch, ALLOW_NO_MATCH);
    }
}

