/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.BasicErrorManager;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.LightweightMessageFormatter;
import com.google.javascript.jscomp.MessageFormatter;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LoggerErrorManager
extends BasicErrorManager {
    private final MessageFormatter formatter;
    private final Logger logger;

    public LoggerErrorManager(MessageFormatter formatter, Logger logger) {
        this.formatter = formatter;
        this.logger = logger;
    }

    public LoggerErrorManager(Logger logger) {
        this(LightweightMessageFormatter.withoutSource(), logger);
    }

    @Override
    public void println(CheckLevel level, JSError error) {
        switch (level) {
            case ERROR: {
                this.logger.severe(error.format(level, this.formatter));
                break;
            }
            case WARNING: {
                this.logger.warning(error.format(level, this.formatter));
                break;
            }
        }
    }

    @Override
    protected void printSummary() {
        Level level;
        Level level2 = level = this.getErrorCount() + this.getWarningCount() == 0 ? Level.INFO : Level.WARNING;
        if (this.getTypedPercent() > 0.0) {
            this.logger.log(level, "{0} error(s), {1} warning(s), {2,number,#.#}% typed", new Object[]{this.getErrorCount(), this.getWarningCount(), this.getTypedPercent()});
        } else if (this.getErrorCount() + this.getWarningCount() > 0) {
            this.logger.log(level, "{0} error(s), {1} warning(s)", new Object[]{this.getErrorCount(), this.getWarningCount()});
        }
    }
}

