/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine.constraint;

import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.shacl.compact.writer.CompactOut;
import org.apache.jena.shacl.engine.ValidationContext;
import org.apache.jena.shacl.engine.constraint.ConstraintTerm;
import org.apache.jena.shacl.validation.ReportItem;
import org.apache.jena.shacl.vocabulary.SHACL;
import org.apache.jena.sparql.expr.nodevalue.NodeFunctions;

public class StrLanguageIn
extends ConstraintTerm {
    private final List<String> langs;

    public StrLanguageIn(List<String> langs) {
        this.langs = langs;
    }

    @Override
    public ReportItem validate(ValidationContext vCxt, Node n) {
        if (!n.isLiteral()) {
            return new ReportItem(this.toString() + ": Not a literal", n);
        }
        String langTag = n.getLiteralLanguage();
        if (langTag == null || langTag.isEmpty()) {
            if (vCxt.isStrict()) {
                if (Util.isSimpleString((Node)n)) {
                    return new ReportItem(this.toString() + ": xsd:string (no language tag)", n);
                }
                return new ReportItem(this.toString() + ": No language tag", n);
            }
            if (!Util.isSimpleString((Node)n)) {
                return new ReportItem(this.toString() + ": Not an rdf:langString or xsd:string", n);
            }
            if (this.langs.contains(langTag)) {
                return null;
            }
            return new ReportItem(this.toString() + ": No matching language tag", n);
        }
        for (String langPattern : this.langs) {
            boolean b = NodeFunctions.langMatches((String)langTag, (String)langPattern);
            if (!b) continue;
            return null;
        }
        String msg = this.toString() + ": No matching language tag " + langTag;
        return new ReportItem(msg, n);
    }

    @Override
    public Node getComponent() {
        return SHACL.LanguageInConstraintComponent;
    }

    @Override
    public void printCompact(IndentedWriter out, NodeFormatter nodeFmt) {
        CompactOut.compactArrayString(out, nodeFmt, "languageIn", this.langs);
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(", ");
        this.langs.forEach(lang -> {
            if (lang.isEmpty()) {
                sj.add("<plain>");
            } else {
                sj.add((CharSequence)lang);
            }
        });
        return "LanguageIn[" + sj.toString() + "]";
    }

    public int hashCode() {
        return Objects.hash(this.langs);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StrLanguageIn)) {
            return false;
        }
        StrLanguageIn other = (StrLanguageIn)obj;
        return Objects.equals(this.langs, other.langs);
    }
}

