/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine.constraint;

import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.shacl.compact.writer.CompactWriter;
import org.apache.jena.shacl.compact.writer.ShaclNotCompactException;
import org.apache.jena.shacl.engine.ValidationContext;
import org.apache.jena.shacl.engine.constraint.ConstraintOp1;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.parser.Constraint;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.shacl.validation.ReportItem;
import org.apache.jena.shacl.validation.ValidationProc;
import org.apache.jena.shacl.vocabulary.SHACL;

public class ShNot
extends ConstraintOp1 {
    public ShNot(Shape other) {
        super(other);
    }

    @Override
    public Node getComponent() {
        return SHACL.NotConstraintComponent;
    }

    @Override
    public ReportItem validate(ValidationContext vCxt, Graph data, Node node) {
        ValidationContext vCxt2 = ValidationContext.create(vCxt);
        ValidationProc.execValidateShape(vCxt2, data, this.other, node);
        boolean innerConforms = vCxt2.generateReport().conforms();
        if (!innerConforms) {
            return null;
        }
        String msg = "Not[" + this.other + "] at focusNode " + ShLib.displayStr(node);
        return new ReportItem(msg, node);
    }

    @Override
    public void printCompact(IndentedWriter out, NodeFormatter nodeFmt) {
        Constraint constraint = CompactWriter.getCompactPrintable(this.other);
        if (constraint == null) {
            throw new ShaclNotCompactException("sh:not(" + this.other + ")");
        }
        out.print("! ");
        constraint.printCompact(out, nodeFmt);
    }

    public String toString() {
        return "Not";
    }
}

