/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.lint;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;

public final class CheckJSDoc
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    public static final DiagnosticType MISSING_PARAM_JSDOC = DiagnosticType.warning("JSC_MISSING_PARAM_JSDOC", "Missing JSDoc for param {0}");
    public static final DiagnosticType MUST_BE_PRIVATE = DiagnosticType.warning("JSC_MUST_BE_PRIVATE", "Function {0} must be marked @private");
    public static final DiagnosticType OPTIONAL_NAME_NOT_MARKED_OPTIONAL = DiagnosticType.warning("JSC_OPTIONAL_NAME_NOT_MARKED_OPTIONAL", "Parameter {0} is optional so its type must end with =");
    public static final DiagnosticType OPTIONAL_TYPE_NOT_USING_OPTIONAL_NAME = DiagnosticType.warning("JSC_OPTIONAL_TYPE_NOT_USING_OPTIONAL_NAME", "Optional parameter name {0} must be prefixed with opt_");
    public static final DiagnosticType DISALLOWED_MEMBER_JSDOC = DiagnosticType.warning("JSC_DISALLOWED_MEMBER_JSDOC", "Class level JSDocs (@interface, @extends, etc.) are not allowed on class members");
    private final AbstractCompiler compiler;

    public CheckJSDoc(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        JSDocInfo jsDoc;
        if (n.isFunction()) {
            JSDocInfo jsDoc2 = NodeUtil.getBestJSDocInfo(n);
            if (jsDoc2 != null) {
                String name;
                if (!jsDoc2.isOverride()) {
                    for (Node param : n.getFirstChild().getNext().children()) {
                        if (!jsDoc2.hasParameterType(param.getString())) {
                            t.report(param, MISSING_PARAM_JSDOC, param.getString());
                            continue;
                        }
                        boolean jsDocOptional = jsDoc2.getParameterType(param.getString()).isOptionalArg();
                        boolean nameOptional = this.compiler.getCodingConvention().isOptionalParameter(param);
                        if (nameOptional && !jsDocOptional) {
                            t.report(param, OPTIONAL_NAME_NOT_MARKED_OPTIONAL, param.getString());
                            continue;
                        }
                        if (nameOptional || !jsDocOptional) continue;
                        t.report(param, OPTIONAL_TYPE_NOT_USING_OPTIONAL_NAME, param.getString());
                    }
                }
                if ((name = NodeUtil.getFunctionName(n)) != null && this.compiler.getCodingConvention().isPrivate(name) && !jsDoc2.getVisibility().equals((Object)JSDocInfo.Visibility.PRIVATE)) {
                    t.report(n, MUST_BE_PRIVATE, name);
                }
            }
        } else if (n.isMemberFunctionDef() && (jsDoc = NodeUtil.getBestJSDocInfo(n)) != null && (jsDoc.isConstructor() || jsDoc.isInterface() || jsDoc.hasBaseType() || jsDoc.getImplementedInterfaceCount() != 0 || jsDoc.getExtendedInterfacesCount() != 0)) {
            t.report(n, DISALLOWED_MEMBER_JSDOC, new String[0]);
        }
    }
}

