/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.SourceAst;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.parsing.ParserRunner;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.InputId;
import com.google.javascript.rhino.Node;
import java.io.IOException;

public class JsAst
implements SourceAst {
    private static final long serialVersionUID = 1L;
    private transient InputId inputId;
    private transient SourceFile sourceFile;
    private String fileName;
    private Node root;

    public JsAst(SourceFile sourceFile) {
        this.inputId = new InputId(sourceFile.getName());
        this.sourceFile = sourceFile;
        this.fileName = sourceFile.getName();
    }

    @Override
    public Node getAstRoot(AbstractCompiler compiler) {
        if (this.root == null) {
            this.parse(compiler);
            this.root.setInputId(this.inputId);
        }
        return this.root;
    }

    @Override
    public void clearAst() {
        this.root = null;
        this.sourceFile.clearCachedSource();
    }

    @Override
    public InputId getInputId() {
        return this.inputId;
    }

    @Override
    public SourceFile getSourceFile() {
        return this.sourceFile;
    }

    @Override
    public void setSourceFile(SourceFile file) {
        Preconditions.checkState((boolean)this.fileName.equals(file.getName()));
        this.sourceFile = file;
    }

    private void parse(AbstractCompiler compiler) {
        int startErrorCount = compiler.getErrorManager().getErrorCount();
        try {
            ParserRunner.ParseResult result = ParserRunner.parse(this.sourceFile, this.sourceFile.getCode(), compiler.getParserConfig(this.sourceFile.isExtern() ? AbstractCompiler.ConfigContext.EXTERNS : AbstractCompiler.ConfigContext.DEFAULT), compiler.getDefaultErrorReporter());
            this.root = result.ast;
            if (compiler.isIdeMode()) {
                compiler.addComments(this.sourceFile.getName(), result.comments);
            }
        }
        catch (IOException e) {
            compiler.report(JSError.make(AbstractCompiler.READ_ERROR, this.sourceFile.getName()));
        }
        if (this.root == null || compiler.getErrorManager().getErrorCount() > startErrorCount && !compiler.isIdeMode()) {
            this.root = IR.script();
        } else {
            compiler.prepareAst(this.root);
        }
        this.root.setStaticSourceFile(this.sourceFile);
    }
}

