/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.visitor.AbstractCalcResult;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.CalcUtil;
import org.geotools.feature.visitor.FeatureAttributeVisitor;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.filter.IllegalFilterException;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;

public class AverageVisitor
implements FeatureCalc,
FeatureAttributeVisitor {
    private Expression expr;
    private boolean isOptimized = false;
    AverageStrategy strategy;

    public AverageVisitor(int attributeTypeIndex, SimpleFeatureType type) throws IllegalFilterException {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        AttributeDescriptor attributeType = type.getDescriptor(attributeTypeIndex);
        this.expr = factory.property(attributeType.getLocalName());
        AverageVisitor.createStrategy(attributeType.getType().getBinding());
    }

    public AverageVisitor(String attrName, SimpleFeatureType type) throws IllegalFilterException {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        AttributeDescriptor attributeType = type.getDescriptor(attrName);
        this.expr = factory.property(attributeType.getLocalName());
        AverageVisitor.createStrategy(attributeType.getType().getBinding());
    }

    public AverageVisitor(Expression expr) throws IllegalFilterException {
        this.expr = expr;
    }

    public void init(SimpleFeatureCollection collection) {
    }

    @Override
    public List<Expression> getExpressions() {
        return Arrays.asList(this.expr);
    }

    @Override
    public Optional<List<Class>> getResultType(List<Class> inputTypes) {
        if (inputTypes == null || inputTypes.size() != 1) {
            throw new IllegalArgumentException("Expecting a single type in input, not " + inputTypes);
        }
        Class type = inputTypes.get(0);
        if (Number.class.isAssignableFrom(type)) {
            return Optional.of(Collections.singletonList(Double.class));
        }
        throw new IllegalArgumentException("The input type for sum must be numeric, instead this was found: " + type);
    }

    private static AverageStrategy createStrategy(Class type) {
        if (type == Integer.class) {
            return new IntegerAverageStrategy();
        }
        if (type == Long.class) {
            return new LongAverageStrategy();
        }
        if (type == Float.class) {
            return new FloatAverageStrategy();
        }
        if (Number.class.isAssignableFrom(type)) {
            return new DoubleAverageStrategy();
        }
        return null;
    }

    public void visit(SimpleFeature feature) {
        this.visit((Feature)feature);
    }

    public void visit(Feature feature) {
        Object value = this.expr.evaluate((Object)feature);
        if (value != null) {
            if (this.strategy == null) {
                Class<?> type = value.getClass();
                this.strategy = AverageVisitor.createStrategy(type);
            }
            this.strategy.add(value);
        }
    }

    public Expression getExpression() {
        return this.expr;
    }

    public Object getAverage() {
        return this.strategy.getResult();
    }

    public void reset() {
        this.strategy = null;
        this.isOptimized = false;
    }

    @Override
    public CalcResult getResult() {
        if (this.strategy == null) {
            return CalcResult.NULL_RESULT;
        }
        return new AverageResult(this.strategy, this.isOptimized);
    }

    public void setValue(Object newAverage) {
        this.reset();
        if (newAverage instanceof AverageStrategy) {
            Class<?> type = newAverage.getClass();
            this.strategy = AverageVisitor.createStrategy(type);
            this.strategy.add(newAverage);
            this.isOptimized = true;
        } else if (newAverage instanceof Number) {
            this.strategy = new FixedResultAverageStrategy((Number)newAverage);
            this.isOptimized = true;
        } else {
            throw new IllegalArgumentException("Cannot set the value, should be a Number or an AverageStrategy");
        }
    }

    public void setValue(int newCount, Object newSum) {
        this.reset();
        this.strategy = AverageVisitor.createStrategy(newSum.getClass());
        this.strategy.set(newCount, newSum);
        this.isOptimized = false;
    }

    public static class AverageResult
    extends AbstractCalcResult {
        private AverageStrategy averageStrategy;
        private boolean isOptimized = false;

        public AverageResult(Object value) {
            if (value instanceof AverageStrategy) {
                this.averageStrategy = (AverageStrategy)value;
            } else if (value instanceof Number) {
                this.averageStrategy = new FixedResultAverageStrategy((Number)value);
            } else {
                throw new IllegalArgumentException("Cannot build an AverageResult using " + value + ", must be a Number or an instance of AverageStrategy");
            }
        }

        public AverageResult(Object newAverageStrategy, boolean isOptimized) {
            this.averageStrategy = (AverageStrategy)newAverageStrategy;
            this.isOptimized = isOptimized;
        }

        public AverageResult(int newCount, Object newSum) {
            this.averageStrategy = AverageVisitor.createStrategy(newSum.getClass());
            this.averageStrategy.set(newCount, newSum);
        }

        public Object getResult() {
            return this.averageStrategy.getResult();
        }

        @Override
        public Object getValue() {
            return this.averageStrategy.getResult();
        }

        public int getCount() {
            if (this.isOptimized) {
                return -1;
            }
            return this.averageStrategy.getCount();
        }

        public Object getSum() {
            if (this.isOptimized) {
                return null;
            }
            return this.averageStrategy.getSum();
        }

        @Override
        public boolean isCompatible(CalcResult targetResults) {
            return targetResults instanceof AverageResult || targetResults == CalcResult.NULL_RESULT;
        }

        @Override
        public CalcResult merge(CalcResult resultsToAdd) {
            if (!this.isCompatible(resultsToAdd)) {
                throw new IllegalArgumentException("Parameter is not a compatible type");
            }
            if (resultsToAdd == CalcResult.NULL_RESULT) {
                return this;
            }
            if (resultsToAdd instanceof AverageResult) {
                AverageResult moreResults = (AverageResult)resultsToAdd;
                if (this.isOptimized || moreResults.isOptimized) {
                    throw new IllegalArgumentException("Optimized average results cannot be merged.");
                }
                Number[] sums = new Number[]{(Number)this.averageStrategy.getSum(), (Number)moreResults.averageStrategy.getSum()};
                Number newSum = CalcUtil.sum(sums);
                Integer newCount = this.averageStrategy.getCount() + moreResults.averageStrategy.getCount();
                Object[] params = new Number[]{newSum, newCount};
                Object newAverage = CalcUtil.getObject(params);
                AverageStrategy newAverageObj = AverageVisitor.createStrategy(newAverage.getClass());
                newAverageObj.set(newCount, newSum);
                return new AverageResult(newAverageObj);
            }
            throw new IllegalArgumentException("The CalcResults claim to be compatible, but the appropriate merge method has not been implemented.");
        }
    }

    static class FixedResultAverageStrategy
    implements AverageStrategy {
        private static final String NO_MERGE_ERROR = "This strategy does not support merge with other results";
        Number result;

        public FixedResultAverageStrategy(Number result) {
            this.result = result;
        }

        @Override
        public void add(Object value) {
            throw new UnsupportedOperationException(NO_MERGE_ERROR);
        }

        @Override
        public Object getResult() {
            return this.result;
        }

        @Override
        public Object getSum() {
            throw new UnsupportedOperationException(NO_MERGE_ERROR);
        }

        @Override
        public int getCount() {
            throw new UnsupportedOperationException(NO_MERGE_ERROR);
        }

        @Override
        public void set(int newCount, Object sum) {
            throw new UnsupportedOperationException(NO_MERGE_ERROR);
        }
    }

    static class IntegerAverageStrategy
    implements AverageStrategy {
        int number = 0;
        int count = 0;

        IntegerAverageStrategy() {
        }

        @Override
        public void add(Object value) {
            this.number += ((Number)value).intValue();
            ++this.count;
        }

        @Override
        public Object getResult() {
            return (double)this.number / (double)this.count;
        }

        @Override
        public Object getSum() {
            return this.number;
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        public void set(int newCount, Object sum) {
            this.number = ((Number)sum).intValue();
            this.count = newCount;
        }
    }

    static class LongAverageStrategy
    implements AverageStrategy {
        long number = 0L;
        int count = 0;

        LongAverageStrategy() {
        }

        @Override
        public void add(Object value) {
            this.number += ((Number)value).longValue();
            ++this.count;
        }

        @Override
        public Object getResult() {
            return (double)this.number / (double)this.count;
        }

        @Override
        public Object getSum() {
            return this.number;
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        public void set(int newCount, Object sum) {
            this.number = ((Number)sum).longValue();
            this.count = newCount;
        }
    }

    static class FloatAverageStrategy
    implements AverageStrategy {
        float number = 0.0f;
        int count = 0;

        FloatAverageStrategy() {
        }

        @Override
        public void add(Object value) {
            this.number += ((Number)value).floatValue();
            ++this.count;
        }

        @Override
        public Object getResult() {
            return Float.valueOf(this.number / (float)this.count);
        }

        @Override
        public Object getSum() {
            return Float.valueOf(this.number);
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        public void set(int newCount, Object sum) {
            this.number = ((Number)sum).floatValue();
            this.count = newCount;
        }
    }

    static class DoubleAverageStrategy
    implements AverageStrategy {
        double number = 0.0;
        int count = 0;

        DoubleAverageStrategy() {
        }

        @Override
        public void add(Object value) {
            this.number += ((Number)value).doubleValue();
            ++this.count;
        }

        @Override
        public Object getResult() {
            return this.number / (double)this.count;
        }

        @Override
        public Object getSum() {
            return this.number;
        }

        @Override
        public int getCount() {
            return this.count;
        }

        @Override
        public void set(int newCount, Object sum) {
            this.number = ((Number)sum).doubleValue();
            this.count = newCount;
        }
    }

    static interface AverageStrategy {
        public void add(Object var1);

        public Object getResult();

        public Object getSum();

        public int getCount();

        public void set(int var1, Object var2);
    }
}

