/*
 * Decompiled with CFR 0.152.
 */
package net.opengis.wmts.v_1;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ResourceTypeType implements Enumerator
{
    TILE(0, "tile", "tile"),
    FEATURE_INFO(1, "FeatureInfo", "FeatureInfo");

    public static final int TILE_VALUE = 0;
    public static final int FEATURE_INFO_VALUE = 1;
    private static final ResourceTypeType[] VALUES_ARRAY;
    public static final List<ResourceTypeType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static ResourceTypeType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ResourceTypeType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static ResourceTypeType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ResourceTypeType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static ResourceTypeType get(int value) {
        switch (value) {
            case 0: {
                return TILE;
            }
            case 1: {
                return FEATURE_INFO;
            }
        }
        return null;
    }

    private ResourceTypeType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new ResourceTypeType[]{TILE, FEATURE_INFO};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

