/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.main;

import com.google.common.collect.Maps;
import com.google.common.xml.XmlEscapers;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.metamodel.SingularAttribute;
import jeeves.component.ProfileManager;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.apache.commons.codec.digest.DigestUtils;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.SystemInfo;
import org.fao.geonet.domain.Group_;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.ReservedGroup;
import org.fao.geonet.domain.Setting;
import org.fao.geonet.domain.Source;
import org.fao.geonet.domain.Source_;
import org.fao.geonet.domain.User_;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.region.RegionsDAO;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.IsoLanguageRepository;
import org.fao.geonet.repository.LanguageRepository;
import org.fao.geonet.repository.MetadataCategoryRepository;
import org.fao.geonet.repository.OperationRepository;
import org.fao.geonet.repository.SettingRepository;
import org.fao.geonet.repository.SortUtils;
import org.fao.geonet.repository.SourceRepository;
import org.fao.geonet.repository.StatusValueRepository;
import org.fao.geonet.repository.UserGroupRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.repository.specification.GroupSpecs;
import org.fao.geonet.repository.specification.SettingSpec;
import org.fao.geonet.repository.specification.UserGroupSpecs;
import org.fao.geonet.repository.specification.UserSpecs;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.util.StringUtils;

@Deprecated
public class Info
implements Service {
    public static final String SYSTEMINFO = "systeminfo";
    public static final String STATUS = "status";
    public static final String AUTH = "auth";
    public static final String ME = "me";
    public static final String TEMPLATES = "templates";
    public static final String USERS = "users";
    public static final String SOURCES = "sources";
    public static final String ISOLANGUAGES = "isolanguages";
    public static final String LANGUAGES = "languages";
    public static final String REGIONS = "regions";
    public static final String OPERATIONS = "operations";
    public static final String GROUPS_INCLUDING_SYSTEM_GROUPS = "groupsIncludingSystemGroups";
    public static final String GROUPS = "groups";
    public static final String GROUPS_ALL = "groupsAll";
    public static final String CATEGORIES = "categories";
    public static final String USER_GROUP_ONLY = "userGroupOnly";
    public static final String HARVESTER = "harvester";
    public static final String INSPIRE = "inspire";
    public static final String CONFIG = "config";
    public static final String SITE = "site";
    private static final String READ_ONLY = "readonly";
    private static final String INDEX = "index";
    private static final String SCHEMAS = "schemas";
    private static final String STAGING_PROFILE = "stagingProfile";
    private Path xslPath;
    private Path otherSheets;
    private ServiceConfig _config;

    public void init(Path appPath, ServiceConfig config) throws Exception {
        this.xslPath = appPath.resolve("xsl").resolve("xml");
        this.otherSheets = appPath.resolve("xsl");
        this._config = config;
    }

    public Element exec(Element inParams, ServiceContext context) throws Exception {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        SettingManager sm = (SettingManager)gc.getBean(SettingManager.class);
        Element params = (Element)inParams.clone();
        String ptype = this._config.getValue("type");
        if (ptype != null) {
            params.removeContent();
            params.addContent((Content)new Element("type").setText(ptype));
        }
        Element result = new Element("root");
        List types = params.getChildren("type");
        for (Element el : types) {
            Element r;
            String type = el.getText();
            if (type.equals(SITE)) {
                result.addContent((Content)((SettingManager)gc.getBean(SettingManager.class)).getValues(new String[]{"system/site/name", "system/site/organization", "system/site/siteId", "system/platform/version", "system/platform/subVersion"}));
                continue;
            }
            if (type.equals(CONFIG)) {
                List publicSettings = ((SettingRepository)context.getBean(SettingRepository.class)).findAllByInternal(false);
                ArrayList<String> publicSettingsKey = new ArrayList<String>();
                for (Setting s : publicSettings) {
                    publicSettingsKey.add(s.getName());
                }
                Element configElement = new Element(CONFIG);
                Element settingsElement = ((SettingManager)gc.getBean(SettingManager.class)).getValues(publicSettingsKey.toArray(new String[0]));
                String mailServerHost = ((SettingManager)gc.getBean(SettingManager.class)).getValue("system/feedback/mailServer/host");
                Element mailServerElement = new Element("setting");
                mailServerElement.setAttribute("name", "system/mail/enable");
                mailServerElement.setAttribute("value", !StringUtils.isEmpty((Object)mailServerHost) + "");
                settingsElement.addContent((Content)mailServerElement);
                configElement.addContent((Content)settingsElement);
                result.addContent((Content)configElement);
                continue;
            }
            if (type.equals(INSPIRE)) {
                result.addContent((Content)((SettingManager)gc.getBean(SettingManager.class)).getValues(new String[]{"system/inspire/enable"}));
                continue;
            }
            if (type.equals(HARVESTER)) {
                result.addContent((Content)((SettingManager)gc.getBean(SettingManager.class)).getValues(new String[]{"system/harvester/enableEditing", "system/harvester/enablePrivilegesManagement"}));
                continue;
            }
            if (type.equals(USER_GROUP_ONLY)) {
                result.addContent((Content)((SettingManager)gc.getBean(SettingManager.class)).getValues(new String[]{"system/metadataprivs/usergrouponly"}));
                continue;
            }
            if (type.equals(CATEGORIES)) {
                result.addContent((Content)((MetadataCategoryRepository)context.getBean(MetadataCategoryRepository.class)).findAllAsXml());
                continue;
            }
            if (type.equals(GROUPS)) {
                String profile = params.getChildText("profile");
                Element r2 = this.getGroups(context, Profile.findProfileIgnoreCase((String)profile), false, false);
                result.addContent((Content)r2);
                continue;
            }
            if (type.equals(GROUPS_INCLUDING_SYSTEM_GROUPS)) {
                r = this.getGroups(context, null, true, false);
                result.addContent((Content)r);
                continue;
            }
            if (type.equals(GROUPS_ALL)) {
                r = this.getGroups(context, null, false, true);
                result.addContent((Content)r);
                continue;
            }
            if (type.equals(OPERATIONS)) {
                result.addContent((Content)((OperationRepository)context.getBean(OperationRepository.class)).findAllAsXml());
                continue;
            }
            if (type.equals(REGIONS)) {
                RegionsDAO dao = (RegionsDAO)context.getBean(RegionsDAO.class);
                Element regions = dao.createSearchRequest(context).xmlResult();
                result.addContent((Content)regions);
                continue;
            }
            if (type.equals(ISOLANGUAGES)) {
                result.addContent((Content)((IsoLanguageRepository)context.getBean(IsoLanguageRepository.class)).findAllAsXml());
                continue;
            }
            if (type.equals(LANGUAGES)) {
                result.addContent((Content)((LanguageRepository)context.getBean(LanguageRepository.class)).findAllAsXml());
                continue;
            }
            if (type.equals(SOURCES)) {
                result.addContent((Content)this.getSources(context, sm));
                continue;
            }
            if (type.equals(USERS)) {
                result.addContent((Content)this.getUsers(context));
                continue;
            }
            if (type.equals(ME)) {
                result.addContent((Content)this.getMyInfo(context));
                continue;
            }
            if (type.equals(AUTH)) {
                result.addContent((Content)this.getAuth(context));
                continue;
            }
            if (type.equals(READ_ONLY)) {
                result.addContent((Content)this.getReadOnly(gc));
                continue;
            }
            if (type.equals(INDEX)) {
                result.addContent((Content)this.getIndex(gc));
                continue;
            }
            if (type.equals(SCHEMAS)) {
                result.addContent((Content)this.getSchemas((SchemaManager)gc.getBean(SchemaManager.class)));
                continue;
            }
            if (type.equals(STATUS)) {
                result.addContent((Content)((StatusValueRepository)context.getBean(StatusValueRepository.class)).findAllAsXml());
                continue;
            }
            if (type.equals(SYSTEMINFO)) {
                result.addContent((Content)((SystemInfo)context.getBean(SystemInfo.class)).toXml());
                continue;
            }
            if (type.equals(STAGING_PROFILE)) {
                result.addContent((Content)new Element(STAGING_PROFILE).setText(((SystemInfo)context.getBean(SystemInfo.class)).getStagingProfile()));
                continue;
            }
            throw new BadParameterEx("Unknown type parameter value.", (Object)type);
        }
        result.addContent((Content)this.getEnv(context));
        Element response = Xml.transform((Element)result, (Path)this.xslPath.resolve("info.xsl"));
        return response;
    }

    private Element getIndex(GeonetContext gc) {
        Element isIndexing = new Element(INDEX);
        isIndexing.setText(Boolean.toString(((DataManager)gc.getBean(DataManager.class)).isIndexing()));
        return isIndexing;
    }

    private Element getReadOnly(GeonetContext gc) {
        Element readOnly = new Element(READ_ONLY);
        readOnly.setText(Boolean.toString(gc.isReadOnly()));
        return readOnly;
    }

    private Element getAuth(ServiceContext context) {
        Element auth = new Element(AUTH);
        Element cas = new Element("casEnabled").setText(Boolean.toString(ProfileManager.isCasEnabled()));
        auth.addContent((Content)cas);
        return auth;
    }

    private Element getMyInfo(ServiceContext context) {
        Element data = new Element(ME);
        UserSession userSession = context.getUserSession();
        if (userSession.isAuthenticated()) {
            data.setAttribute("authenticated", "true");
            String emailAddr = userSession.getEmailAddr();
            data.addContent((Content)new Element("profile").setText(userSession.getProfile().name())).addContent((Content)new Element("username").setText(userSession.getUsername())).addContent((Content)new Element("id").setText(userSession.getUserId())).addContent((Content)new Element("name").setText(userSession.getName())).addContent((Content)new Element("surname").setText(userSession.getSurname())).addContent((Content)new Element("email").setText(emailAddr)).addContent((Content)new Element("organisation").setText(userSession.getOrganisation()));
            if (emailAddr != null) {
                data.addContent((Content)new Element("hash").setText(DigestUtils.md5Hex((String)emailAddr)));
            } else {
                data.addContent((Content)new Element("hash").setText(""));
            }
        } else {
            data.setAttribute("authenticated", "false");
        }
        return data;
    }

    private Element getSchemas(SchemaManager schemaMan) throws Exception {
        Element response = new Element(SCHEMAS);
        for (String schema : schemaMan.getSchemas()) {
            Element elem = new Element("schema").addContent((Content)new Element("name").setText(schema)).addContent((Content)new Element("id").setText((String)schemaMan.getIdVersion(schema).one())).addContent((Content)new Element("version").setText((String)schemaMan.getIdVersion(schema).two())).addContent((Content)new Element("description").setText(schema)).addContent((Content)new Element("namespaces").setText(schemaMan.getNamespaceString(schema)));
            if (schemaMan.getSchema(schema).canEdit()) {
                elem.addContent((Content)new Element("edit").setText("true"));
            } else {
                elem.addContent((Content)new Element("edit").setText("false"));
            }
            List convElems = schemaMan.getConversionElements(schema);
            if (convElems.size() > 0) {
                Element conv = new Element("conversions");
                conv.addContent((Collection)convElems);
                elem.addContent((Content)conv);
            }
            response.addContent((Content)elem);
        }
        return response;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Element getGroups(ServiceContext context, Profile profile, boolean includingSystemGroups, boolean all) throws SQLException {
        GroupRepository groupRepository = (GroupRepository)context.getBean(GroupRepository.class);
        UserGroupRepository userGroupRepository = (UserGroupRepository)context.getBean(UserGroupRepository.class);
        Sort sort = SortUtils.createSort((SingularAttribute[])new SingularAttribute[]{Group_.id});
        UserSession session = context.getUserSession();
        if (all) return groupRepository.findAllAsXml(Specification.not((Specification)GroupSpecs.isReserved()), sort);
        if (!session.isAuthenticated()) {
            return groupRepository.findAllAsXml(Specification.not((Specification)GroupSpecs.isReserved()), sort);
        }
        if (Profile.Administrator == session.getProfile()) {
            if (!includingSystemGroups) return groupRepository.findAllAsXml(Specification.not((Specification)GroupSpecs.isReserved()), sort);
            return groupRepository.findAllAsXml(null, sort);
        }
        Specification spec = Specification.where((Specification)UserGroupSpecs.hasUserId((int)session.getUserIdAsInt()));
        if (profile != null) {
            spec = spec.and(UserGroupSpecs.hasProfile((Profile)profile));
        }
        HashSet<Integer> ids = new HashSet<Integer>(userGroupRepository.findGroupIds(spec));
        if (includingSystemGroups) {
            for (ReservedGroup reservedGroup : ReservedGroup.values()) {
                ids.add(reservedGroup.getId());
            }
        }
        Element groups = groupRepository.findAllAsXml(null, sort);
        return Lib.element.pruneChildren(groups, ids);
    }

    private Element getSources(ServiceContext context, SettingManager sm) throws SQLException {
        Element element = new Element("results");
        List sourceList = ((SourceRepository)context.getBean(SourceRepository.class)).findAll(SortUtils.createSort((SingularAttribute[])new SingularAttribute[]{Source_.name}));
        HashSet<String> sourceIds = new HashSet<String>();
        for (Source o : sourceList) {
            if (sourceIds.contains(o.getUuid())) continue;
            element.addContent((Content)this.buildRecord(o.getUuid(), o.getName(), o.getLabelTranslations(), null, null));
            sourceIds.add(o.getUuid());
        }
        String siteId = sm.getSiteId();
        if (!sourceIds.contains(siteId)) {
            String siteName = sm.getSiteName();
            SettingRepository settingRepository = (SettingRepository)context.getBean(SettingRepository.class);
            List labelSettings = settingRepository.findAll(SettingSpec.nameStartsWith((String)"system/site/labels/"));
            HashMap labels = Maps.newHashMap();
            for (Setting setting : labelSettings) {
                labels.put(setting.getName().substring("system/site/labels/".length()), setting.getValue());
            }
            element.addContent((Content)this.buildRecord(siteId, siteName, labels, null, null));
        }
        return element;
    }

    private Element buildTemplateRecord(String id, String title, String schema) {
        return this.buildRecord(id, title, Collections.emptyMap(), schema, null);
    }

    private Element buildRecord(String id, String name, Map<String, String> labelTranslations, String code, String serverCode) {
        Element el = new Element("record");
        Element idE = new Element("id").setText(id);
        if (code != null) {
            idE.setAttribute("code", code);
        }
        if (serverCode != null) {
            idE.setAttribute("serverCode", serverCode);
        }
        el.addContent((Content)idE);
        el.addContent((Content)new Element("name").setText(name));
        Element translations = new Element("label");
        el.addContent((Content)translations);
        for (Map.Entry<String, String> entry : labelTranslations.entrySet()) {
            translations.addContent((Content)new Element(entry.getKey()).setText(XmlEscapers.xmlContentEscaper().escape(entry.getValue())));
        }
        return el;
    }

    private Element getUsers(ServiceContext context) throws SQLException {
        UserSession us = context.getUserSession();
        List<Element> list = this.getUsers(context, us);
        Element users = new Element(USERS);
        for (Element user : list) {
            user = (Element)user.clone();
            user.removeChild("password");
            user.setName("user");
            users.addContent((Content)user);
        }
        return users;
    }

    private List<Element> getUsers(ServiceContext context, UserSession us) throws SQLException {
        if (!us.isAuthenticated()) {
            return new ArrayList<Element>();
        }
        int userId = Integer.parseInt(us.getUserId());
        UserRepository userRepository = (UserRepository)context.getBean(UserRepository.class);
        if (us.getProfile() == Profile.Administrator) {
            List allUsers = userRepository.findAllAsXml().getChildren();
            return allUsers;
        }
        if (us.getProfile() != Profile.UserAdmin) {
            List identifiedUsers = userRepository.findAllAsXml(UserSpecs.hasUserId((int)userId)).getChildren();
            return identifiedUsers;
        }
        Set<Integer> hsMyGroups = this.getUserGroups(context, userId);
        Set profileSet = us.getProfile().getAllNames();
        Element elUsers = userRepository.findAllAsXml(null, SortUtils.createSort((SingularAttribute[])new SingularAttribute[]{User_.name}));
        ArrayList<Element> alToRemove = new ArrayList<Element>();
        for (Object o : elUsers.getChildren()) {
            Element elRec = (Element)o;
            String sUserId = elRec.getChildText("id");
            String profile = elRec.getChildText("profile");
            if (!profileSet.contains(profile)) {
                alToRemove.add(elRec);
                continue;
            }
            if (hsMyGroups.containsAll(this.getUserGroups(context, Integer.parseInt(sUserId)))) continue;
            alToRemove.add(elRec);
        }
        for (int i = 0; i < alToRemove.size(); ++i) {
            ((Element)alToRemove.get(i)).detach();
        }
        List usersEls = elUsers.getChildren();
        return usersEls;
    }

    private Set<Integer> getUserGroups(ServiceContext context, int userId) throws SQLException {
        UserGroupRepository userGroupRepository = (UserGroupRepository)context.getBean(UserGroupRepository.class);
        return new HashSet<Integer>(userGroupRepository.findGroupIds(UserGroupSpecs.hasUserId((int)userId)));
    }

    private Element getEnv(ServiceContext context) {
        return new Element("env").addContent((Content)new Element("baseURL").setText(context.getBaseUrl())).addContent((Content)new Element("node").setText(context.getNodeId()));
    }
}

