/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.site;

import java.net.URISyntaxException;
import java.net.URL;
import java.util.Optional;
import org.apache.log4j.xml.DOMConfigurator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.status.StatusLogger;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.domain.Setting;
import org.fao.geonet.exceptions.OperationAbortedEx;
import org.fao.geonet.repository.SettingRepository;

public class LogUtils {
    static final String DEFAULT_LOG_FILE = "log4j2.xml";

    public static void refreshLogConfiguration() {
        block6: {
            StatusLogger CONFIG_LOG = StatusLogger.getLogger();
            SettingRepository repository = (SettingRepository)ApplicationContextHolder.get().getBean(SettingRepository.class);
            Optional settingOpt = repository.findById((Object)"system/server/log");
            Setting setting = null;
            if (settingOpt.isPresent()) {
                setting = (Setting)settingOpt.get();
            }
            String log4jProp = setting != null ? setting.getValue() : DEFAULT_LOG_FILE;
            URL url = LogUtils.class.getResource("/" + log4jProp);
            try {
                if (url != null) {
                    if (log4jProp.startsWith("log4j2")) {
                        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
                        CONFIG_LOG.info("Load log4j2 config from '" + url + "'");
                        loggerContext.setConfigLocation(url.toURI());
                    } else {
                        CONFIG_LOG.info("Load log4j config from '" + url + "'");
                        DOMConfigurator.configure((URL)url);
                    }
                    break block6;
                }
                CONFIG_LOG.info("Unable  to load '" + log4jProp + "', using '" + DEFAULT_LOG_FILE + "'");
                DOMConfigurator.configure((URL)LogUtils.class.getResource("/log4j2.xml"));
                throw new OperationAbortedEx("Can't refresh log configuration because file '" + log4jProp + "' doesn't exist. Using log4j.xml.");
            }
            catch (RuntimeException | URISyntaxException unsuccessful) {
                CONFIG_LOG.info("Unable  to load '" + log4jProp + "', using '" + DEFAULT_LOG_FILE + "'");
                DOMConfigurator.configure((URL)LogUtils.class.getResource("/log4j2.xml"));
                throw new OperationAbortedEx("Can't refresh log configuration '" + log4jProp + "' due to issue with configuration: " + unsuccessful.getMessage(), (Object)unsuccessful);
            }
        }
    }
}

