/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters.groovy.template;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

public enum TemplateType {
    XML,
    TEXT;


    public static TemplateType fromContentType(String type) {
        if (type.contains("xml") || type.contains("html") || type.contains("xsd") || type.contains("xsl")) {
            return XML;
        }
        return TEXT;
    }

    public static TemplateType fromPath(Path path) throws IOException {
        String type = Files.probeContentType(path);
        if (type == null) {
            String file = path.getFileName().toString();
            if (file.endsWith(".xsd") || file.endsWith(".html") || file.endsWith(".xml")) {
                return XML;
            }
            return TEXT;
        }
        return TemplateType.fromContentType(Files.probeContentType(path));
    }
}

