/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters.groovy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import groovy.util.XmlSlurper;
import groovy.util.slurpersupport.GPathResult;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fao.geonet.api.records.formatters.groovy.Environment;
import org.fao.geonet.api.records.formatters.groovy.Functions;
import org.fao.geonet.api.records.formatters.groovy.Handlers;
import org.fao.geonet.api.records.formatters.groovy.TransformationContext;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.xml.sax.SAXException;

public class Transformer {
    private final Handlers handlers;
    private final Path formatterPath;
    private final Functions functions;
    private final Environment env;

    public Transformer(Handlers handlers, Functions functions, Environment env, Path formatterPath) {
        this.handlers = handlers;
        this.functions = functions;
        this.env = env;
        handlers.prepareForTransformer();
        this.formatterPath = formatterPath;
    }

    public String apply(Element metadata, List<Namespace> namespaces) throws Exception {
        TransformationContext context = new TransformationContext(this.handlers, this.functions, this.env);
        context.setThreadLocal();
        HashMap namespaceUriToPrefix = Maps.newHashMap();
        for (Namespace namespace : namespaces) {
            namespaceUriToPrefix.put(namespace.getPrefix(), namespace.getURI());
        }
        XmlSlurper xmlSlurper = new XmlSlurper(false, false);
        StringBuilder resultantXml = new StringBuilder();
        this.handlers.startHandler.handle(resultantXml);
        Set<String> rootXpaths = this.handlers.getRoots();
        if (rootXpaths.isEmpty()) {
            this.processRoot(context, namespaceUriToPrefix, xmlSlurper, resultantXml, (Content)metadata);
        }
        for (String rootXpath : rootXpaths) {
            List roots = Xml.selectNodes((Element)metadata, (String)rootXpath, namespaces);
            for (Content root : roots) {
                this.processRoot(context, namespaceUriToPrefix, xmlSlurper, resultantXml, root);
            }
        }
        this.handlers.endHandler.handle(resultantXml);
        try {
            return resultantXml.toString();
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.formatter", (String)("Error parsing the resulting XML from '" + this.formatterPath + "' formatter.  Resulting XML is: " + resultantXml), (Throwable)e);
            throw e;
        }
    }

    private void processRoot(TransformationContext context, Map<String, String> namespaceUriToPrefix, XmlSlurper xmlSlurper, StringBuilder resultantXml, Content root) throws IOException, SAXException {
        GPathResult md = xmlSlurper.parseText(Xml.getString((Element)((Element)root))).declareNamespace(namespaceUriToPrefix);
        if (md.size() == 0) {
            throw new IllegalArgumentException("There are no elements parsed from the xml");
        }
        StringBuilder path = new StringBuilder();
        this.createPath(root.getParentElement(), path);
        context.setRootPath(path.toString());
        this.handlers.transformationEngine.processElement(context, md, md.children().list(), resultantXml);
    }

    private void createPath(Element node, StringBuilder path) {
        if (node == null) {
            return;
        }
        if (node.getParentElement() != null) {
            this.createPath(node.getParentElement(), path);
            path.append(">");
        }
        path.append(node.getQualifiedName());
    }

    @VisibleForTesting
    public Handlers getHandlers() {
        return this.handlers;
    }
}

