/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.extent;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import jeeves.server.context.ServiceContext;
import jeeves.services.ReadWriteController;
import org.apache.commons.lang3.StringUtils;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.records.extent.ExtentDto;
import org.fao.geonet.api.records.extent.MapRenderer;
import org.fao.geonet.api.regions.MetadataRegionDAO;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.region.Request;
import org.fao.geonet.kernel.schema.MetadataSchema;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.utils.XPath;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.NativeWebRequest;

@RequestMapping(value={"/{portal}/api/records"})
@Tag(name="records", description="Metadata record operations")
@RestController(value="recordExtent")
@ReadWriteController
public class MetadataExtentApi {
    public static final String MAP_SRS_PARAM = "mapsrs";
    public static final String GEOM_SRS_PARAM = "geomsrs";
    public static final String WIDTH_PARAM = "width";
    public static final String GEOM_PARAM = "geom";
    public static final String GEOM_TYPE_PARAM = "geomtype";
    public static final String HEIGHT_PARAM = "height";
    public static final String BACKGROUND_PARAM = "background";
    public static final String SETTING_BACKGROUND = "settings";
    public static final String WIDTH_AND_HEIGHT_BOTH_DEFINED_MESSAGE = String.format("Only one of %s and %s can be defined currently.  Future versions may support this but it is not supported at the moment", "width", "height");
    public static final String WIDTH_AND_HEIGHT_BOTH_MISSING_MESSAGE = String.format("One of %s or %s parameters must be included in the request", "width", "height");
    private static final String API_EXTENT_DESCRIPTION = "A rendering of the geometry as a png. If no background is specified the image will be transparent. In getMap the envelope of the geometry is calculated then it is expanded by a factor.  That factor is the size of the map.  This allows the map to be slightly bigger than the geometry allowing some context to be shown. This parameter allows different factors to be chosen per scale level.\nProportion is the proportion of the world that the geometry covers (bounds of WGS84)/(bounds of geometry in WGS84)\n\nNamed backgrounds allow the background parameter to be a simple key and the complete URL will be looked up from this list of named backgrounds\n";
    private static final String API_PARAM_MAP_SRS_DESCRIPTION = "(optional) the background map projection. If not passed uses the region/getmap/mapproj setting. If the setting is not set defaults to EPSG:4326";
    private static final String API_PARAM_WIDTH_DESCRIPTION = "(optional) width of the image that is created. Only one of width and height are permitted";
    private static final String API_PARAM_HEIGHT_DESCRIPTION = "(optional) height of the image that is created. Only one of width and height are permitted";
    private static final String API_PARAM_BG_DESCRIPTION = "(optional) URL for loading a background image for regions or a key that references the namedBackgrounds (configured in config-spring-geonetwork.xml). A WMS GetMap request is the typical example. The URL must be parameterized with the following parameters: minx, maxx, miny, maxy, width, height";
    private static final String API_PARAM_FILL_DESCRIPTION = "(optional) Fill color with format RED,GREEN,BLUE,ALPHA";
    private static final String API_PARAM_STROKE_DESCRIPTION = "(optional) Stroke color with format RED,GREEN,BLUE,ALPHA";
    private static final String EXTENT_XPATH = ".//*[local-name() ='extent']/*/*[local-name() = 'geographicElement']/*";
    private static final String EXTENT_DESCRIPTION_XPATH = "ancestor::*[local-name() = 'EX_Extent']/*[local-name() = 'description']/*/text()";
    @Autowired
    private MetadataRegionDAO metadataRegionDAO;
    @Autowired
    private SchemaManager schemaManager;
    @Autowired
    private SettingManager settingManager;
    @Value(value="${metadata.extentApi.disableFullUrlBackgroundMapServices:true}")
    private boolean disableFullUrlBackgroundMapServices;

    @Operation(summary="Get record extents as image", description="A rendering of the geometry as a png. If no background is specified the image will be transparent. In getMap the envelope of the geometry is calculated then it is expanded by a factor.  That factor is the size of the map.  This allows the map to be slightly bigger than the geometry allowing some context to be shown. This parameter allows different factors to be chosen per scale level.\nProportion is the proportion of the world that the geometry covers (bounds of WGS84)/(bounds of geometry in WGS84)\n\nNamed backgrounds allow the background parameter to be a simple key and the complete URL will be looked up from this list of named backgrounds\n")
    @GetMapping(value={"/{metadataUuid}/extents.png"}, produces={"image/png"})
    public HttpEntity<byte[]> getAllRecordExtentAsImage(@Parameter(description="Record UUID.", required=true) @PathVariable(value="metadataUuid") String metadataUuid, @Parameter(description="(optional) the background map projection. If not passed uses the region/getmap/mapproj setting. If the setting is not set defaults to EPSG:4326") @RequestParam(value="mapsrs", required=false) String mapSrs, @Parameter(description="(optional) width of the image that is created. Only one of width and height are permitted") @RequestParam(value="width", required=false, defaultValue="300") Integer width, @Parameter(description="(optional) height of the image that is created. Only one of width and height are permitted") @RequestParam(value="height", required=false) Integer height, @Parameter(description="(optional) URL for loading a background image for regions or a key that references the namedBackgrounds (configured in config-spring-geonetwork.xml). A WMS GetMap request is the typical example. The URL must be parameterized with the following parameters: minx, maxx, miny, maxy, width, height") @RequestParam(value="background", required=false, defaultValue="settings") String background, @Parameter(description="(optional) Fill color with format RED,GREEN,BLUE,ALPHA") @RequestParam(value="", required=false, defaultValue="0,0,0,50") String fillColor, @Parameter(description="(optional) Stroke color with format RED,GREEN,BLUE,ALPHA") @RequestParam(value="", required=false, defaultValue="0,0,0,255") String strokeColor, @RequestParam(required=false, defaultValue="true") Boolean approved, @Parameter(hidden=true) NativeWebRequest nativeWebRequest, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        String srs = mapSrs;
        if (StringUtils.isBlank((CharSequence)srs)) {
            srs = (String)StringUtils.defaultIfBlank((CharSequence)this.settingManager.getValue("region/getmap/mapproj", true), (CharSequence)"EPSG:4326");
        }
        return this.getExtent(metadataUuid, srs, width, height, background, fillColor, strokeColor, null, approved, nativeWebRequest, request);
    }

    @Operation(summary="Get list of record extents", description="A rendering of the geometry as a png. If no background is specified the image will be transparent. In getMap the envelope of the geometry is calculated then it is expanded by a factor.  That factor is the size of the map.  This allows the map to be slightly bigger than the geometry allowing some context to be shown. This parameter allows different factors to be chosen per scale level.\nProportion is the proportion of the world that the geometry covers (bounds of WGS84)/(bounds of geometry in WGS84)\n\nNamed backgrounds allow the background parameter to be a simple key and the complete URL will be looked up from this list of named backgrounds\n")
    @GetMapping(value={"/{metadataUuid}/extents.json"}, produces={"application/json"})
    public List<ExtentDto> getAllRecordExtentAsJson(@Parameter(description="Record UUID.", required=true) @PathVariable(value="metadataUuid") String metadataUuid, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        AbstractMetadata metadata = ApiUtils.canViewRecord(metadataUuid, request);
        String schemaId = metadata.getDataInfo().getSchemaId();
        MetadataSchema schema = this.schemaManager.getSchema(schemaId);
        Element xmlData = metadata.getXmlData(false);
        List extentList = Xml.selectNodes((Element)xmlData, (String)EXTENT_XPATH, (List)schema.getNamespaces());
        ArrayList<ExtentDto> response = new ArrayList<ExtentDto>(extentList.size() + 1);
        if (!"iso19110".equals(schemaId)) {
            response.add(new ExtentDto(String.format("%sapi/records/%s/extents.png", this.settingManager.getNodeURL(), metadataUuid), "ALL", "", ""));
        }
        int index = 1;
        for (Object extent : extentList) {
            if (!(extent instanceof Element)) continue;
            Element extentElement = (Element)extent;
            String description = Xml.selectString((Element)extentElement, (String)EXTENT_DESCRIPTION_XPATH, (List)schema.getNamespaces());
            response.add(new ExtentDto(String.format("%sapi/records/%s/extents/%d.png", this.settingManager.getNodeURL(), metadataUuid, index), extentElement.getName(), XPath.getXPath((Element)xmlData, extent), description));
            ++index;
        }
        return response;
    }

    @Operation(summary="Get one record extent as image", description="A rendering of the geometry as a png. If no background is specified the image will be transparent. In getMap the envelope of the geometry is calculated then it is expanded by a factor.  That factor is the size of the map.  This allows the map to be slightly bigger than the geometry allowing some context to be shown. This parameter allows different factors to be chosen per scale level.\nProportion is the proportion of the world that the geometry covers (bounds of WGS84)/(bounds of geometry in WGS84)\n\nNamed backgrounds allow the background parameter to be a simple key and the complete URL will be looked up from this list of named backgrounds\n")
    @GetMapping(value={"/{metadataUuid}/extents/{geometryIndex}.png"}, produces={"image/png"})
    public HttpEntity<byte[]> getOneRecordExtentAsImage(@Parameter(description="Record UUID.", required=true) @PathVariable(value="metadataUuid") String metadataUuid, @Parameter(description="Index of the geometry or bounding box to display. Starts at 1.") @PathVariable(value="geometryIndex") Integer geometryIndex, @Parameter(description="(optional) the background map projection. If not passed uses the region/getmap/mapproj setting. If the setting is not set defaults to EPSG:4326") @RequestParam(value="mapsrs", required=false) String mapSrs, @Parameter(description="(optional) width of the image that is created. Only one of width and height are permitted") @RequestParam(value="width", required=false, defaultValue="300") Integer width, @Parameter(description="(optional) height of the image that is created. Only one of width and height are permitted") @RequestParam(value="height", required=false) Integer height, @Parameter(description="(optional) URL for loading a background image for regions or a key that references the namedBackgrounds (configured in config-spring-geonetwork.xml). A WMS GetMap request is the typical example. The URL must be parameterized with the following parameters: minx, maxx, miny, maxy, width, height") @RequestParam(value="background", required=false, defaultValue="settings") String background, @Parameter(description="(optional) Fill color with format RED,GREEN,BLUE,ALPHA") @RequestParam(value="", required=false, defaultValue="0,0,0,50") String fillColor, @Parameter(description="(optional) Stroke color with format RED,GREEN,BLUE,ALPHA") @RequestParam(value="", required=false, defaultValue="0,0,0,255") String strokeColor, @RequestParam(required=false, defaultValue="true") Boolean approved, @Parameter(hidden=true) NativeWebRequest nativeWebRequest, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        String srs = mapSrs;
        if (StringUtils.isBlank((CharSequence)srs)) {
            srs = (String)StringUtils.defaultIfBlank((CharSequence)this.settingManager.getValue("region/getmap/mapproj", true), (CharSequence)"EPSG:4326");
        }
        return this.getExtent(metadataUuid, srs, width, height, background, fillColor, strokeColor, geometryIndex, approved, nativeWebRequest, request);
    }

    private HttpEntity<byte[]> getExtent(String metadataUuid, String srs, Integer width, Integer height, String background, String fillColor, String strokeColor, Integer extentOrderOfAppearance, Boolean approved, NativeWebRequest nativeWebRequest, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata = ApiUtils.canViewRecord(metadataUuid, approved, request);
        ServiceContext context = ApiUtils.createServiceContext(request);
        if (width != null && height != null) {
            throw new BadParameterEx(WIDTH_PARAM, (Object)WIDTH_AND_HEIGHT_BOTH_DEFINED_MESSAGE);
        }
        if (width == null && height == null) {
            throw new BadParameterEx(WIDTH_PARAM, (Object)WIDTH_AND_HEIGHT_BOTH_MISSING_MESSAGE);
        }
        if (background != null && background.startsWith("http") && this.disableFullUrlBackgroundMapServices) {
            throw new BadParameterEx(BACKGROUND_PARAM, (Object)"Background layers from provided are not supported, use a preconfigured background layers map service.");
        }
        String regionId = extentOrderOfAppearance == null ? String.format("metadata:@id%s", metadata.getId()) : String.format("metadata:@id%s:@xpath(%s)[%d]", metadata.getId(), EXTENT_XPATH, extentOrderOfAppearance);
        Request searchRequest = this.metadataRegionDAO.createSearchRequest(context).id(regionId);
        if (searchRequest.getLastModified().isPresent() && nativeWebRequest.checkNotModified(((Long)searchRequest.getLastModified().get()).longValue())) {
            return null;
        }
        MapRenderer renderer = new MapRenderer(context);
        BufferedImage image = renderer.render(regionId, srs, width, height, background, null, null, null, fillColor, strokeColor);
        if (image == null) {
            return null;
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)image, "png", out);
            HttpHeaders headers = new HttpHeaders();
            headers.add((Object)"Content-Disposition", (Object)String.format("inline; filename=\"%s-extent.png\"", metadataUuid));
            headers.add((Object)"Cache-Control", (Object)"no-cache");
            headers.add((Object)"Content-Type", (Object)"image/png");
            HttpEntity httpEntity = new HttpEntity((Object)out.toByteArray(), (MultiValueMap)headers);
            return httpEntity;
        }
    }
}

