/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.http.commons;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.geotools.http.AbstractHttpClient;
import org.geotools.http.HTTPConnectionPooling;
import org.geotools.http.HTTPProxy;
import org.geotools.http.HTTPResponse;
import org.geotools.util.factory.GeoTools;

public class MultithreadedHttpClient
extends AbstractHttpClient
implements HTTPConnectionPooling,
HTTPProxy {
    private final PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
    private HttpClient client;
    private RequestConfig connectionConfig;
    private BasicCredentialsProvider credsProvider = null;

    public MultithreadedHttpClient() {
        this.connectionManager.setMaxTotal(6);
        this.connectionManager.setDefaultMaxPerRoute(6);
        this.connectionConfig = RequestConfig.custom().setCookieSpec("default").setExpectContinueEnabled(true).setSocketTimeout(30000).setConnectTimeout(30000).build();
        this.client = this.builder().build();
    }

    private HttpClientBuilder builder() {
        HttpClientBuilder builder = HttpClientBuilder.create().setUserAgent(String.format("GeoTools/%s (%s)", GeoTools.getVersion(), ((Object)((Object)this)).getClass().getSimpleName())).useSystemProperties().setConnectionManager((HttpClientConnectionManager)this.connectionManager);
        if (this.credsProvider != null) {
            builder.setDefaultCredentialsProvider((CredentialsProvider)this.credsProvider);
        }
        return builder;
    }

    public HttpMethodResponse post(URL url, InputStream postContent, String postContentType) throws IOException {
        InputStreamEntity requestEntity;
        HttpPost postMethod = new HttpPost(url.toExternalForm());
        postMethod.setConfig(this.connectionConfig);
        if (this.credsProvider != null) {
            String input = new BufferedReader(new InputStreamReader(postContent, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
            requestEntity = new StringEntity(input);
        } else {
            requestEntity = new InputStreamEntity(postContent);
        }
        if (this.tryGzip) {
            postMethod.setHeader("Accept-Encoding", "gzip");
        }
        if (postContentType != null) {
            postMethod.setHeader("Content-type", postContentType);
        }
        postMethod.setEntity((HttpEntity)requestEntity);
        HttpMethodResponse response = null;
        try {
            response = this.executeMethod((HttpRequestBase)postMethod);
        }
        catch (HttpException e) {
            throw new IOException(e);
        }
        if (200 != response.getStatusCode()) {
            postMethod.releaseConnection();
            throw new IOException("Server returned HTTP error code " + response.getStatusCode() + " for URL " + url.toExternalForm());
        }
        return response;
    }

    private HttpMethodResponse executeMethod(HttpRequestBase method) throws IOException, HttpException {
        HttpResponse resp;
        HttpClientContext localContext = HttpClientContext.create();
        if (this.credsProvider != null) {
            localContext.setCredentialsProvider((CredentialsProvider)this.credsProvider);
            BasicAuthCache authCache = new BasicAuthCache();
            URI target = method.getURI();
            authCache.put(new HttpHost(target.getHost(), target.getPort(), target.getScheme()), (AuthScheme)new BasicScheme());
            localContext.setAuthCache((AuthCache)authCache);
            resp = this.client.execute((HttpUriRequest)method, (HttpContext)localContext);
        } else {
            resp = this.client.execute((HttpUriRequest)method);
        }
        HttpMethodResponse response = new HttpMethodResponse(resp);
        return response;
    }

    public HTTPResponse get(URL url) throws IOException {
        return this.get(url, null);
    }

    public HTTPResponse get(URL url, Map<String, String> headers) throws IOException {
        if (this.isFile(url)) {
            return this.createFileResponse(url);
        }
        HttpGet getMethod = new HttpGet(url.toExternalForm());
        getMethod.setConfig(this.connectionConfig);
        if (this.tryGzip) {
            getMethod.setHeader("Accept-Encoding", "gzip");
        }
        if (headers != null) {
            for (Map.Entry<String, String> headerNameValue : headers.entrySet()) {
                getMethod.setHeader(headerNameValue.getKey(), headerNameValue.getValue());
            }
        }
        HttpMethodResponse response = null;
        try {
            response = this.executeMethod((HttpRequestBase)getMethod);
        }
        catch (HttpException e) {
            throw new IOException(e);
        }
        if (200 != response.getStatusCode()) {
            getMethod.releaseConnection();
            throw new IOException("Server returned HTTP error code " + response.getStatusCode() + " for URL " + url.toExternalForm());
        }
        return response;
    }

    public void setUser(String user) {
        super.setUser(user);
        this.resetCredentials();
    }

    public void setPassword(String password) {
        super.setPassword(password);
        this.resetCredentials();
    }

    private void resetCredentials() {
        if (this.user != null && this.password != null) {
            AuthScope authscope = AuthScope.ANY;
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.user, this.password);
            this.credsProvider = new BasicCredentialsProvider();
            this.credsProvider.setCredentials(authscope, (Credentials)credentials);
            this.client = this.builder().build();
        } else if (this.credsProvider != null) {
            this.credsProvider = null;
            this.client = this.builder().build();
        }
    }

    public int getConnectTimeout() {
        return this.connectionConfig.getConnectionRequestTimeout() / 1000;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectionConfig = RequestConfig.copy((RequestConfig)this.connectionConfig).setConnectionRequestTimeout(connectTimeout * 1000).build();
    }

    public int getReadTimeout() {
        return this.connectionConfig.getSocketTimeout() / 1000;
    }

    public void setReadTimeout(int readTimeout) {
        this.connectionConfig = RequestConfig.copy((RequestConfig)this.connectionConfig).setSocketTimeout(readTimeout * 1000).build();
    }

    public int getMaxConnections() {
        return this.connectionManager.getDefaultMaxPerRoute();
    }

    public void setMaxConnections(int maxConnections) {
        this.connectionManager.setDefaultMaxPerRoute(maxConnections);
        this.connectionManager.setMaxTotal(maxConnections);
    }

    public void close() {
        this.connectionManager.shutdown();
    }

    static class HttpMethodResponse
    implements HTTPResponse {
        private HttpResponse methodResponse;
        private InputStream responseBodyAsStream;

        public HttpMethodResponse(HttpResponse methodResponse) {
            this.methodResponse = methodResponse;
        }

        public int getStatusCode() {
            if (this.methodResponse != null) {
                StatusLine statusLine = this.methodResponse.getStatusLine();
                return statusLine.getStatusCode();
            }
            return -1;
        }

        public void dispose() {
            if (this.responseBodyAsStream != null) {
                try {
                    this.responseBodyAsStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.methodResponse != null) {
                this.methodResponse = null;
            }
        }

        public String getContentType() {
            return this.getResponseHeader("Content-Type");
        }

        public String getResponseHeader(String headerName) {
            Header responseHeader = this.methodResponse.getFirstHeader(headerName);
            return responseHeader == null ? null : responseHeader.getValue();
        }

        public InputStream getResponseStream() throws IOException {
            if (this.responseBodyAsStream == null) {
                this.responseBodyAsStream = this.methodResponse.getEntity().getContent();
                Header header = this.methodResponse.getFirstHeader("Content-Encoding");
                if (header != null && "gzip".equals(header.getValue())) {
                    this.responseBodyAsStream = new GZIPInputStream(this.responseBodyAsStream);
                }
            }
            return this.responseBodyAsStream;
        }

        public String getResponseCharset() {
            Header encoding = this.methodResponse.getEntity().getContentEncoding();
            return encoding == null ? null : encoding.getValue();
        }
    }
}

