/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.mapfish.print.map.MapTileTask;
import org.pvalsecc.concurrent.OrderedResultsExecutor;

public class ThreadResources {
    private OrderedResultsExecutor<MapTileTask> mapRenderingExecutor = null;
    private MultiThreadedHttpConnectionManager connectionManager;
    private int perHostParallelFetches = 10;
    private int globalParallelFetches = 30;
    private int connectionTimeout = 30000;
    private int socketTimeout = 30000;

    @PostConstruct
    public void init() {
        this.connectionManager = new MultiThreadedHttpConnectionManager();
        HttpConnectionManagerParams params = this.connectionManager.getParams();
        params.setDefaultMaxConnectionsPerHost(this.perHostParallelFetches);
        params.setMaxTotalConnections(this.globalParallelFetches);
        params.setSoTimeout(this.socketTimeout);
        params.setConnectionTimeout(this.connectionTimeout);
        this.mapRenderingExecutor = new OrderedResultsExecutor(this.globalParallelFetches, "tilesReader");
        this.mapRenderingExecutor.start();
    }

    @PreDestroy
    public void destroy() {
        try {
            this.connectionManager.shutdown();
        }
        finally {
            this.mapRenderingExecutor.stop();
        }
    }

    public void setPerHostParallelFetches(int perHostParallelFetches) {
        this.perHostParallelFetches = perHostParallelFetches;
    }

    public void setGlobalParallelFetches(int globalParallelFetches) {
        this.globalParallelFetches = globalParallelFetches;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public MultiThreadedHttpConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public OrderedResultsExecutor<MapTileTask> getMapRenderingExecutor() {
        return this.mapRenderingExecutor;
    }
}

