/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.search.util.QueryModel.PrefixString;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Vector;
import org.jzkit.search.util.QueryModel.Internal.AttrPlusTermNode;
import org.jzkit.search.util.QueryModel.Internal.AttrValue;
import org.jzkit.search.util.QueryModel.Internal.ComplexNode;
import org.jzkit.search.util.QueryModel.Internal.InternalModelNamespaceNode;
import org.jzkit.search.util.QueryModel.Internal.InternalModelRootNode;
import org.jzkit.search.util.QueryModel.Internal.QueryNode;

public class PrefixQueryVisitor {
    public static String toPQF(QueryNode qn) throws IOException {
        StringWriter sw = new StringWriter();
        PrefixQueryVisitor.visit(qn, (Writer)sw, null);
        return sw.toString();
    }

    public static final void visit(QueryNode qn, Writer os, String attrset) throws IOException {
        if (qn instanceof InternalModelRootNode) {
            PrefixQueryVisitor.visit((InternalModelRootNode)qn, os, attrset);
        } else if (qn instanceof InternalModelNamespaceNode) {
            PrefixQueryVisitor.visit((InternalModelNamespaceNode)qn, os, attrset);
        } else if (qn instanceof ComplexNode) {
            PrefixQueryVisitor.visit((ComplexNode)qn, os, attrset);
        } else if (qn instanceof AttrPlusTermNode) {
            PrefixQueryVisitor.visit((AttrPlusTermNode)qn, os, attrset);
        }
    }

    public static final void visit(InternalModelRootNode rn, Writer os, String attrset) throws IOException {
        PrefixQueryVisitor.visit(rn.getChild(), os, attrset);
    }

    public static final void visit(InternalModelNamespaceNode nsn, Writer os, String attrset) throws IOException {
        if (nsn.getAttrset() != null) {
            os.write("@attrset " + nsn.getAttrset() + " ");
        }
        PrefixQueryVisitor.visit(nsn.getChild(), os, nsn.getAttrset());
    }

    public static final void visit(ComplexNode cn, Writer os, String attrset) throws IOException {
        int inumleft = cn.getLHS().countChildrenWithTerms();
        int inumright = cn.getRHS().countChildrenWithTerms();
        if (inumleft > 0 && inumright > 0) {
            switch (cn.getOp()) {
                case 1: {
                    os.write("@and ");
                    break;
                }
                case 2: {
                    os.write("@or ");
                    break;
                }
                case 3: {
                    os.write("@andnot ");
                    break;
                }
                case 4: {
                    os.write("@PROX ");
                    break;
                }
                default: {
                    os.write("@ERROR ");
                }
            }
        }
        if (inumleft > 0) {
            PrefixQueryVisitor.visit(cn.getLHS(), os, attrset);
        }
        if (inumright > 0) {
            PrefixQueryVisitor.visit(cn.getRHS(), os, attrset);
        }
    }

    public static final void visit(AttrPlusTermNode aptn, Writer os, String attrset) throws IOException {
        Object term = aptn.getTerm();
        if (term != null && term instanceof Vector) {
            int i;
            Vector terms = (Vector)term;
            int j = terms.size() - 1;
            block4: for (i = 0; i <= j; ++i) {
                switch (aptn.getDefaultMultiTermOperator()) {
                    case 1: {
                        os.write("@or ");
                        continue block4;
                    }
                    case 0: {
                        os.write("@and ");
                        continue block4;
                    }
                }
            }
            if (aptn.getDefaultMultiTermOperator() == 3) {
                PrefixQueryVisitor.addAttrs(aptn, os, attrset);
                for (i = 0; i <= j; ++i) {
                    os.write("\"");
                    os.write((String)terms.elementAt(i));
                    os.write("\" ");
                }
            } else {
                for (i = 0; i <= j; ++i) {
                    PrefixQueryVisitor.addAttrs(aptn, os, attrset);
                    os.write("\"");
                    os.write((String)terms.elementAt(i));
                    os.write("\" ");
                }
            }
            os.flush();
        } else if (term != null) {
            PrefixQueryVisitor.addAttrs(aptn, os, attrset);
            os.write("\"" + aptn.getTerm() + "\" ");
            os.flush();
        }
    }

    public static final void addAttrs(AttrPlusTermNode aptn, Writer os, String attrset) throws IOException {
        PrefixQueryVisitor.add(aptn, os, attrset, "AccessPoint");
        PrefixQueryVisitor.add(aptn, os, attrset, "Relation");
        PrefixQueryVisitor.add(aptn, os, attrset, "Position");
        PrefixQueryVisitor.add(aptn, os, attrset, "Structure");
        PrefixQueryVisitor.add(aptn, os, attrset, "Truncation");
        PrefixQueryVisitor.add(aptn, os, attrset, "Completeness");
    }

    public static final void add(AttrPlusTermNode aptn, Writer os, String attrset, String name) throws IOException {
        AttrValue attr;
        String[] components;
        Object att = aptn.getAttr(name);
        if (att != null && att instanceof AttrValue && (components = (attr = (AttrValue)att).getValue().split("\\.")).length == 2) {
            if (attr.getNamespaceIdentifier() == null || attr.getNamespaceIdentifier().equals(attrset)) {
                os.write("@attr " + components[0] + "=" + components[1] + " ");
            } else {
                os.write("@attr " + attr.getNamespaceIdentifier() + " " + components[0] + "=" + components[1] + " ");
            }
        }
    }
}

