/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.converters;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.ArrayType;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.lang.reflect.Type;
import java.util.Iterator;
import org.reactivestreams.Publisher;
import org.springdoc.core.SpringDocUtils;
import org.springdoc.core.converters.ConverterUtils;
import org.springdoc.core.providers.ObjectMapperProvider;
import reactor.core.publisher.Flux;

public class WebFluxSupportConverter
implements ModelConverter {
    private final ObjectMapperProvider objectMapperProvider;

    public WebFluxSupportConverter(ObjectMapperProvider objectMapperProvider) {
        this.objectMapperProvider = objectMapperProvider;
        SpringDocUtils.getConfig().addResponseWrapperToIgnore(Publisher.class).addFluxWrapperToIgnore(Flux.class);
    }

    public Schema resolve(AnnotatedType type, ModelConverterContext context, Iterator<ModelConverter> chain) {
        Class cls;
        JavaType javaType = this.objectMapperProvider.jsonMapper().constructType(type.getType());
        if (javaType != null && ConverterUtils.isFluxTypeWrapper(cls = javaType.getRawClass())) {
            JavaType innerType = javaType.getBindings().getBoundType(0);
            if (innerType == null) {
                return new StringSchema();
            }
            if (innerType.getBindings() != null && ConverterUtils.isResponseTypeWrapper(innerType.getRawClass())) {
                type = new AnnotatedType((Type)innerType).jsonViewAnnotation(type.getJsonViewAnnotation()).resolveAsRef(true);
                return this.resolve(type, context, chain);
            }
            ArrayType arrayType = ArrayType.construct((JavaType)innerType, null);
            type = new AnnotatedType((Type)arrayType).jsonViewAnnotation(type.getJsonViewAnnotation()).resolveAsRef(true);
        }
        return chain.hasNext() ? chain.next().resolve(type, context, chain) : null;
    }
}

