/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.geotools.data.wfs.internal.ComplexFeatureIteratorImpl;
import org.geotools.data.wfs.internal.ComplexGetFeatureResponse;
import org.geotools.data.wfs.internal.GetFeatureRequest;
import org.geotools.data.wfs.internal.WFSClient;
import org.geotools.data.wfs.internal.parsers.XmlComplexFeatureParser;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.BaseFeatureCollection;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;

public class WFSContentComplexFeatureCollection
extends BaseFeatureCollection<FeatureType, Feature> {
    private static final Logger LOGGER = Logging.getLogger(WFSContentComplexFeatureCollection.class);
    private final WFSClient client;
    private final FeatureType schema;
    private final GetFeatureRequest request;
    private final QName name;
    private final Filter filter;

    @Deprecated
    public WFSContentComplexFeatureCollection(GetFeatureRequest request, FeatureType schema, QName name) throws IOException {
        this(request, schema, name, (Filter)Filter.INCLUDE, null);
    }

    @Deprecated
    public WFSContentComplexFeatureCollection(GetFeatureRequest request, FeatureType schema, QName name, Filter filter) throws IOException {
        this(request, schema, name, filter, null);
    }

    public WFSContentComplexFeatureCollection(GetFeatureRequest request, FeatureType schema, QName name, WFSClient client) {
        this(request, schema, name, (Filter)Filter.INCLUDE, client);
    }

    public WFSContentComplexFeatureCollection(GetFeatureRequest request, FeatureType schema, QName name, Filter filter, WFSClient client) {
        this.request = request;
        this.name = name;
        this.schema = schema;
        this.client = client;
        this.filter = filter;
    }

    public FeatureIterator<Feature> features() {
        try {
            if (this.client == null) {
                InputStream stream = this.request.getFinalURL().openStream();
                XmlComplexFeatureParser parser = new XmlComplexFeatureParser(stream, this.schema, this.name, this.filter, this.request.getStrategy());
                return new ComplexFeatureIteratorImpl(parser);
            }
            ComplexGetFeatureResponse response = this.client.issueComplexRequest(this.request);
            return response.features();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new RuntimeException("Couldn't read features of collection.", e);
        }
    }

    public FeatureType getSchema() {
        return this.schema;
    }

    public FeatureCollection<FeatureType, Feature> subCollection(Filter filter) {
        return new WFSContentComplexFeatureCollection(this.request, this.schema, this.name, filter, this.client);
    }
}

