/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.openidconnect;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.kernel.security.SecurityProviderConfiguration;
import org.springframework.util.StringUtils;

public class OIDCConfiguration
implements SecurityProviderConfiguration {
    public String userNameAttribute = "email";
    public String organizationProperty = "organization";
    public String groupPermissionSeparator = ":";
    public String idTokenRoleLocation = "groups";
    public Map<String, String> roleConverter = new HashMap<String, String>();
    public String minimumProfile = "Guest";
    public boolean updateProfile = true;
    public boolean updateGroup = true;
    public boolean logSensitiveInformation = false;
    public String clientId;
    public String clientSecret;
    public String scopes = null;
    public String roleConverterString = null;
    public SecurityProviderConfiguration.LoginType loginType = SecurityProviderConfiguration.LoginType.LINK;

    public String getScopes() {
        return this.scopes;
    }

    public void setScopes(String scopes) {
        this.scopes = scopes;
    }

    public List<String> getScopeSet() {
        if (!StringUtils.hasText((String)this.scopes)) {
            return null;
        }
        return Arrays.asList(this.scopes.split(" "));
    }

    public String getUserNameAttribute() {
        return this.userNameAttribute;
    }

    public void setUserNameAttribute(String userNameAttribute) {
        this.userNameAttribute = userNameAttribute;
    }

    public boolean isLogSensitiveInformation() {
        return this.logSensitiveInformation;
    }

    public void setLogSensitiveInformation(boolean logSensitiveInformation) {
        this.logSensitiveInformation = logSensitiveInformation;
    }

    public String getOrganizationProperty() {
        return this.organizationProperty;
    }

    public void setOrganizationProperty(String organizationProperty) {
        this.organizationProperty = organizationProperty;
    }

    public String getGroupPermissionSeparator() {
        return this.groupPermissionSeparator;
    }

    public void setGroupPermissionSeparator(String groupPermissionSeparator) {
        this.groupPermissionSeparator = groupPermissionSeparator;
    }

    public String getIdTokenRoleLocation() {
        return this.idTokenRoleLocation;
    }

    public void setIdTokenRoleLocation(String idTokenRoleLocation) {
        this.idTokenRoleLocation = idTokenRoleLocation;
    }

    public Map<String, String> getRoleConverter() {
        return this.roleConverter;
    }

    public void setRoleConverter(Map<String, String> roleConverter) {
        this.roleConverter = roleConverter;
    }

    public Profile getMinimumProfile() {
        return Profile.findProfileIgnoreCase((String)this.minimumProfile);
    }

    public void setMinimumProfile(String minimumProfile) {
        this.minimumProfile = minimumProfile;
    }

    @Override
    public String getLoginType() {
        return this.loginType.toString();
    }

    public void setLoginType(String loginType) throws Exception {
        this.loginType = SecurityProviderConfiguration.LoginType.parse(loginType);
        if (!this.loginType.equals((Object)SecurityProviderConfiguration.LoginType.AUTOLOGIN) && !this.loginType.equals((Object)SecurityProviderConfiguration.LoginType.LINK)) {
            throw new Exception("Configuration error - login type should only be LINK or AUTOLOGIN");
        }
    }

    @Override
    public String getSecurityProvider() {
        return "OIDC";
    }

    @Override
    public boolean isUserProfileUpdateEnabled() {
        return !this.updateProfile;
    }

    @Override
    public boolean isUserGroupUpdateEnabled() {
        return !this.updateGroup;
    }

    public boolean isUpdateProfile() {
        return this.updateProfile;
    }

    public void setUpdateProfile(boolean updateProfile) {
        this.updateProfile = updateProfile;
    }

    public boolean isUpdateGroup() {
        return this.updateGroup;
    }

    public void setUpdateGroup(boolean updateGroup) {
        this.updateGroup = updateGroup;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void updateRoleConverterString(String serialized) {
        String[] items;
        HashMap<String, String> result = new HashMap<String, String>();
        if (!StringUtils.hasText((String)serialized)) {
            return;
        }
        serialized = serialized.trim();
        for (String item : items = serialized.split(",")) {
            String[] keyValue = item.split("=");
            result.put(keyValue[0].trim(), keyValue[1].trim());
        }
        this.roleConverter = result;
    }

    public void setRoleConverterString(String roleConverterString) {
        this.roleConverterString = roleConverterString;
        this.updateRoleConverterString(roleConverterString);
    }

    public String toString() {
        String result = "OIDC CONFIG: \n";
        result = result + "      idTokenRoleLocation=" + this.idTokenRoleLocation + "\n";
        result = result + "      updateGroup=" + this.updateGroup + "\n";
        result = result + "      updateProfile=" + this.updateProfile + "\n";
        result = result + "      scopes=" + this.scopes + "\n";
        if (this.roleConverter != null && !this.roleConverter.isEmpty()) {
            result = result + "      roleConverter: \n";
            for (Map.Entry<String, String> role : this.roleConverter.entrySet()) {
                result = result + "            + " + role.getKey() + " -> " + role.getValue();
            }
        }
        return result;
    }
}

