/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.mef;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.MetadataResourceDatabaseMigration;
import org.fao.geonet.Util;
import org.fao.geonet.api.records.attachments.Store;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Localized;
import org.fao.geonet.domain.MetadataCategory;
import org.fao.geonet.domain.MetadataDataInfo;
import org.fao.geonet.domain.MetadataRelation;
import org.fao.geonet.domain.MetadataRelationId;
import org.fao.geonet.domain.MetadataResourceVisibility;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.domain.OperationAllowed;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.domain.Source;
import org.fao.geonet.domain.SourceType;
import org.fao.geonet.exceptions.BadFormatEx;
import org.fao.geonet.exceptions.NoSchemaMatchesException;
import org.fao.geonet.exceptions.UnAuthorizedException;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.datamanager.IMetadataIndexer;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.IMetadataOperations;
import org.fao.geonet.kernel.datamanager.IMetadataSchemaUtils;
import org.fao.geonet.kernel.datamanager.IMetadataStatus;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.datamanager.IMetadataValidator;
import org.fao.geonet.kernel.mef.IMEFVisitor;
import org.fao.geonet.kernel.mef.IVisitor;
import org.fao.geonet.kernel.mef.MEF2Visitor;
import org.fao.geonet.kernel.mef.MEFLib;
import org.fao.geonet.kernel.mef.MEFVisitor;
import org.fao.geonet.kernel.mef.XmlVisitor;
import org.fao.geonet.kernel.search.IndexingMode;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.MetadataCategoryRepository;
import org.fao.geonet.repository.MetadataRelationRepository;
import org.fao.geonet.repository.MetadataValidationRepository;
import org.fao.geonet.repository.OperationAllowedRepository;
import org.fao.geonet.repository.SourceRepository;
import org.fao.geonet.repository.Updater;
import org.fao.geonet.utils.FilePathChecker;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.fao.oaipmh.exceptions.BadArgumentException;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class Importer {
    private Importer() {
    }

    @Deprecated
    public static List<String> doImport(Element params, ServiceContext context, Path mefFile, Path stylePath) throws Exception {
        String fileType = Util.getParam((Element)params, (String)"file_type", (String)"mef");
        String style = Util.getParam((Element)params, (String)"styleSheet", (String)"_none_");
        String uuidAction = Util.getParam((Element)params, (String)"uuidAction", (String)"nothing");
        String source = Util.getParam((Element)params, (String)"siteId", (String)context.getBean(SettingManager.class).getSiteId());
        MetadataType isTemplate = MetadataType.lookup((String)Util.getParam((Element)params, (String)"template", (String)"n"));
        String category = Util.getParam((Element)params, (String)"category", (String)"");
        String groupId = Util.getParam((Element)params, (String)"group", (String)"");
        boolean validate = Util.getParam((Element)params, (String)"validate", (String)"off").equals("on");
        boolean assign = Util.getParam((Element)params, (String)"assign", (String)"off").equals("on");
        return Importer.doImport(fileType, MEFLib.UuidAction.parse(uuidAction), style, source, isTemplate, new String[]{category}, groupId, validate, assign, context, mefFile);
    }

    public static List<String> doImport(String fileType, MEFLib.UuidAction uuidAction, final String style, String source, MetadataType isTemplate, String[] category, String groupId, boolean validate, boolean assign, ServiceContext context, Path mefFile) throws Exception {
        IVisitor visitor;
        MEFLib.Version version;
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        final IMetadataSchemaUtils metadataSchemaUtils = (IMetadataSchemaUtils)applicationContext.getBean(IMetadataSchemaUtils.class);
        IMetadataUtils metadataUtils = (IMetadataUtils)applicationContext.getBean(IMetadataUtils.class);
        IMetadataManager metadataManager = (IMetadataManager)applicationContext.getBean(IMetadataManager.class);
        AccessManager accessManager = (AccessManager)applicationContext.getBean(AccessManager.class);
        IMetadataOperations metadataOperations = (IMetadataOperations)applicationContext.getBean(IMetadataOperations.class);
        IMetadataIndexer metadataIndexer = (IMetadataIndexer)applicationContext.getBean(IMetadataIndexer.class);
        IMetadataValidator metadataValidator = (IMetadataValidator)applicationContext.getBean(IMetadataValidator.class);
        SettingManager sm = (SettingManager)applicationContext.getBean(SettingManager.class);
        String preferredSchema = ((ServiceConfig)applicationContext.getBean(ServiceConfig.class)).getValue("preferredSchema", "iso19139");
        ArrayList<String> metadataIdMap = new ArrayList<String>();
        final ArrayList md = new ArrayList();
        final ArrayList fc = new ArrayList();
        if (fileType.equals("mef") && (version = MEFLib.getMEFVersion(mefFile)) != null && version.equals((Object)MEFLib.Version.V2)) {
            fileType = "mef2";
        }
        if (fileType.equals("single")) {
            visitor = new XmlVisitor();
        } else if (fileType.equals("mef")) {
            visitor = new MEFVisitor();
        } else if (fileType.equals("mef2")) {
            visitor = new MEF2Visitor();
        } else {
            throw new BadArgumentException("Bad file type parameter.");
        }
        final String finalPreferredSchema = preferredSchema;
        MEFLib.visit(mefFile, visitor, new IMEFVisitor((ApplicationContext)applicationContext, category, isTemplate, metadataUtils, assign, source, sm, validate, groupId, metadataValidator, context, uuidAction, metadataIdMap, metadataManager, accessManager, metadataOperations, metadataIndexer){
            final /* synthetic */ ApplicationContext val$applicationContext;
            final /* synthetic */ String[] val$category;
            final /* synthetic */ MetadataType val$isTemplate;
            final /* synthetic */ IMetadataUtils val$metadataUtils;
            final /* synthetic */ boolean val$assign;
            final /* synthetic */ String val$source;
            final /* synthetic */ SettingManager val$sm;
            final /* synthetic */ boolean val$validate;
            final /* synthetic */ String val$groupId;
            final /* synthetic */ IMetadataValidator val$metadataValidator;
            final /* synthetic */ ServiceContext val$context;
            final /* synthetic */ MEFLib.UuidAction val$uuidAction;
            final /* synthetic */ List val$metadataIdMap;
            final /* synthetic */ IMetadataManager val$metadataManager;
            final /* synthetic */ AccessManager val$accessManager;
            final /* synthetic */ IMetadataOperations val$metadataOperations;
            final /* synthetic */ IMetadataIndexer val$metadataIndexer;
            {
                this.val$applicationContext = applicationContext;
                this.val$category = stringArray;
                this.val$isTemplate = metadataType;
                this.val$metadataUtils = iMetadataUtils;
                this.val$assign = bl;
                this.val$source = string3;
                this.val$sm = settingManager;
                this.val$validate = bl2;
                this.val$groupId = string4;
                this.val$metadataValidator = iMetadataValidator;
                this.val$context = serviceContext;
                this.val$uuidAction = uuidAction;
                this.val$metadataIdMap = list3;
                this.val$metadataManager = iMetadataManager;
                this.val$accessManager = accessManager;
                this.val$metadataOperations = iMetadataOperations;
                this.val$metadataIndexer = iMetadataIndexer;
            }

            @Override
            public void handleMetadata(Element metadata, int index) throws Exception {
                if (Log.isDebugEnabled((String)"geonetwork.mef")) {
                    Log.debug((String)"geonetwork.mef", (Object)("Collecting metadata:\n" + Xml.getString((Element)metadata)));
                }
                md.add(index, metadata);
            }

            @Override
            public void handleMetadataFiles(DirectoryStream<Path> metadataXmlFiles, Element info, int index) throws Exception {
                Element general;
                String infoSchema = "_none_";
                String uuid = null;
                if (info != null && info.getContentSize() != 0 && (general = info.getChild("general")) != null && general.getContentSize() != 0) {
                    if (general.getChildText("schema") != null) {
                        infoSchema = general.getChildText("schema");
                    }
                    if (general.getChildText("uuid") != null) {
                        uuid = general.getChildText("uuid");
                    }
                }
                Path lastUnknownMetadataFolderName = null;
                if (Log.isDebugEnabled((String)"geonetwork.mef")) {
                    Log.debug((String)"geonetwork.mef", (Object)("info.xml says schema should be " + infoSchema));
                }
                HashMap<String, Pair> mdFiles = new HashMap<String, Pair>();
                for (Path file : metadataXmlFiles) {
                    if (file == null || !Files.isRegularFile(file, new LinkOption[0])) continue;
                    Element metadata = Xml.loadFile((Path)file);
                    lastUnknownMetadataFolderName = file.getParent().getParent().relativize(file);
                    try {
                        String metadataSchema = metadataSchemaUtils.autodetectSchema(metadata, null);
                        if (metadataSchema == null) continue;
                        String currFile = "Found metadata file " + file.getParent().getParent().relativize(file);
                        mdFiles.put(metadataSchema, Pair.read((Object)currFile, (Object)metadata));
                    }
                    catch (NoSchemaMatchesException e) {
                        Log.debug((String)"geonetwork.mef", (Object)("No schema match for " + lastUnknownMetadataFolderName + "."));
                    }
                }
                if (mdFiles.size() == 0) {
                    throw new BadFormatEx(uuid + " / No valid metadata file found" + (lastUnknownMetadataFolderName == null ? "" : " in " + lastUnknownMetadataFolderName) + ".");
                }
                Pair mdInform = (Pair)mdFiles.get(infoSchema);
                if (mdInform != null) {
                    if (Log.isDebugEnabled((String)"geonetwork.mef")) {
                        Log.debug((String)"geonetwork.mef", (Object)((String)mdInform.one() + " with info.xml schema (" + infoSchema + ")."));
                    }
                    Element metadataValidForImport = (Element)mdInform.two();
                    this.handleMetadata(metadataValidForImport, index);
                    return;
                }
                mdInform = (Pair)mdFiles.get(finalPreferredSchema);
                if (mdInform != null) {
                    if (Log.isDebugEnabled((String)"geonetwork.mef")) {
                        Log.debug((String)"geonetwork.mef", (Object)((String)mdInform.one() + " with preferred schema (" + finalPreferredSchema + ")."));
                    }
                    Element metadataValidForImport = (Element)mdInform.two();
                    this.handleMetadata(metadataValidForImport, index);
                    return;
                }
                String metadataSchema = (String)mdFiles.keySet().toArray()[0];
                mdInform = (Pair)mdFiles.get(metadataSchema);
                if (Log.isDebugEnabled((String)"geonetwork.mef")) {
                    Log.debug((String)"geonetwork.mef", (Object)((String)mdInform.one() + " with known schema (" + metadataSchema + ")."));
                }
                Element metadataValidForImport = (Element)mdInform.two();
                this.handleMetadata(metadataValidForImport, index);
            }

            @Override
            public void handleFeatureCat(Element featureCat, int index) throws Exception {
                if (featureCat != null && Log.isDebugEnabled((String)"geonetwork.mef")) {
                    Log.debug((String)"geonetwork.mef", (Object)("Collecting feature catalog:\n" + Xml.getString((Element)featureCat)));
                }
                fc.add(index, featureCat);
            }

            @Override
            public void handleInfo(Element info, int index) throws Exception {
                AbstractMetadata md2;
                Element privileges;
                Element metadata;
                String schema;
                String uuid = null;
                String createDate = null;
                String changeDate = null;
                String sourceName = null;
                Map sourceTranslations = Maps.newHashMap();
                String rating = null;
                String popularity = null;
                Element categs = null;
                if (!style.equals("_none_")) {
                    FilePathChecker.verify((String)style);
                    GeonetworkDataDirectory dataDirectory = (GeonetworkDataDirectory)this.val$applicationContext.getBean(GeonetworkDataDirectory.class);
                    Path xsltPath = dataDirectory.getXsltConversion(style);
                    if (Files.exists(xsltPath, new LinkOption[0])) {
                        md.add(index, Xml.transform((Element)((Element)md.get(index)), (Path)xsltPath));
                    } else {
                        throw new Exception(String.format("XSL transformation '%s' not found.", style));
                    }
                }
                if ((schema = metadataSchemaUtils.autodetectSchema(metadata = (Element)md.get(index), null)) == null) {
                    throw new Exception("Unknown schema");
                }
                if (info.getChildren().isEmpty()) {
                    if (this.val$category != null) {
                        categs = new Element("categories");
                        for (String c : this.val$category) {
                            categs.addContent((Content)new Element("category").setAttribute("name", c));
                        }
                    }
                    privileges = new Element("group");
                    privileges.addContent((Content)new Element("operation").setAttribute("name", "view"));
                    privileges.addContent((Content)new Element("operation").setAttribute("name", "editing"));
                    privileges.addContent((Content)new Element("operation").setAttribute("name", "download"));
                    privileges.addContent((Content)new Element("operation").setAttribute("name", "notify"));
                    privileges.addContent((Content)new Element("operation").setAttribute("name", "dynamic"));
                    privileges.addContent((Content)new Element("operation").setAttribute("name", "featured"));
                    if (this.val$isTemplate == MetadataType.METADATA) {
                        uuid = this.val$metadataUtils.extractUUID(schema, (Element)md.get(index));
                    } else if (this.val$isTemplate == MetadataType.SUB_TEMPLATE) {
                        uuid = ((Element)md.get(index)).getAttributeValue("uuid");
                    } else if (this.val$isTemplate == MetadataType.TEMPLATE_OF_SUB_TEMPLATE) {
                        uuid = ((Element)md.get(index)).getAttributeValue("uuid");
                    }
                } else {
                    if (Log.isDebugEnabled((String)"geonetwork.mef")) {
                        Log.debug((String)"geonetwork.mef", (Object)("Collecting info file:\n" + Xml.getString((Element)info)));
                    }
                    categs = info.getChild("categories");
                    privileges = info.getChild("privileges");
                    Element general = info.getChild("general");
                    uuid = general.getChildText("uuid");
                    createDate = general.getChildText("createDate");
                    changeDate = general.getChildText("changeDate");
                    if (this.val$assign) {
                        if (Log.isDebugEnabled((String)"geonetwork.mef")) {
                            Log.debug((String)"geonetwork.mef", (Object)"Assign to local catalog");
                        }
                    } else {
                        sourceName = general.getChildText("siteName");
                        sourceTranslations = Localized.translationXmlToLangMap((List)general.getChildren("siteTranslations"));
                        if (Log.isDebugEnabled((String)"geonetwork.mef")) {
                            Log.debug((String)"geonetwork.mef", (Object)("Assign to catalog: " + this.val$source));
                        }
                    }
                    rating = general.getChildText("rating");
                    popularity = general.getChildText("popularity");
                }
                if (schema.startsWith("iso19139")) {
                    try {
                        MetadataResourceDatabaseMigration.updateMetadataResourcesLink(metadata, null, this.val$sm);
                    }
                    catch (UnsupportedOperationException general) {
                        // empty catch block
                    }
                }
                if (this.val$validate) {
                    Integer groupIdVal = null;
                    if (StringUtils.isNotEmpty((String)this.val$groupId)) {
                        groupIdVal = Integer.parseInt(this.val$groupId);
                    }
                    this.val$metadataValidator.validateExternalMetadata(schema, metadata, this.val$context, " ", groupIdVal);
                }
                try {
                    Importer.importRecord(uuid, this.val$uuidAction, md, schema, index, this.val$source, sourceName, sourceTranslations, this.val$context, this.val$metadataIdMap, createDate, changeDate, this.val$groupId, this.val$isTemplate);
                }
                catch (Exception e) {
                    throw new Exception("Failed to import metadata with uuid '" + uuid + "'. " + e.getLocalizedMessage(), e);
                }
                if (!fc.isEmpty() && fc.get(index) != null) {
                    uuid = UUID.randomUUID().toString();
                    fc.add(index, this.val$metadataUtils.setUUID("iso19110", uuid, (Element)fc.get(index)));
                    int userid = this.val$context.getUserSession().getUserIdAsInt();
                    String group = null;
                    String docType = null;
                    Object title = null;
                    String category = null;
                    boolean ufo = false;
                    String fcId = this.val$metadataManager.insertMetadata(this.val$context, "iso19110", (Element)fc.get(index), uuid, userid, group, this.val$source, this.val$isTemplate.codeString, docType, category, createDate, changeDate, ufo, IndexingMode.full);
                    if (Log.isDebugEnabled((String)"geonetwork.mef")) {
                        Log.debug((String)"geonetwork.mef", (Object)("Adding Feature catalog with uuid: " + uuid));
                    }
                    String mdId = (String)this.val$metadataIdMap.get(index);
                    MetadataRelationRepository relationRepository = this.val$context.getBean(MetadataRelationRepository.class);
                    MetadataRelation relation = new MetadataRelation();
                    relation.setId(new MetadataRelationId(Integer.valueOf(mdId), Integer.valueOf(fcId)));
                    relationRepository.save((Object)relation);
                    this.val$metadataIdMap.add(fcId);
                }
                final int iMetadataId = Integer.valueOf((String)this.val$metadataIdMap.get(index));
                final String finalPopularity = popularity;
                final String finalRating = rating;
                final Element finalCategs = categs;
                final String finalGroupId = this.val$groupId;
                this.val$metadataManager.update(iMetadataId, (Updater<? extends AbstractMetadata>)new Updater<AbstractMetadata>(){

                    public void apply(@Nonnull AbstractMetadata metadata) {
                        MetadataDataInfo dataInfo = metadata.getDataInfo();
                        if (finalPopularity != null) {
                            dataInfo.setPopularity(Integer.valueOf(finalPopularity).intValue());
                        }
                        if (finalRating != null) {
                            dataInfo.setRating(Integer.valueOf(finalRating).intValue());
                        }
                        dataInfo.setType(val$isTemplate);
                        metadata.getHarvestInfo().setHarvested(false);
                        Importer.addCategoriesToMetadata(metadata, finalCategs, val$context);
                        if (finalGroupId == null || finalGroupId.equals("")) {
                            Group ownerGroup = Importer.addPrivileges(val$context, val$accessManager, val$metadataOperations, iMetadataId, privileges);
                            if (ownerGroup != null) {
                                metadata.getSourceInfo().setGroupOwner(Integer.valueOf(ownerGroup.getId()));
                            }
                        } else {
                            OperationAllowedRepository allowedRepository = val$context.getBean(OperationAllowedRepository.class);
                            Set allowedSet = Importer.addOperations(val$context, val$accessManager, val$metadataOperations, privileges, iMetadataId, Integer.valueOf(finalGroupId));
                            allowedRepository.saveAll((Iterable)allowedSet);
                        }
                    }
                });
                if (this.val$validate && (md2 = this.val$metadataUtils.findOne(iMetadataId)) != null) {
                    this.val$metadataValidator.doValidate(md2, this.val$context.getLanguage());
                }
                this.val$metadataIndexer.indexMetadata((String)this.val$metadataIdMap.get(index), true, IndexingMode.full);
            }

            @Override
            public void handlePublicFile(String file, String changeDate, InputStream is, int index) throws Exception {
                if (Log.isDebugEnabled((String)"geonetwork.mef")) {
                    Log.debug((String)"geonetwork.mef", (Object)("Adding public file with name=" + file));
                }
                Importer.saveFile(this.val$context, (String)this.val$metadataIdMap.get(index), MetadataResourceVisibility.PUBLIC, file, changeDate, is);
            }

            @Override
            public void handlePrivateFile(String file, String changeDate, InputStream is, int index) throws Exception {
                if (Log.isDebugEnabled((String)"geonetwork.mef")) {
                    Log.debug((String)"geonetwork.mef", (Object)("Adding private file with name=" + file));
                }
                Importer.saveFile(this.val$context, (String)this.val$metadataIdMap.get(index), MetadataResourceVisibility.PRIVATE, file, changeDate, is);
            }
        });
        return metadataIdMap;
    }

    public static void addCategoriesToMetadata(AbstractMetadata metadata, Element finalCategs, ServiceContext context) {
        if (finalCategs != null) {
            MetadataCategoryRepository categoryRepository = context.getBean(MetadataCategoryRepository.class);
            for (Object cat : finalCategs.getChildren()) {
                Element categoryEl = (Element)cat;
                String catName = categoryEl.getAttributeValue("name");
                MetadataCategory oneByName = categoryRepository.findOneByName(catName);
                if (oneByName == null) {
                    if (!Log.isDebugEnabled((String)"geonetwork.mef")) continue;
                    Log.debug((String)"geonetwork.mef", (Object)(" - Skipping non-existent category : " + catName));
                    continue;
                }
                if (Log.isDebugEnabled((String)"geonetwork.mef")) {
                    Log.debug((String)"geonetwork.mef", (Object)(" - Setting category : " + catName));
                }
                metadata.getCategories().add(oneByName);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void importRecord(String uuid, MEFLib.UuidAction uuidAction, List<Element> md, String schema, int index, String source, String sourceName, Map<String, String> sourceTranslations, ServiceContext context, List<String> id, String createDate, String changeDate, String groupId, MetadataType isTemplate) throws Exception {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        IMetadataUtils metadataUtils = gc.getBean(IMetadataUtils.class);
        AccessManager accessManager = gc.getBean(AccessManager.class);
        IMetadataStatus metadataStatus = gc.getBean(IMetadataStatus.class);
        IMetadataManager metadataManager = gc.getBean(IMetadataManager.class);
        if (StringUtils.isBlank((String)uuid) || uuidAction == MEFLib.UuidAction.GENERATEUUID) {
            String newuuid = UUID.randomUUID().toString();
            source = null;
            if (StringUtils.isNotBlank((String)uuid)) {
                md.add(index, Importer.updateMetadataUuidReferences(md.get(index), uuid, newuuid));
            }
            Log.debug((String)"geonetwork.mef", (Object)("Replacing UUID " + uuid + " with " + newuuid));
            uuid = newuuid;
            md.add(index, metadataUtils.setUUID(schema, uuid, md.get(index)));
        } else {
            if (sourceName == null) {
                sourceName = "???";
            }
            if (source == null || source.trim().length() == 0) {
                throw new Exception("Missing siteId parameter from info.xml file");
            }
            SourceRepository sourceRepository = context.getBean(SourceRepository.class);
            Source sourceObject = sourceRepository.findOneByUuid(source);
            if (sourceObject == null || !source.equals(gc.getBean(SettingManager.class).getSiteId()) && SourceType.harvester != sourceObject.getType()) {
                Source source1 = new Source(source, sourceName, sourceTranslations, SourceType.externalportal);
                context.getBean(SourceRepository.class).save((Object)source1);
            }
        }
        boolean metadataExist = metadataUtils.existsMetadataUuid(uuid);
        SettingManager settingManager = gc.getBean(SettingManager.class);
        boolean isMdWorkflowEnable = settingManager.getValueAsBool("metadata/workflow/enable");
        String metadataId = "";
        if (metadataExist && uuidAction == MEFLib.UuidAction.NOTHING) {
            throw new UnAuthorizedException("Record already exists. Change the import mode to overwrite or generating a new UUID.", null);
        }
        if (metadataExist && uuidAction == MEFLib.UuidAction.OVERWRITE) {
            String recordToUpdateId = metadataUtils.getMetadataId(uuid);
            if (isMdWorkflowEnable) {
                recordToUpdateId = metadataUtils.startEditingSession(context, recordToUpdateId).toString();
            }
            if (!accessManager.canEdit(context, recordToUpdateId)) throw new UnAuthorizedException("User has no privilege to overwrite existing metadata", null);
            MetadataValidationRepository metadataValidationRepository = context.getBean(MetadataValidationRepository.class);
            List validationStatus = metadataValidationRepository.findAllById_MetadataId(Integer.parseInt(recordToUpdateId));
            boolean validate = !validationStatus.isEmpty();
            metadataManager.updateMetadata(context, recordToUpdateId, md.get(index), validate, true, context.getLanguage(), null, true, IndexingMode.full);
            metadataId = recordToUpdateId;
        } else if (metadataExist && uuidAction == MEFLib.UuidAction.REMOVE_AND_REPLACE) {
            if (isMdWorkflowEnable) {
                throw new UnAuthorizedException("Remove and replace mode is not allowed when workflow is enabled. Use the metadata editor.", null);
            }
            try {
                if (!accessManager.canEdit(context, metadataUtils.getMetadataId(uuid))) throw new UnAuthorizedException("User has no privilege to replace existing metadata", null);
                if (Log.isDebugEnabled((String)"geonetwork.mef")) {
                    Log.debug((String)"geonetwork.mef", (Object)("Deleting existing metadata with UUID : " + uuid));
                }
                metadataManager.deleteMetadata(context, metadataUtils.getMetadataId(uuid));
                metadataManager.flush();
            }
            catch (Exception e) {
                throw new Exception(" Existing metadata with UUID " + uuid + " could not be deleted. Error is: " + e.getMessage());
            }
            metadataId = Importer.insertMetadata(uuid, md, schema, index, source, context, createDate, changeDate, groupId, isTemplate, metadataStatus, metadataManager);
        } else {
            metadataId = Importer.insertMetadata(uuid, md, schema, index, source, context, createDate, changeDate, groupId, isTemplate, metadataStatus, metadataManager);
        }
        id.add(index, metadataId);
    }

    private static String insertMetadata(String uuid, List<Element> md, String schema, int index, String source, ServiceContext context, String createDate, String changeDate, String groupId, MetadataType isTemplate, IMetadataStatus metadataStatus, IMetadataManager metadataManager) throws Exception {
        if (Log.isDebugEnabled((String)"geonetwork.mef")) {
            Log.debug((String)"geonetwork.mef", (Object)("Adding metadata with uuid:" + uuid));
        }
        int userid = context.getUserSession().getUserIdAsInt();
        String docType = null;
        String category = null;
        boolean ufo = false;
        String metadataId = metadataManager.insertMetadata(context, schema, md.get(index), uuid, userid, groupId, source, isTemplate.codeString, docType, category, createDate, changeDate, ufo, IndexingMode.none);
        metadataStatus.activateWorkflowIfConfigured(context, metadataId, groupId);
        return metadataId;
    }

    private static void saveFile(ServiceContext context, String id, MetadataResourceVisibility access, String file, String changeDate, InputStream is) throws Exception {
        Store store = context.getBean("resourceStore", Store.class);
        IMetadataUtils metadataUtils = context.getBean(IMetadataUtils.class);
        String metadataUuid = metadataUtils.getMetadataUuid(id);
        assert (metadataUuid != null);
        store.putResource(context, metadataUuid, file, is, new ISODate(changeDate).toDate(), access, true);
    }

    private static Group addPrivileges(ServiceContext context, AccessManager accessManager, IMetadataOperations metadataOperations, int metadataId, Element privil) {
        GroupRepository groupRepository = context.getBean(GroupRepository.class);
        OperationAllowedRepository allowedRepository = context.getBean(OperationAllowedRepository.class);
        List list = privil.getChildren("group");
        Group owner = null;
        HashSet<OperationAllowed> opAllowedToAdd = new HashSet<OperationAllowed>();
        ArrayList<Group> groupsToAdd = new ArrayList<Group>();
        for (Element group : list) {
            String grpName = group.getAttributeValue("name");
            boolean groupOwner = group.getAttributeValue("groupOwner") != null;
            Group groupEntity = groupRepository.findByName(grpName);
            if (groupEntity == null) {
                if (!Log.isDebugEnabled((String)"geonetwork.mef")) continue;
                Log.debug((String)"geonetwork.mef", (Object)(" - Skipping non-existent group : " + grpName));
                continue;
            }
            if (Log.isDebugEnabled((String)"geonetwork.mef")) {
                Log.debug((String)"geonetwork.mef", (Object)(" - Setting privileges for group : " + grpName));
            }
            groupsToAdd.add(groupEntity);
            opAllowedToAdd.addAll(Importer.addOperations(context, accessManager, metadataOperations, group, metadataId, groupEntity.getId()));
            if (!groupOwner) continue;
            if (Log.isDebugEnabled((String)"geonetwork.mef")) {
                Log.debug((String)"geonetwork.mef", (Object)(grpName + " set as group Owner "));
            }
            owner = groupEntity;
        }
        allowedRepository.saveAll(opAllowedToAdd);
        return owner;
    }

    private static Set<OperationAllowed> addOperations(ServiceContext context, AccessManager accessManager, IMetadataOperations metadataOperations, Element group, int metadataId, int grpId) {
        List operations = group.getChildren("operation");
        HashSet<OperationAllowed> toAdd = new HashSet<OperationAllowed>();
        for (Element operation : operations) {
            Optional<OperationAllowed> opAllowed;
            String opName = operation.getAttributeValue("name");
            int opId = accessManager.getPrivilegeId(opName);
            if (opId == -1) {
                if (!Log.isDebugEnabled((String)"geonetwork.mef")) continue;
                Log.debug((String)"geonetwork.mef", (Object)("   Skipping --> " + opName));
                continue;
            }
            if (Log.isDebugEnabled((String)"geonetwork.mef")) {
                Log.debug((String)"geonetwork.mef", (Object)("   Adding --> " + opName));
            }
            if (!(opAllowed = metadataOperations.getOperationAllowedToAdd(context, metadataId, grpId, opId)).isPresent()) continue;
            toAdd.add((OperationAllowed)opAllowed.get());
        }
        return toAdd;
    }

    private static Element updateMetadataUuidReferences(Element xml, String oldUuid, String newUuid) throws IOException, JDOMException {
        String data = Xml.getString((Element)xml);
        return Xml.loadString((String)data.replace(oldUuid, newUuid), (boolean)false);
    }
}

