/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.graph;

import com.carrotsearch.hppc.ObjectIntHashMap;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.client.graph.Vertex;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class Connection {
    private Vertex from;
    private Vertex to;
    private double weight;
    private long docCount;
    private static final ParseField SOURCE = new ParseField("source", new String[0]);
    private static final ParseField TARGET = new ParseField("target", new String[0]);
    private static final ParseField WEIGHT = new ParseField("weight", new String[0]);
    private static final ParseField DOC_COUNT = new ParseField("doc_count", new String[0]);

    public Connection(Vertex from, Vertex to, double weight, long docCount) {
        this.from = from;
        this.to = to;
        this.weight = weight;
        this.docCount = docCount;
    }

    Connection() {
    }

    public ConnectionId getId() {
        return new ConnectionId(this.from.getId(), this.to.getId());
    }

    public Vertex getFrom() {
        return this.from;
    }

    public Vertex getTo() {
        return this.to;
    }

    public double getWeight() {
        return this.weight;
    }

    public long getDocCount() {
        return this.docCount;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Connection other = (Connection)obj;
        return this.docCount == other.docCount && this.weight == other.weight && Objects.equals(this.to, other.to) && Objects.equals(this.from, other.from);
    }

    public int hashCode() {
        return Objects.hash(this.docCount, this.weight, this.from, this.to);
    }

    void toXContent(XContentBuilder builder, ToXContent.Params params, ObjectIntHashMap<Vertex> vertexNumbers) throws IOException {
        builder.field(SOURCE.getPreferredName(), vertexNumbers.get((Object)this.from));
        builder.field(TARGET.getPreferredName(), vertexNumbers.get((Object)this.to));
        builder.field(WEIGHT.getPreferredName(), this.weight);
        builder.field(DOC_COUNT.getPreferredName(), this.docCount);
    }

    public static class ConnectionId {
        private final Vertex.VertexId source;
        private final Vertex.VertexId target;

        public ConnectionId(Vertex.VertexId source, Vertex.VertexId target) {
            this.source = source;
            this.target = target;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConnectionId vertexId = (ConnectionId)o;
            if (this.source != null ? !this.source.equals(vertexId.source) : vertexId.source != null) {
                return false;
            }
            return !(this.target != null ? !this.target.equals(vertexId.target) : vertexId.target != null);
        }

        public int hashCode() {
            int result = this.source != null ? this.source.hashCode() : 0;
            result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
            return result;
        }

        public Vertex.VertexId getSource() {
            return this.source;
        }

        public Vertex.VertexId getTarget() {
            return this.target;
        }

        public String toString() {
            return this.getSource() + "->" + this.getTarget();
        }
    }

    static class UnresolvedConnection {
        int fromIndex;
        int toIndex;
        double weight;
        long docCount;
        private static final ConstructingObjectParser<UnresolvedConnection, Void> PARSER = new ConstructingObjectParser("ConnectionParser", true, args -> {
            int source = (Integer)args[0];
            int target = (Integer)args[1];
            double weight = (Double)args[2];
            long docCount = (Long)args[3];
            return new UnresolvedConnection(source, target, weight, docCount);
        });

        UnresolvedConnection(int fromIndex, int toIndex, double weight, long docCount) {
            this.fromIndex = fromIndex;
            this.toIndex = toIndex;
            this.weight = weight;
            this.docCount = docCount;
        }

        public Connection resolve(List<Vertex> vertices) {
            return new Connection(vertices.get(this.fromIndex), vertices.get(this.toIndex), this.weight, this.docCount);
        }

        static UnresolvedConnection fromXContent(XContentParser parser) throws IOException {
            return (UnresolvedConnection)PARSER.apply(parser, null);
        }

        static {
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), SOURCE);
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), TARGET);
            PARSER.declareDouble(ConstructingObjectParser.constructorArg(), WEIGHT);
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), DOC_COUNT);
        }
    }
}

