/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.index.es;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.core.MainResponse;
import org.elasticsearch.client.indices.AnalyzeRequest;
import org.elasticsearch.client.indices.AnalyzeResponse;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.index.query.WrapperQueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.xcontent.XContentType;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;

public class EsRestClient
implements InitializingBean {
    private static EsRestClient instance;
    private RestHighLevelClient client;
    private String serverUrl;
    @Value(value="${es.protocol}")
    private String serverProtocol;
    @Value(value="${es.host}")
    private String serverHost;
    @Value(value="${es.port}")
    private String serverPort;
    @Value(value="${es.username}")
    private String username;
    @Value(value="${es.password}")
    private String password;
    private boolean activated = false;
    @Value(value="${kb.url}")
    private String dashboardAppUrl;
    public static final String ROUTING_KEY = "101";

    public static EsRestClient get() {
        return instance;
    }

    public RestHighLevelClient getClient() {
        return this.client;
    }

    public String getDashboardAppUrl() {
        return this.dashboardAppUrl;
    }

    public void setDashboardAppUrl(String dashboardAppUrl) {
        this.dashboardAppUrl = dashboardAppUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        if (StringUtils.isBlank((String)this.serverProtocol) || StringUtils.isBlank((String)this.serverHost) || StringUtils.isBlank((String)this.serverPort)) {
            Log.error((String)"geonetwork.index", (Object)String.format("Elasticsearch URL defined by serverProtocol='%s', serverHost='%s', serverPort='%s' is missing. Check configuration.", this.serverProtocol, this.serverHost, this.serverPort));
        }
        this.serverUrl = this.serverProtocol + "://" + this.serverHost + ":" + this.serverPort;
        if (StringUtils.isNotEmpty((String)this.serverUrl)) {
            RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(this.serverHost, Integer.parseInt(this.serverPort), this.serverProtocol)});
            if (this.serverProtocol.startsWith("https")) {
                SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

                    public boolean isTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                        return true;
                    }
                }).build();
                NoopHostnameVerifier hostnameVerifier = NoopHostnameVerifier.INSTANCE;
                SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)hostnameVerifier);
                SSLIOSessionStrategy httpsIOSessionStrategy = new SSLIOSessionStrategy(sslContext, (HostnameVerifier)hostnameVerifier);
                if (StringUtils.isNotEmpty((String)this.username) && StringUtils.isNotEmpty((String)this.password)) {
                    BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                    credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.username, this.password));
                    builder.setHttpClientConfigCallback(arg_0 -> EsRestClient.lambda$afterPropertiesSet$0(sslContext, (CredentialsProvider)credentialsProvider, arg_0));
                } else {
                    builder.setHttpClientConfigCallback(httpClientBuilder -> httpClientBuilder.useSystemProperties().setSSLContext(sslContext));
                }
            } else if (StringUtils.isNotEmpty((String)this.username) && StringUtils.isNotEmpty((String)this.password)) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.username, this.password));
                builder.setHttpClientConfigCallback(arg_0 -> EsRestClient.lambda$afterPropertiesSet$2((CredentialsProvider)credentialsProvider, arg_0));
            } else {
                builder.setHttpClientConfigCallback(httpClientBuilder -> httpClientBuilder.useSystemProperties());
            }
            this.client = new RestHighLevelClient(builder);
            Class<EsRestClient> clazz = EsRestClient.class;
            synchronized (EsRestClient.class) {
                instance = this;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                this.activated = true;
            }
        } else {
            Log.debug((String)"geonetwork.index", (Object)String.format("No Elasticsearch URL defined '%s'. Check configuration.", this.serverUrl));
        }
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public EsRestClient setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public EsRestClient setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public EsRestClient setPassword(String password) {
        this.password = password;
        return this;
    }

    public BulkResponse bulkRequest(String index, Map<String, String> docs) throws IOException {
        if (!this.activated) {
            throw new IOException("Index not yet activated.");
        }
        BulkRequest request = new BulkRequest();
        request.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        for (Map.Entry<String, String> entry : docs.entrySet()) {
            request.add(new IndexRequest(index).id(entry.getKey()).source(entry.getValue(), XContentType.JSON));
        }
        try {
            return this.client.bulk(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public SearchResponse query(String index, String luceneQuery, String filterQuery, Set<String> includedFields, Map<String, String> scriptedFields, int from, int size) throws Exception {
        return this.query(index, luceneQuery, filterQuery, includedFields, scriptedFields, from, size, null);
    }

    public SearchResponse query(String index, String luceneQuery, String filterQuery, Set<String> includedFields, int from, int size) throws Exception {
        return this.query(index, luceneQuery, filterQuery, includedFields, new HashMap<String, String>(), from, size, null);
    }

    public SearchResponse query(String index, String luceneQuery, String filterQuery, Set<String> includedFields, Map<String, String> scriptedFields, int from, int size, List<SortBuilder<FieldSortBuilder>> sort) throws Exception {
        QueryStringQueryBuilder query = QueryBuilders.queryStringQuery((String)luceneQuery);
        QueryStringQueryBuilder filter = null;
        if (StringUtils.isNotEmpty((String)filterQuery)) {
            filter = QueryBuilders.queryStringQuery((String)filterQuery);
        }
        return this.query(index, (QueryBuilder)query, (QueryBuilder)filter, includedFields, scriptedFields, from, size, sort);
    }

    public SearchResponse query(String index, JsonNode jsonQuery, QueryBuilder postFilterBuilder, Set<String> includedFields, Map<String, String> scriptedFields, int from, int size) throws Exception {
        return this.query(index, jsonQuery, postFilterBuilder, includedFields, scriptedFields, from, size, null);
    }

    public SearchResponse query(String index, JsonNode jsonQuery, QueryBuilder postFilterBuilder, Set<String> includedFields, int from, int size) throws Exception {
        return this.query(index, jsonQuery, postFilterBuilder, includedFields, new HashMap<String, String>(), from, size, null);
    }

    public SearchResponse query(String index, JsonNode jsonQuery, QueryBuilder postFilterBuilder, Set<String> includedFields, Map<String, String> scriptedFields, int from, int size, List<SortBuilder<FieldSortBuilder>> sort) throws Exception {
        WrapperQueryBuilder query = QueryBuilders.wrapperQuery((String)String.valueOf(jsonQuery));
        return this.query(index, (QueryBuilder)query, postFilterBuilder, includedFields, scriptedFields, from, size, sort);
    }

    public SearchResponse query(String index, QueryBuilder queryBuilder, QueryBuilder postFilterBuilder, Set<String> includedFields, Map<String, String> scriptedFields, int from, int size, List<SortBuilder<FieldSortBuilder>> sort) throws Exception {
        if (!this.activated) {
            return null;
        }
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.indices(new String[]{index});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query(queryBuilder);
        if (MapUtils.isNotEmpty(scriptedFields)) {
            for (Map.Entry<String, String> scriptedField : scriptedFields.entrySet()) {
                searchSourceBuilder.scriptField(scriptedField.getKey(), new Script(scriptedField.getValue()));
            }
        }
        searchSourceBuilder.fetchSource(includedFields.toArray(new String[includedFields.size()]), null);
        searchSourceBuilder.from(from);
        searchSourceBuilder.size(size);
        searchSourceBuilder.trackTotalHits(true);
        if (postFilterBuilder != null) {
            searchSourceBuilder.postFilter(postFilterBuilder);
        }
        if (sort != null && !sort.isEmpty()) {
            sort.forEach(arg_0 -> ((SearchSourceBuilder)searchSourceBuilder).sort(arg_0));
        }
        searchRequest.source(searchSourceBuilder);
        try {
            SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
            if (searchResponse.status().getStatus() == 200) {
                return searchResponse;
            }
            throw new IOException(String.format("Error during querying index. Errors is '%s'.", searchResponse.status().toString()));
        }
        catch (ElasticsearchStatusException esException) {
            Throwable[] suppressed = esException.getSuppressed();
            if (suppressed.length > 0 && suppressed[0] instanceof ResponseException) {
                ResponseException re = (ResponseException)suppressed[0];
                Log.error((String)"geonetwork.index", (Object)String.format("Error during querying index. %s", re.getMessage()));
            }
            throw esException;
        }
    }

    public String deleteByQuery(String index, String query) throws Exception {
        if (!this.activated) {
            return "";
        }
        DeleteByQueryRequest request = new DeleteByQueryRequest();
        request.setRefresh(true);
        request.indices(new String[]{index});
        request.setQuery((QueryBuilder)new QueryStringQueryBuilder(query));
        BulkByScrollResponse deleteByQueryResponse = this.client.deleteByQuery(request, RequestOptions.DEFAULT);
        if (deleteByQueryResponse.getStatus().getDeleted() >= 0L) {
            return String.format("Record removed. %s.", deleteByQueryResponse.getStatus().getDeleted());
        }
        throw new IOException(String.format("Error during removal. Errors is '%s'.", deleteByQueryResponse.getStatus().getReasonCancelled()));
    }

    public Map<String, Object> getDocument(String index, String id) throws Exception {
        if (!this.activated) {
            return Collections.emptyMap();
        }
        GetRequest request = ((GetRequest)new GetRequest().index(index)).id(id);
        return this.client.get(request, RequestOptions.DEFAULT).getSourceAsMap();
    }

    public Map<String, String> getFieldsValues(String index, String id, Set<String> fields, String language) throws Exception {
        if (!this.activated) {
            return Collections.emptyMap();
        }
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        Map<String, Object> sources = this.getDocument(index, id);
        for (String field : fields) {
            Object value = sources.get(field);
            if (value instanceof String) {
                fieldValues.put(field, (String)value);
                continue;
            }
            if (!(value instanceof Map) || !field.endsWith("Object")) continue;
            Map valueMap = (Map)value;
            String languageValue = (String)valueMap.get("lang" + language);
            fieldValues.put(field, languageValue != null ? languageValue : (String)valueMap.get("default"));
        }
        return fieldValues;
    }

    public static String analyzeField(String collection, String analyzer, String fieldValue) {
        AnalyzeRequest request = AnalyzeRequest.withIndexAnalyzer((String)collection, (String)analyzer, (String[])new String[]{fieldValue.replace(",", "")});
        try {
            AnalyzeResponse response = EsRestClient.get().client.indices().analyze(request, RequestOptions.DEFAULT);
            List tokens = response.getTokens();
            if (tokens.size() == 1) {
                String type = ((AnalyzeResponse.AnalyzeToken)tokens.get(0)).getType();
                if ("SYNONYM".equals(type) || "word".equals(type)) {
                    return ((AnalyzeResponse.AnalyzeToken)tokens.get(0)).getTerm();
                }
                return "";
            }
            return "";
        }
        catch (Exception ex) {
            return "";
        }
    }

    protected void finalize() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getServerStatus() throws IOException {
        ClusterHealthRequest request = new ClusterHealthRequest();
        ClusterHealthResponse response = this.client.cluster().health(request, RequestOptions.DEFAULT);
        return response.getStatus().toString();
    }

    public String getServerVersion() throws IOException, ElasticsearchException {
        MainResponse.Version version = this.client.info(RequestOptions.DEFAULT).getVersion();
        return version.getNumber();
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$afterPropertiesSet$2(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.useSystemProperties().setDefaultCredentialsProvider(credentialsProvider);
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$afterPropertiesSet$0(SSLContext sslContext, CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.useSystemProperties().setSSLContext(sslContext).setDefaultCredentialsProvider(credentialsProvider);
    }
}

