/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.query.CoordinatorRewriteContext;
import org.elasticsearch.index.shard.IndexLongFieldRange;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class CoordinatorRewriteContextProvider {
    private final NamedXContentRegistry xContentRegistry;
    private final NamedWriteableRegistry writeableRegistry;
    private final Client client;
    private final LongSupplier nowInMillis;
    private final Supplier<ClusterState> clusterStateSupplier;
    private final Function<Index, DateFieldMapper.DateFieldType> mappingSupplier;

    public CoordinatorRewriteContextProvider(NamedXContentRegistry xContentRegistry, NamedWriteableRegistry writeableRegistry, Client client, LongSupplier nowInMillis, Supplier<ClusterState> clusterStateSupplier, Function<Index, DateFieldMapper.DateFieldType> mappingSupplier) {
        this.xContentRegistry = xContentRegistry;
        this.writeableRegistry = writeableRegistry;
        this.client = client;
        this.nowInMillis = nowInMillis;
        this.clusterStateSupplier = clusterStateSupplier;
        this.mappingSupplier = mappingSupplier;
    }

    @Nullable
    public CoordinatorRewriteContext getCoordinatorRewriteContext(Index index) {
        ClusterState clusterState = this.clusterStateSupplier.get();
        IndexMetadata indexMetadata = clusterState.metadata().index(index);
        if (indexMetadata == null || !indexMetadata.getTimestampRange().containsAllShardRanges()) {
            return null;
        }
        DateFieldMapper.DateFieldType dateFieldType = this.mappingSupplier.apply(index);
        if (dateFieldType == null) {
            return null;
        }
        IndexLongFieldRange timestampRange = indexMetadata.getTimestampRange();
        return new CoordinatorRewriteContext(this.xContentRegistry, this.writeableRegistry, this.client, this.nowInMillis, index, timestampRange, dateFieldType);
    }
}

