/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage;

import java.awt.image.ColorModel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.Objects;
import javax.measure.Unit;
import org.geotools.coverage.Category;
import org.geotools.coverage.ColorModelFactory;
import org.geotools.metadata.i18n.Errors;
import org.geotools.metadata.i18n.Vocabulary;
import org.geotools.referencing.wkt.UnformattableObjectException;
import org.geotools.util.AbstractInternationalString;
import org.geotools.util.Classes;
import org.geotools.util.NumberRange;
import org.geotools.util.Utilities;
import org.opengis.util.InternationalString;

class CategoryList
extends AbstractList<Category>
implements Comparator<Category>,
Serializable {
    private static final long serialVersionUID = 2647846361059903365L;
    private transient NumberRange<?> range;
    private final double[] minimums;
    private final Category[] categories;
    private final Category main;
    final Category nodata;
    private final Category overflowFallback;
    private transient Category last;
    private final boolean hasGaps;
    private transient InternationalString name;
    private Unit<?> unit;

    public CategoryList(Category[] categories, Unit<?> units) throws IllegalArgumentException {
        this(categories, units, false);
    }

    CategoryList(Category[] categories, Unit<?> units, boolean searchNearest) throws IllegalArgumentException {
        categories = (Category[])categories.clone();
        this.categories = categories;
        Arrays.sort(categories, this);
        assert (CategoryList.isSorted(categories));
        boolean hasGaps = false;
        this.minimums = new double[categories.length];
        for (int i = 0; i < categories.length; ++i) {
            double minimum = this.minimums[i] = categories[i].minimum;
            if (i == 0) continue;
            assert (!(minimum < this.minimums[i - 1])) : minimum;
            Category previous = categories[i - 1];
            if (CategoryList.compare(minimum, previous.maximum) <= 0) {
                NumberRange<? extends Number> range1 = categories[i - 1].getRange();
                NumberRange<? extends Number> range2 = categories[i - 0].getRange();
                Comparable[] args = new Comparable[]{range1.getMinValue(), range1.getMaxValue(), range2.getMinValue(), range2.getMaxValue()};
                for (int j = 0; j < args.length; ++j) {
                    float value;
                    if (!(args[j] instanceof Number) || !Float.isNaN(value = ((Number)((Object)args[j])).floatValue())) continue;
                    String hex = Integer.toHexString(Float.floatToRawIntBits(value));
                    args[j] = "NaN(" + hex + ')';
                }
                throw new IllegalArgumentException(Errors.format((int)162, (Object)args));
            }
            if (Double.isNaN(minimum) || minimum == previous.getRange().getMaximum(false)) continue;
            hasGaps = true;
        }
        this.hasGaps = hasGaps;
        Category nodata = Category.NODATA;
        long nodataBits = Double.doubleToRawLongBits(Double.NaN);
        int i = categories.length;
        while (--i >= 0) {
            Category candidate = categories[i];
            double value = candidate.minimum;
            if (!Double.isNaN(value)) continue;
            nodata = candidate;
            if (Double.doubleToRawLongBits(value) != nodataBits) continue;
            break;
        }
        this.nodata = nodata;
        double range = 0.0;
        Category main = null;
        int i2 = categories.length;
        while (--i2 >= 0) {
            Category candidate = categories[i2];
            if (!candidate.isQuantitative()) continue;
            Category candidatePeer = candidate;
            double candidateRange = candidatePeer.maximum - candidatePeer.minimum;
            if (!(candidateRange >= range)) continue;
            range = candidateRange;
            main = candidate;
        }
        this.main = main;
        this.last = main != null || categories.length == 0 ? main : categories[0];
        Category overflowFallback = null;
        if (searchNearest) {
            int i3 = categories.length;
            while (--i3 >= 0) {
                Category category = categories[i3];
                if (Double.isNaN(category.maximum)) continue;
                overflowFallback = category;
                break;
            }
        }
        this.overflowFallback = overflowFallback;
        this.unit = units;
    }

    @Override
    public final int compare(Category o1, Category o2) {
        return CategoryList.compare(o1.minimum, o2.minimum);
    }

    private static int compare(double v1, double v2) {
        if (Double.isNaN(v1) && Double.isNaN(v2)) {
            long bits2;
            long bits1 = Double.doubleToRawLongBits(v1);
            if (bits1 < (bits2 = Double.doubleToRawLongBits(v2))) {
                return -1;
            }
            if (bits1 > bits2) {
                return 1;
            }
        }
        return Double.compare(v1, v2);
    }

    static boolean isSorted(Category[] categories) {
        for (int i = 1; i < categories.length; ++i) {
            Category c;
            if (!$assertionsDisabled) {
                Category category;
                c = categories[i - 0];
                if (category.minimum > c.maximum) {
                    throw new AssertionError(c);
                }
            }
            if (!$assertionsDisabled) {
                Category category;
                c = categories[i - 1];
                if (category.minimum > c.maximum) {
                    throw new AssertionError(c);
                }
            }
            if (CategoryList.compare(categories[i - 1].maximum, categories[i].minimum) <= 0) continue;
            return false;
        }
        return true;
    }

    static int binarySearch(double[] array, double key) {
        int low = 0;
        int high = array.length - 1;
        boolean keyIsNaN = Double.isNaN(key);
        while (low <= high) {
            boolean adjustLow;
            long keyRawBits;
            int mid = low + high >> 1;
            double midVal = array[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            long midRawBits = Double.doubleToRawLongBits(midVal);
            if (midRawBits == (keyRawBits = Double.doubleToRawLongBits(key))) {
                return mid;
            }
            boolean midIsNaN = Double.isNaN(midVal);
            if (keyIsNaN) {
                adjustLow = !midIsNaN || midRawBits < keyRawBits;
            } else {
                boolean bl = adjustLow = !midIsNaN && midRawBits < keyRawBits;
            }
            if (adjustLow) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return -(low + 1);
    }

    public final InternationalString getName() {
        if (this.name == null) {
            this.name = new Name();
        }
        return this.name;
    }

    public Unit<?> getUnits() {
        return this.unit;
    }

    public final NumberRange<?> getRange() {
        if (this.range == null) {
            NumberRange range = null;
            for (Category category : this.categories) {
                NumberRange extent = category.getRange();
                if (Double.isNaN(extent.getMinimum()) || Double.isNaN(extent.getMaximum())) continue;
                range = range != null ? range.union(extent) : extent;
            }
            this.range = range;
        }
        return this.range;
    }

    private StringBuffer formatRange(StringBuffer buffer, Locale locale) {
        NumberRange<?> range = this.getRange();
        buffer.append('[');
        if (range != null) {
            buffer = this.format(range.getMinimum(), false, locale, buffer);
            buffer.append(" ... ");
            buffer = this.format(range.getMaximum(), true, locale, buffer);
        } else {
            Unit<?> unit = this.getUnits();
            if (unit != null) {
                buffer.append(unit);
            }
        }
        buffer.append(']');
        return buffer;
    }

    StringBuffer format(double value, boolean writeUnits, Locale locale, StringBuffer buffer) {
        return buffer.append(value);
    }

    public final ColorModel getColorModel(int visibleBand, int numBands) {
        int type = 4;
        NumberRange<?> range = this.getRange();
        Class rt = range.getElementClass();
        if (Byte.class.equals((Object)rt) || Short.class.equals((Object)rt) || Integer.class.equals((Object)rt)) {
            int min = ((Number)((Object)range.getMinValue())).intValue();
            int max = ((Number)((Object)range.getMaxValue())).intValue();
            type = min >= 0 ? (max < 256 ? 0 : (max < 65536 ? 1 : 3)) : (min >= Short.MIN_VALUE && max <= Short.MAX_VALUE ? 2 : 3);
        }
        return this.getColorModel(visibleBand, numBands, type);
    }

    public final ColorModel getColorModel(int visibleBand, int numBands, int type) {
        return ColorModelFactory.getColorModel(this.categories, type, visibleBand, numBands);
    }

    public final Category getCategory(double sample) {
        int i = CategoryList.binarySearch(this.minimums, sample);
        if (i >= 0) {
            assert (Double.doubleToRawLongBits(sample) == Double.doubleToRawLongBits(this.minimums[i]));
            return this.categories[i];
        }
        if (Double.isNaN(sample)) {
            return null;
        }
        assert (i == Arrays.binarySearch(this.minimums, sample)) : i;
        if ((i = ~i - 1) >= 0) {
            Category category = this.categories[i];
            assert (sample > category.minimum) : sample;
            if (sample <= category.maximum) {
                return category;
            }
            if (this.overflowFallback != null) {
                if (++i < this.categories.length) {
                    Category upper = this.categories[i];
                    assert (!(upper.minimum <= sample)) : sample;
                    return upper.minimum - sample < sample - category.maximum ? upper : category;
                }
                return this.overflowFallback;
            }
        } else if (this.overflowFallback != null && this.categories.length != 0) {
            Category category = this.categories[0];
            if (!Double.isNaN(category.minimum)) {
                return category;
            }
        }
        return null;
    }

    public final String format(double value, Locale locale) {
        if (Double.isNaN(value)) {
            Category category = this.last;
            if (!(value >= category.minimum && value <= category.maximum || Double.doubleToRawLongBits(value) == Double.doubleToRawLongBits(category.minimum))) {
                category = this.getCategory(value);
                if (category == null) {
                    return Vocabulary.getResources((Locale)locale).getString(232);
                }
                this.last = category;
            }
            return category.getName().toString(null);
        }
        return this.format(value, true, locale, new StringBuffer()).toString();
    }

    @Override
    public final int size() {
        return this.categories.length;
    }

    @Override
    public final Category get(int i) {
        return this.categories[i];
    }

    public final Category[] toArray() {
        return (Category[])this.categories.clone();
    }

    @Override
    public final String toString() {
        return this.toString(this, null);
    }

    final String toString(Object owner, InternationalString description) {
        String lineSeparator = System.getProperty("line.separator", "\n");
        StringBuffer buffer = new StringBuffer(Classes.getShortClassName((Object)owner));
        buffer.append('(');
        if (description != null && description != this.name) {
            buffer.append('\"').append((CharSequence)description).append("\":");
        }
        buffer = this.formatRange(buffer, null);
        if (this.hasGaps) {
            buffer.append(" with gaps");
        }
        buffer.append(')').append(lineSeparator);
        for (Category category : this.categories) {
            buffer.append("  ").append(category == this.main ? (char)'\u2023' : ' ').append(' ').append(category).append(lineSeparator);
        }
        return buffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof CategoryList) {
            CategoryList that = (CategoryList)object;
            if (Arrays.equals(this.categories, that.categories)) {
                assert (Arrays.equals(this.minimums, that.minimums));
                return Utilities.equals((Object)this.overflowFallback, (Object)that.overflowFallback);
            }
            return false;
        }
        return this.overflowFallback == null && super.equals(object);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.range, this.main, this.nodata, this.overflowFallback, this.last, this.hasGaps, this.name, this.unit);
        result = 31 * result + Arrays.hashCode(this.minimums);
        result = 31 * result + Arrays.hashCode(this.categories);
        return result;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.last = this.main != null || this.categories.length == 0 ? this.main : this.categories[0];
    }

    public final int getSourceDimensions() {
        return 1;
    }

    public final int getTargetDimensions() {
        return 1;
    }

    public boolean isIdentity() {
        return false;
    }

    public String toWKT() throws UnsupportedOperationException {
        throw new UnformattableObjectException("Not yet implemented.", this.getClass());
    }

    private final class Name
    extends AbstractInternationalString {
        private Name() {
        }

        public String toString(Locale locale) {
            StringBuffer buffer = new StringBuffer(30);
            if (CategoryList.this.main != null) {
                buffer.append(CategoryList.this.main.getName().toString(locale));
            } else {
                buffer.append('(');
                buffer.append(Vocabulary.getResources((Locale)locale).getString(232));
                buffer.append(')');
            }
            buffer.append(' ');
            return String.valueOf(CategoryList.this.formatRange(buffer, locale));
        }

        public String toString() {
            return this.toString(Locale.getDefault());
        }
    }
}

