/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.join.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.SortedSetOrdinalsIndexFieldData;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.join.mapper.Joiner;
import org.elasticsearch.join.mapper.ParentIdFieldMapper;
import org.elasticsearch.join.mapper.Relations;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public final class ParentJoinFieldMapper
extends FieldMapper {
    public static final String NAME = "join";
    public static final String CONTENT_TYPE = "join";
    public static FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> {
        ParentJoinFieldMapper.checkIndexCompatibility(c.getIndexSettings(), n);
        return new Builder((String)n);
    });
    private final Map<String, ParentIdFieldMapper> parentIdFields;
    private final boolean eagerGlobalOrdinals;
    private final List<Relations> relations;

    private static void checkIndexCompatibility(IndexSettings settings, String name) {
        if (settings.getIndexMetadata().isRoutingPartitionedIndex()) {
            throw new IllegalStateException("cannot create join field [" + name + "] for the partitioned index [" + settings.getIndex().getName() + "]");
        }
    }

    private static void checkObjectOrNested(MapperBuilderContext context, String name) {
        String fullName = context.buildFullName(name);
        if (!fullName.equals(name)) {
            throw new IllegalArgumentException("join field [" + fullName + "] cannot be added inside an object or in a multi-field");
        }
    }

    private static ParentJoinFieldMapper toType(FieldMapper in) {
        return (ParentJoinFieldMapper)in;
    }

    private static boolean checkRelationsConflicts(List<Relations> previous, List<Relations> current, FieldMapper.Conflicts conflicts) {
        Joiner pj = new Joiner("f", previous);
        Joiner cj = new Joiner("f", current);
        return pj.canMerge(cj, s -> conflicts.addConflict("relations", s));
    }

    protected ParentJoinFieldMapper(String simpleName, MappedFieldType mappedFieldType, Map<String, ParentIdFieldMapper> parentIdFields, boolean eagerGlobalOrdinals, List<Relations> relations) {
        super(simpleName, mappedFieldType, Lucene.KEYWORD_ANALYZER, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty());
        this.parentIdFields = parentIdFields;
        this.eagerGlobalOrdinals = eagerGlobalOrdinals;
        this.relations = relations;
    }

    protected String contentType() {
        return "join";
    }

    public JoinFieldType fieldType() {
        return (JoinFieldType)super.fieldType();
    }

    public Iterator<Mapper> iterator() {
        ArrayList<ParentIdFieldMapper> mappers = new ArrayList<ParentIdFieldMapper>(this.parentIdFields.values());
        return mappers.iterator();
    }

    protected void parseCreateField(DocumentParserContext context) {
        throw new UnsupportedOperationException("parsing is implemented in parse(), this method should NEVER be called");
    }

    public void parse(DocumentParserContext context) throws IOException {
        String fieldName;
        context.path().add(this.simpleName());
        XContentParser.Token token = context.parser().currentToken();
        String name = null;
        String parent = null;
        if (token == XContentParser.Token.START_OBJECT) {
            String currentFieldName = null;
            while ((token = context.parser().nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = context.parser().currentName();
                    continue;
                }
                if (token == XContentParser.Token.VALUE_STRING) {
                    if ("name".equals(currentFieldName)) {
                        name = context.parser().text();
                        continue;
                    }
                    if ("parent".equals(currentFieldName)) {
                        parent = context.parser().text();
                        continue;
                    }
                    throw new IllegalArgumentException("unknown field name [" + currentFieldName + "] in join field [" + this.name() + "]");
                }
                if (token != XContentParser.Token.VALUE_NUMBER) continue;
                if ("parent".equals(currentFieldName)) {
                    parent = context.parser().numberValue().toString();
                    continue;
                }
                throw new IllegalArgumentException("unknown field name [" + currentFieldName + "] in join field [" + this.name() + "]");
            }
        } else if (token == XContentParser.Token.VALUE_STRING) {
            name = context.parser().text();
            parent = null;
        } else {
            throw new IllegalStateException("[" + this.name() + "] expected START_OBJECT or VALUE_STRING but was: " + token);
        }
        if (name == null) {
            throw new IllegalArgumentException("null join name in field [" + this.name() + "]");
        }
        if (!this.fieldType().joiner.knownRelation(name)) {
            throw new IllegalArgumentException("unknown join name [" + name + "] for field [" + this.name() + "]");
        }
        if (this.fieldType().joiner.childTypeExists(name)) {
            if (parent == null) {
                throw new IllegalArgumentException("[parent] is missing for join field [" + this.name() + "]");
            }
            if (context.sourceToParse().routing() == null) {
                throw new IllegalArgumentException("[routing] is missing for join field [" + this.name() + "]");
            }
            fieldName = this.fieldType().joiner.parentJoinField(name);
            this.parentIdFields.get(fieldName).indexValue(context, parent);
        }
        if (this.fieldType().joiner.parentTypeExists(name)) {
            fieldName = this.fieldType().joiner.childJoinField(name);
            this.parentIdFields.get(fieldName).indexValue(context, context.sourceToParse().id());
        }
        BytesRef binaryValue = new BytesRef((CharSequence)name);
        Field field = new Field(this.fieldType().name(), binaryValue, (IndexableFieldType)Defaults.FIELD_TYPE);
        context.doc().add((IndexableField)field);
        context.doc().add((IndexableField)new SortedDocValuesField(this.fieldType().name(), binaryValue));
        context.path().remove();
    }

    protected void doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("type", this.contentType());
        builder.field("eager_global_ordinals", this.eagerGlobalOrdinals);
        builder.startObject("relations");
        for (Relations relation : this.relations) {
            if (relation.children.size() == 1) {
                builder.field(relation.parent, relation.children.iterator().next());
                continue;
            }
            builder.field(relation.parent, relation.children);
        }
        builder.endObject();
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName()).init(this);
    }

    protected void doValidate(MappingLookup mappingLookup) {
        List joinFields = mappingLookup.getMatchingFieldNames("*").stream().map(arg_0 -> ((MappingLookup)mappingLookup).getFieldType(arg_0)).filter(ft -> ft instanceof JoinFieldType).map(MappedFieldType::name).collect(Collectors.toList());
        if (joinFields.size() > 1) {
            throw new IllegalArgumentException("Only one [parent-join] field can be defined per index, got " + joinFields);
        }
    }

    public static final class JoinFieldType
    extends StringFieldType {
        private final Joiner joiner;

        private JoinFieldType(String name, Joiner joiner, Map<String, String> meta) {
            super(name, true, false, true, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            this.joiner = joiner;
        }

        Joiner getJoiner() {
            return this.joiner;
        }

        public String typeName() {
            return "join";
        }

        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            return new SortedSetOrdinalsIndexFieldData.Builder(this.name(), (ValuesSourceType)CoreValuesSourceType.KEYWORD);
        }

        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return SourceValueFetcher.identity((String)this.name(), (SearchExecutionContext)context, (String)format);
        }

        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            BytesRef binaryValue = (BytesRef)value;
            return binaryValue.utf8ToString();
        }
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.freeze();
        }
    }

    public static class Builder
    extends FieldMapper.Builder {
        final FieldMapper.Parameter<Boolean> eagerGlobalOrdinals = FieldMapper.Parameter.boolParam((String)"eager_global_ordinals", (boolean)true, m -> ParentJoinFieldMapper.access$500(ParentJoinFieldMapper.toType(m)), (boolean)true);
        final FieldMapper.Parameter<List<Relations>> relations = new FieldMapper.Parameter("relations", true, Collections::emptyList, (n, c, o) -> Relations.parse(o), m -> ParentJoinFieldMapper.access$400(ParentJoinFieldMapper.toType(m))).setMergeValidator((x$0, x$1, x$2) -> ParentJoinFieldMapper.access$200(x$0, x$1, x$2));
        final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();

        public Builder(String name) {
            super(name);
        }

        public Builder addRelation(String parent, Set<String> children) {
            this.relations.setValue(Collections.singletonList(new Relations(parent, children)));
            return this;
        }

        protected List<FieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.eagerGlobalOrdinals, this.relations, this.meta);
        }

        public ParentJoinFieldMapper build(MapperBuilderContext context) {
            ParentJoinFieldMapper.checkObjectOrNested(context, this.name);
            HashMap parentIdFields = new HashMap();
            ((List)this.relations.get()).stream().map(relation -> new ParentIdFieldMapper(this.name + "#" + relation.parent, (Boolean)this.eagerGlobalOrdinals.get())).forEach(mapper -> parentIdFields.put(mapper.name(), mapper));
            Joiner joiner = new Joiner(this.name(), (List)this.relations.get());
            return new ParentJoinFieldMapper(this.name, (MappedFieldType)new JoinFieldType(context.buildFullName(this.name), joiner, (Map)this.meta.get()), Collections.unmodifiableMap(parentIdFields), (Boolean)this.eagerGlobalOrdinals.get(), (List)this.relations.get());
        }
    }
}

