/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.util.Arrays;

public class Ranks {
    private final int index;

    private Ranks(int index) {
        this.index = index;
    }

    public static <T extends Comparable<T>> int[] ranks(T[] source, T[] target) {
        if (source == null) {
            return null;
        }
        Ranks[] entries = new Any[source.length];
        for (int i = 0; i < entries.length; ++i) {
            entries[i] = new Any<T>(i, source[i]);
        }
        int[] ranks = Ranks.ranks(entries);
        if (target != null) {
            int i = Math.min(entries.length, target.length);
            while (--i >= 0) {
                Ranks entry = entries[i];
                target[i] = ((Any)entry).value;
            }
        }
        return ranks;
    }

    public static int[] ranks(double[] source, double[] target) {
        if (source == null) {
            return null;
        }
        Ranks[] entries = new Double[source.length];
        for (int i = 0; i < entries.length; ++i) {
            entries[i] = new Double(i, source[i]);
        }
        int[] ranks = Ranks.ranks(entries);
        if (target != null) {
            int i = Math.min(entries.length, target.length);
            while (--i >= 0) {
                target[i] = ((Double)entries[i]).value;
            }
        }
        return ranks;
    }

    public static int[] ranks(float[] source, float[] target) {
        if (source == null) {
            return null;
        }
        Ranks[] entries = new Float[source.length];
        for (int i = 0; i < entries.length; ++i) {
            entries[i] = new Float(i, source[i]);
        }
        int[] ranks = Ranks.ranks(entries);
        if (target != null) {
            int i = Math.min(entries.length, target.length);
            while (--i >= 0) {
                target[i] = ((Float)entries[i]).value;
            }
        }
        return ranks;
    }

    public static int[] ranks(long[] source, long[] target) {
        if (source == null) {
            return null;
        }
        Ranks[] entries = new Long[source.length];
        for (int i = 0; i < entries.length; ++i) {
            entries[i] = new Long(i, source[i]);
        }
        int[] ranks = Ranks.ranks(entries);
        if (target != null) {
            int i = Math.min(entries.length, target.length);
            while (--i >= 0) {
                target[i] = ((Long)entries[i]).value;
            }
        }
        return ranks;
    }

    public static int[] ranks(int[] source, int[] target) {
        if (source == null) {
            return null;
        }
        Ranks[] entries = new Integer[source.length];
        for (int i = 0; i < entries.length; ++i) {
            entries[i] = new Integer(i, source[i]);
        }
        int[] ranks = Ranks.ranks(entries);
        if (target != null) {
            int i = Math.min(entries.length, target.length);
            while (--i >= 0) {
                target[i] = ((Integer)entries[i]).value;
            }
        }
        return ranks;
    }

    public static int[] ranks(short[] source, short[] target) {
        if (source == null) {
            return null;
        }
        Ranks[] entries = new Short[source.length];
        for (int i = 0; i < entries.length; ++i) {
            entries[i] = new Short(i, source[i]);
        }
        int[] ranks = Ranks.ranks(entries);
        if (target != null) {
            int i = Math.min(entries.length, target.length);
            while (--i >= 0) {
                target[i] = ((Short)entries[i]).value;
            }
        }
        return ranks;
    }

    public static int[] ranks(byte[] source, byte[] target) {
        if (source == null) {
            return null;
        }
        Ranks[] entries = new Byte[source.length];
        for (int i = 0; i < entries.length; ++i) {
            entries[i] = new Byte(i, source[i]);
        }
        int[] ranks = Ranks.ranks(entries);
        if (target != null) {
            int i = Math.min(entries.length, target.length);
            while (--i >= 0) {
                target[i] = ((Byte)entries[i]).value;
            }
        }
        return ranks;
    }

    private static int[] ranks(Ranks ... entries) {
        Arrays.sort(entries);
        int[] ranks = new int[entries.length];
        for (int i = 0; i < ranks.length; ++i) {
            ranks[i] = entries[i].index;
        }
        return ranks;
    }

    private static final class Byte
    extends Ranks
    implements Comparable<Byte> {
        private final byte value;

        Byte(int index, byte value) {
            super(index);
            this.value = value;
        }

        @Override
        public int compareTo(Byte other) {
            return this.value - other.value;
        }
    }

    private static final class Short
    extends Ranks
    implements Comparable<Short> {
        private final short value;

        Short(int index, short value) {
            super(index);
            this.value = value;
        }

        @Override
        public int compareTo(Short other) {
            return this.value - other.value;
        }
    }

    private static final class Integer
    extends Ranks
    implements Comparable<Integer> {
        private final int value;

        Integer(int index, int value) {
            super(index);
            this.value = value;
        }

        @Override
        public int compareTo(Integer other) {
            return this.value < other.value ? -1 : (this.value == other.value ? 0 : 1);
        }
    }

    private static final class Long
    extends Ranks
    implements Comparable<Long> {
        private final long value;

        Long(int index, long value) {
            super(index);
            this.value = value;
        }

        @Override
        public int compareTo(Long other) {
            return this.value < other.value ? -1 : (this.value == other.value ? 0 : 1);
        }
    }

    private static final class Float
    extends Ranks
    implements Comparable<Float> {
        private final float value;

        Float(int index, float value) {
            super(index);
            this.value = value;
        }

        @Override
        public int compareTo(Float other) {
            return java.lang.Float.compare(this.value, other.value);
        }
    }

    private static final class Double
    extends Ranks
    implements Comparable<Double> {
        private final double value;

        Double(int index, double value) {
            super(index);
            this.value = value;
        }

        @Override
        public int compareTo(Double other) {
            return java.lang.Double.compare(this.value, other.value);
        }
    }

    private static final class Any<T extends Comparable<T>>
    extends Ranks
    implements Comparable<Any<T>> {
        private final T value;

        Any(int index, T value) {
            super(index);
            this.value = value;
        }

        @Override
        public int compareTo(Any<T> other) {
            return this.value.compareTo(other.value);
        }
    }
}

