/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.indices;

import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.TimedRequest;
import org.elasticsearch.common.util.ArrayUtils;

public class GetIndexRequest
extends TimedRequest {
    public static final IndicesOptions DEFAULT_INDICES_OPTIONS = IndicesOptions.fromOptions((boolean)false, (boolean)false, (boolean)true, (boolean)true);
    static final Feature[] DEFAULT_FEATURES = new Feature[]{Feature.ALIASES, Feature.MAPPINGS, Feature.SETTINGS};
    private Feature[] features = DEFAULT_FEATURES;
    private boolean humanReadable = false;
    private transient boolean includeDefaults = false;
    private final String[] indices;
    private IndicesOptions indicesOptions = DEFAULT_INDICES_OPTIONS;
    private boolean local = false;

    public GetIndexRequest(String ... indices) {
        this.indices = indices;
    }

    public String[] indices() {
        return this.indices;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public GetIndexRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public final GetIndexRequest local(boolean local) {
        this.local = local;
        return this;
    }

    public final boolean local() {
        return this.local;
    }

    public GetIndexRequest features(Feature ... features) {
        if (features == null) {
            throw new IllegalArgumentException("features cannot be null");
        }
        this.features = features;
        return this;
    }

    public GetIndexRequest addFeatures(Feature ... featuresToAdd) {
        if (this.features == DEFAULT_FEATURES) {
            return this.features(featuresToAdd);
        }
        return this.features((Feature[])ArrayUtils.concat((Object[])this.features(), (Object[])featuresToAdd, Feature.class));
    }

    public Feature[] features() {
        return this.features;
    }

    public GetIndexRequest humanReadable(boolean humanReadable) {
        this.humanReadable = humanReadable;
        return this;
    }

    public boolean humanReadable() {
        return this.humanReadable;
    }

    public GetIndexRequest includeDefaults(boolean includeDefaults) {
        this.includeDefaults = includeDefaults;
        return this;
    }

    public boolean includeDefaults() {
        return this.includeDefaults;
    }

    public static enum Feature {
        ALIASES,
        MAPPINGS,
        SETTINGS;

    }
}

