/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.geotools.geometry.jts.CompoundCurvedGeometry;
import org.geotools.geometry.jts.CurvedGeometryFactory;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class XmlStreamGeometryReader {
    public static final double DEFAULT_CURVE_TOLERANCE = Double.MAX_VALUE;
    private final XMLStreamReader reader;
    private GeometryFactory geomFac;
    private CurvedGeometryFactory curvedGeometryFactory;
    private boolean unsafeXMLAllowed = false;
    private Predicate<CoordinateReferenceSystem> invertAxisNeeded = null;
    private final Map<CoordinateReferenceSystem, Boolean> invertAxisNeededCache = new HashMap<CoordinateReferenceSystem, Boolean>();
    private String gmlNamespace;

    public XmlStreamGeometryReader(XMLStreamReader reader) {
        this(reader, new GeometryFactory());
    }

    public XmlStreamGeometryReader(XMLStreamReader reader, GeometryFactory geometryFactory) {
        this(reader, geometryFactory, new CurvedGeometryFactory(geometryFactory, Double.MAX_VALUE));
    }

    public XmlStreamGeometryReader(XMLStreamReader reader, GeometryFactory geometryFactory, CurvedGeometryFactory curvedGeometryFactory) {
        this.reader = reader;
        this.geomFac = geometryFactory;
        this.curvedGeometryFactory = curvedGeometryFactory;
    }

    public void setGeometryFactory(GeometryFactory geometryFactory) {
        this.geomFac = geometryFactory;
    }

    public GeometryFactory getGeometryFactory() {
        return this.geomFac;
    }

    public boolean isUnsafeXMLAllowed() {
        return this.unsafeXMLAllowed;
    }

    public void setUnsafeXMLAllowed(boolean unsafeXMLAllowed) {
        this.unsafeXMLAllowed = unsafeXMLAllowed;
    }

    public void setInvertAxisNeeded(Predicate<CoordinateReferenceSystem> invertAxisNeeded) {
        this.invertAxisNeeded = invertAxisNeeded;
    }

    private void checkUnsafeXML() throws IllegalStateException {
        if (!this.unsafeXMLAllowed && Boolean.TRUE.equals(this.reader.getProperty("javax.xml.stream.supportDTD"))) {
            throw new IllegalStateException("XMLStreamReader allows DTDs but " + this.getClass().getSimpleName() + " is not configured to allow unsafe XML");
        }
    }

    public Geometry readGeometry() throws NoSuchAuthorityCodeException, FactoryException, XMLStreamException, IOException {
        Point geom;
        this.checkUnsafeXML();
        if ("http://www.opengis.net/gml".equals(this.reader.getNamespaceURI())) {
            this.gmlNamespace = "http://www.opengis.net/gml";
        } else if ("http://www.opengis.net/gml/3.2".equals(this.reader.getNamespaceURI())) {
            this.gmlNamespace = "http://www.opengis.net/gml/3.2";
        } else {
            throw new IllegalStateException("Expected a geometry element in the GML namespace but found \"" + this.reader.getName() + "\"");
        }
        String startingGeometryTagName = this.reader.getLocalName();
        int dimension = this.crsDimension(2);
        CoordinateReferenceSystem crs = this.crs(DefaultGeographicCRS.WGS84);
        if ("Point".equals(startingGeometryTagName)) {
            geom = this.parsePoint(dimension, crs);
        } else if ("LineString".equals(startingGeometryTagName)) {
            geom = this.parseLineString(dimension, crs);
        } else if ("Curve".equals(startingGeometryTagName)) {
            geom = this.parseCurve(dimension, crs);
        } else if ("Polygon".equals(startingGeometryTagName)) {
            geom = this.parsePolygon(dimension, crs);
        } else if ("Surface".equals(startingGeometryTagName)) {
            geom = this.parseSurface(dimension, crs);
        } else if ("MultiPoint".equals(startingGeometryTagName)) {
            geom = this.parseMultiPoint(dimension, crs);
        } else if ("MultiLineString".equals(startingGeometryTagName)) {
            geom = this.parseMultiLineString(dimension, crs);
        } else if ("MultiCurve".equals(startingGeometryTagName)) {
            geom = this.parseMultiCurve(dimension, crs);
        } else if ("MultiSurface".equals(startingGeometryTagName)) {
            geom = this.parseMultiSurface(dimension, crs);
        } else if ("MultiPolygon".equals(startingGeometryTagName)) {
            geom = this.parseMultiPolygon(dimension, crs);
        } else {
            throw new IllegalStateException("Unrecognized geometry element " + startingGeometryTagName);
        }
        this.reader.require(2, this.gmlNamespace, startingGeometryTagName);
        return geom;
    }

    private Geometry parseMultiCurve(int dimension, CoordinateReferenceSystem crs) throws IOException, NoSuchAuthorityCodeException, FactoryException, XMLStreamException {
        this.reader.require(1, this.gmlNamespace, "MultiCurve");
        ArrayList<LineString> lines = new ArrayList<LineString>(2);
        while (true) {
            this.reader.nextTag();
            if (2 == this.reader.getEventType() && "MultiCurve".equals(this.reader.getLocalName())) break;
            this.reader.require(1, this.gmlNamespace, "curveMember");
            this.reader.nextTag();
            this.reader.require(1, this.gmlNamespace, null);
            String startingGeometryTagName = this.reader.getLocalName();
            if ("LineString".equals(startingGeometryTagName)) {
                lines.add(this.parseLineString(dimension, crs));
            } else {
                if ("CompositeCurve".equals(startingGeometryTagName)) {
                    throw new UnsupportedOperationException("CompositeCurve is not supported yet");
                }
                if ("Curve".equals(startingGeometryTagName)) {
                    lines.add(this.parseCurve(dimension, crs));
                } else if ("OrientableCurve".equals(startingGeometryTagName)) {
                    throw new UnsupportedOperationException("OrientableCurve is not supported yet");
                }
            }
            this.reader.nextTag();
            this.reader.require(2, this.gmlNamespace, "curveMember");
        }
        this.reader.require(2, this.gmlNamespace, "MultiCurve");
        return this.curvedGeometryFactory.createMultiCurve(lines);
    }

    private Geometry parseMultiPoint(int dimension, CoordinateReferenceSystem crs) throws XMLStreamException, IOException, NoSuchAuthorityCodeException, FactoryException {
        this.reader.require(1, this.gmlNamespace, "MultiPoint");
        this.reader.nextTag();
        String memberTag = this.reader.getLocalName();
        ArrayList<Point> points = new ArrayList<Point>(4);
        if ("pointMembers".equals(memberTag)) {
            while (true) {
                this.reader.nextTag();
                if (2 == this.reader.getEventType() && "pointMembers".equals(this.reader.getLocalName())) break;
                Point p = this.parsePoint(dimension, crs);
                points.add(p);
            }
            this.reader.nextTag();
        } else if ("pointMember".equals(memberTag)) {
            do {
                this.reader.nextTag();
                this.reader.require(1, this.gmlNamespace, "Point");
                Point p = this.parsePoint(dimension, crs);
                points.add(p);
                this.reader.nextTag();
                this.reader.require(2, this.gmlNamespace, "pointMember");
                this.reader.nextTag();
            } while (2 != this.reader.getEventType() || !"MultiPoint".equals(this.reader.getLocalName()));
        }
        this.reader.require(2, this.gmlNamespace, "MultiPoint");
        return this.geomFac.createMultiPoint(points.toArray(new Point[0]));
    }

    private MultiLineString parseMultiLineString(int dimension, CoordinateReferenceSystem crs) throws XMLStreamException, IOException, NoSuchAuthorityCodeException, FactoryException {
        this.reader.require(1, this.gmlNamespace, "MultiLineString");
        ArrayList<LineString> lines = new ArrayList<LineString>(2);
        while (true) {
            this.reader.nextTag();
            if (2 == this.reader.getEventType() && "MultiLineString".equals(this.reader.getLocalName())) break;
            this.reader.require(1, this.gmlNamespace, "lineStringMember");
            this.reader.nextTag();
            this.reader.require(1, this.gmlNamespace, "LineString");
            LineString line = this.parseLineString(dimension, crs);
            lines.add(line);
            this.reader.nextTag();
            this.reader.require(2, this.gmlNamespace, "lineStringMember");
        }
        this.reader.require(2, this.gmlNamespace, "MultiLineString");
        return this.geomFac.createMultiLineString(lines.toArray(new LineString[0]));
    }

    private Geometry parseMultiSurface(int dimension, CoordinateReferenceSystem crs) throws XMLStreamException, IOException, NoSuchAuthorityCodeException, FactoryException {
        this.reader.require(1, this.gmlNamespace, "MultiSurface");
        this.reader.nextTag();
        String memberTag = this.reader.getLocalName();
        ArrayList<Polygon> polygons = new ArrayList<Polygon>(2);
        if ("surfaceMembers".equals(memberTag)) {
            block16: while (true) {
                this.reader.nextTag();
                if (2 == this.reader.getEventType() && "surfaceMembers".equals(this.reader.getLocalName())) break;
                switch (this.reader.getLocalName()) {
                    case "Polygon": {
                        Polygon p = this.parsePolygon(dimension, crs);
                        polygons.add(p);
                        break;
                    }
                    case "Surface": {
                        MultiPolygon mp = this.parseSurface(dimension, crs);
                        int i = 0;
                        while (true) {
                            if (i >= mp.getNumGeometries()) continue block16;
                            polygons.add((Polygon)mp.getGeometryN(i));
                            ++i;
                        }
                    }
                    default: {
                        throw new IllegalStateException("Unknown polygon boundary element: " + this.reader.getLocalName());
                    }
                }
            }
            this.reader.nextTag();
        } else if ("surfaceMember".equals(memberTag)) {
            do {
                this.reader.nextTag();
                switch (this.reader.getLocalName()) {
                    case "Polygon": {
                        Polygon p = this.parsePolygon(dimension, crs);
                        polygons.add(p);
                        break;
                    }
                    case "Surface": {
                        MultiPolygon mp = this.parseSurface(dimension, crs);
                        for (int i = 0; i < mp.getNumGeometries(); ++i) {
                            polygons.add((Polygon)mp.getGeometryN(i));
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown polygon boundary element: " + this.reader.getLocalName());
                    }
                }
                this.reader.nextTag();
                this.reader.require(2, this.gmlNamespace, "surfaceMember");
                this.reader.nextTag();
            } while (2 != this.reader.getEventType() || !"MultiSurface".equals(this.reader.getLocalName()));
        }
        this.reader.require(2, this.gmlNamespace, "MultiSurface");
        return this.curvedGeometryFactory.createMultiPolygon(polygons.toArray(new Polygon[0]));
    }

    private Geometry parseMultiPolygon(int dimension, CoordinateReferenceSystem crs) throws XMLStreamException, IOException, NoSuchAuthorityCodeException, FactoryException {
        this.reader.require(1, this.gmlNamespace, "MultiPolygon");
        ArrayList<Polygon> polygons = new ArrayList<Polygon>(2);
        this.reader.nextTag();
        do {
            this.reader.require(1, this.gmlNamespace, "polygonMember");
            this.reader.nextTag();
            this.reader.require(1, this.gmlNamespace, "Polygon");
            Polygon p = this.parsePolygon(dimension, crs);
            polygons.add(p);
            this.reader.nextTag();
            this.reader.require(2, this.gmlNamespace, "polygonMember");
            this.reader.nextTag();
        } while (2 != this.reader.getEventType() || !"MultiPolygon".equals(this.reader.getLocalName()));
        this.reader.require(2, this.gmlNamespace, "MultiPolygon");
        return this.geomFac.createMultiPolygon(polygons.toArray(new Polygon[0]));
    }

    private Polygon parsePolygon(int dimension, CoordinateReferenceSystem crs) throws XMLStreamException, IOException, NoSuchAuthorityCodeException, FactoryException {
        LinearRing shell;
        ArrayList<LinearRing> holes = null;
        this.reader.nextTag();
        this.reader.require(1, this.gmlNamespace, null);
        String name = this.reader.getLocalName();
        if ("exterior".equals(name)) {
            this.reader.nextTag();
            shell = this.parseRing(dimension, crs);
            this.reader.nextTag();
            this.reader.require(2, this.gmlNamespace, "exterior");
        } else if ("outerBoundaryIs".equals(name)) {
            this.reader.nextTag();
            this.reader.require(1, this.gmlNamespace, "LinearRing");
            shell = this.parseLinearRing(dimension, crs);
            this.reader.nextTag();
            this.reader.require(2, this.gmlNamespace, "outerBoundaryIs");
        } else {
            throw new IllegalStateException("Unknown polygon boundary element: " + name);
        }
        this.reader.nextTag();
        name = this.reader.getLocalName();
        if (1 == this.reader.getEventType() && ("interior".equals(name) || "innerBoundaryIs".equals(name))) {
            holes = new ArrayList<LinearRing>(2);
            do {
                this.reader.require(1, this.gmlNamespace, name);
                this.reader.nextTag();
                LinearRing hole = this.parseRing(dimension, crs);
                holes.add(hole);
                this.reader.nextTag();
                this.reader.require(2, this.gmlNamespace, name);
                this.reader.nextTag();
            } while (2 != this.reader.getEventType());
            this.reader.require(2, this.gmlNamespace, "Polygon");
        }
        this.reader.require(2, this.gmlNamespace, "Polygon");
        LinearRing[] holesArray = null;
        if (holes != null) {
            holesArray = holes.toArray(new LinearRing[0]);
        }
        Polygon geom = this.curvedGeometryFactory.createPolygon(shell, holesArray);
        geom.setUserData((Object)crs);
        return geom;
    }

    private MultiPolygon parseSurface(int dimension, CoordinateReferenceSystem crs) throws XMLStreamException, FactoryException, IOException {
        ArrayList<Polygon> polygons;
        block4: {
            polygons = new ArrayList<Polygon>(2);
            this.reader.nextTag();
            this.reader.require(1, this.gmlNamespace, null);
            String patchesName = this.reader.getLocalName();
            if ("patches".equals(patchesName)) {
                while (true) {
                    this.reader.nextTag();
                    if (2 == this.reader.getEventType()) {
                        if ("Surface".equals(this.reader.getLocalName())) break block4;
                        if ("patches".equals(this.reader.getLocalName())) {
                            this.reader.nextTag();
                            break block4;
                        }
                    }
                    this.reader.require(1, this.gmlNamespace, "PolygonPatch");
                    Polygon p = this.parsePolygonPatch(dimension, crs);
                    polygons.add(p);
                }
            }
            throw new IllegalStateException("Unknown polygon boundary element: " + patchesName);
        }
        this.reader.require(2, this.gmlNamespace, "Surface");
        return this.geomFac.createMultiPolygon(polygons.toArray(new Polygon[0]));
    }

    private Polygon parsePolygonPatch(int dimension, CoordinateReferenceSystem crs) throws XMLStreamException, IOException, FactoryException {
        ArrayList<LinearRing> holes = null;
        this.reader.nextTag();
        this.reader.require(1, this.gmlNamespace, null);
        String name = this.reader.getLocalName();
        if (!"exterior".equals(name)) {
            throw new IllegalStateException("Unknown polygon boundary element: " + name);
        }
        this.reader.nextTag();
        LinearRing shell = this.parseRing(dimension, crs);
        this.reader.nextTag();
        this.reader.require(2, this.gmlNamespace, "exterior");
        this.reader.nextTag();
        name = this.reader.getLocalName();
        if (1 == this.reader.getEventType() && "interior".equals(name)) {
            holes = new ArrayList<LinearRing>(2);
            do {
                this.reader.require(1, this.gmlNamespace, name);
                this.reader.nextTag();
                LinearRing hole = this.parseRing(dimension, crs);
                holes.add(hole);
                this.reader.nextTag();
                this.reader.require(2, this.gmlNamespace, name);
                this.reader.nextTag();
            } while (2 != this.reader.getEventType());
            this.reader.require(2, this.gmlNamespace, "PolygonPatch");
        }
        this.reader.require(2, this.gmlNamespace, "PolygonPatch");
        LinearRing[] holesArray = null;
        if (holes != null) {
            holesArray = holes.toArray(new LinearRing[0]);
        }
        Polygon geom = this.curvedGeometryFactory.createPolygon(shell, holesArray);
        geom.setUserData((Object)crs);
        return geom;
    }

    private LinearRing parseRing(int dimension, CoordinateReferenceSystem crs) throws XMLStreamException, IOException, NoSuchAuthorityCodeException, FactoryException {
        String name = this.reader.getLocalName();
        if ("LinearRing".equals(name)) {
            return this.parseLinearRing(dimension, crs);
        }
        this.reader.require(1, this.gmlNamespace, "Ring");
        ArrayList<LineString> components = new ArrayList<LineString>();
        this.reader.nextTag();
        do {
            this.reader.require(1, this.gmlNamespace, "curveMember");
            this.reader.nextTag();
            name = this.reader.getLocalName();
            this.reader.require(1, this.gmlNamespace, null);
            if ("LineString".equals(name)) {
                components.add(this.parseLineString(dimension, crs));
            } else {
                LineString lineString = this.parseCurve(dimension, crs);
                if (lineString instanceof CompoundCurvedGeometry) {
                    components.addAll(((CompoundCurvedGeometry)lineString).getComponents());
                } else {
                    components.add(lineString);
                }
            }
            this.reader.nextTag();
            this.reader.require(2, this.gmlNamespace, "curveMember");
            this.reader.nextTag();
        } while (2 != this.reader.getEventType() || !"Ring".equals(this.reader.getLocalName()));
        LinearRing linearRing = (LinearRing)this.curvedGeometryFactory.createCurvedGeometry(components);
        linearRing.setUserData((Object)crs);
        return linearRing;
    }

    private LinearRing parseLinearRing(int dimension, CoordinateReferenceSystem crs) throws XMLStreamException, IOException, NoSuchAuthorityCodeException, FactoryException {
        this.reader.require(1, this.gmlNamespace, "LinearRing");
        crs = this.crs(crs);
        Coordinate[] lineCoords = this.parseLineStringInternal(dimension, crs);
        this.reader.require(2, this.gmlNamespace, "LinearRing");
        LinearRing linearRing = this.geomFac.createLinearRing(lineCoords);
        linearRing.setUserData((Object)crs);
        return linearRing;
    }

    private LineString parseLineStringSegment(int dimension, CoordinateReferenceSystem crs) throws XMLStreamException, IOException, NoSuchAuthorityCodeException, FactoryException {
        return this.parseLineString(dimension, crs, true);
    }

    private LineString parseLineString(int dimension, CoordinateReferenceSystem crs) throws XMLStreamException, IOException, NoSuchAuthorityCodeException, FactoryException {
        return this.parseLineString(dimension, crs, false);
    }

    private LineString parseLineString(int dimension, CoordinateReferenceSystem crs, boolean isSegment) throws XMLStreamException, IOException, NoSuchAuthorityCodeException, FactoryException {
        String lineStringElement = isSegment ? "LineStringSegment" : "LineString";
        this.reader.require(1, this.gmlNamespace, lineStringElement);
        crs = this.crs(crs);
        Coordinate[] coordinates = this.parseLineStringInternal(dimension, crs);
        this.reader.require(2, this.gmlNamespace, lineStringElement);
        LineString geom = this.geomFac.createLineString(coordinates);
        geom.setUserData((Object)crs);
        return geom;
    }

    private Coordinate[] parseLineStringInternal(int dimension, CoordinateReferenceSystem crs) throws XMLStreamException, IOException {
        Coordinate[] lineCoords;
        String lineElementName = this.reader.getLocalName();
        this.reader.nextTag();
        String coordsName = this.reader.getLocalName();
        String tagName = this.reader.getLocalName();
        if ("pos".equals(coordsName)) {
            int eventType;
            ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
            do {
                Coordinate[] point = this.parseCoordList(dimension, crs);
                coords.add(point[0]);
                this.reader.nextTag();
                tagName = this.reader.getLocalName();
            } while ((eventType = this.reader.getEventType()) == 1 && "pos".equals(tagName));
            lineCoords = coords.toArray(new Coordinate[0]);
        } else if ("posList".equals(coordsName)) {
            lineCoords = this.parseCoordList(dimension, crs);
            this.reader.nextTag();
        } else if ("coordinates".equals(coordsName)) {
            lineCoords = this.parseCoordinates(dimension, crs);
            this.reader.nextTag();
        } else if ("coord".equals(coordsName)) {
            int eventType;
            ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
            do {
                Coordinate point = this.parseCoord();
                coords.add(point);
                this.reader.nextTag();
                tagName = this.reader.getLocalName();
            } while ((eventType = this.reader.getEventType()) == 1 && "coord".equals(tagName));
            lineCoords = coords.toArray(new Coordinate[0]);
        } else {
            throw new IllegalStateException("Expected posList or pos inside LinearRing: " + tagName);
        }
        this.reader.require(2, this.gmlNamespace, lineElementName);
        return lineCoords;
    }

    private LineString parseCurve(int dimension, CoordinateReferenceSystem crs) throws XMLStreamException, IOException, NoSuchAuthorityCodeException, FactoryException {
        this.reader.require(1, this.gmlNamespace, "Curve");
        ArrayList<LineString> lines = new ArrayList<LineString>(2);
        this.reader.nextTag();
        this.reader.require(1, this.gmlNamespace, "segments");
        this.reader.nextTag();
        do {
            this.reader.require(1, this.gmlNamespace, null);
            String name = this.reader.getLocalName();
            if ("LineStringSegment".equals(name)) {
                lines.add(this.parseLineStringSegment(dimension, crs));
            } else if ("Arc".equals(name)) {
                lines.add(this.parseArc(dimension, crs));
            } else {
                throw new UnsupportedOperationException("Curve segment " + name + " is not supported yet");
            }
            this.reader.nextTag();
        } while (2 != this.reader.getEventType() || !"segments".equals(this.reader.getLocalName()));
        this.reader.nextTag();
        this.reader.require(2, this.gmlNamespace, "Curve");
        LineString geom = this.curvedGeometryFactory.createCurvedGeometry(lines);
        geom.setUserData((Object)crs);
        return geom;
    }

    private LineString parseArc(int dimension, CoordinateReferenceSystem crs) throws XMLStreamException, IOException, NoSuchAuthorityCodeException, FactoryException {
        this.reader.require(1, this.gmlNamespace, "Arc");
        crs = this.crs(crs);
        Coordinate[] coordinates = this.parseLineStringInternal(dimension, crs);
        this.reader.require(2, this.gmlNamespace, "Arc");
        LineString geom = this.curvedGeometryFactory.createCircularString(this.curvedGeometryFactory.getCoordinateSequenceFactory().create(coordinates));
        geom.setUserData((Object)crs);
        return geom;
    }

    private Point parsePoint(int dimension, CoordinateReferenceSystem crs) throws XMLStreamException, IOException, NoSuchAuthorityCodeException, FactoryException {
        Coordinate point;
        Coordinate[] coords;
        this.reader.require(1, this.gmlNamespace, "Point");
        crs = this.crs(crs);
        this.reader.nextTag();
        this.reader.require(1, this.gmlNamespace, null);
        String name = this.reader.getLocalName();
        if ("pos".equals(name)) {
            coords = this.parseCoordList(dimension, crs);
            point = coords[0];
            this.reader.nextTag();
        } else if ("coordinates".equals(name)) {
            coords = this.parseCoordinates(dimension, crs);
            point = coords[0];
            this.reader.nextTag();
        } else if ("coord".equals(name)) {
            point = this.parseCoord();
            this.reader.nextTag();
        } else {
            throw new IllegalStateException("Unknown coordinate element for Point: " + name);
        }
        this.reader.require(2, this.gmlNamespace, "Point");
        Point geom = this.geomFac.createPoint(point);
        geom.setUserData((Object)crs);
        return geom;
    }

    private Coordinate parseCoord() throws XMLStreamException, IOException {
        this.reader.require(1, this.gmlNamespace, "coord");
        double z = 0.0;
        this.reader.nextTag();
        this.reader.require(1, this.gmlNamespace, "X");
        double x = Double.parseDouble(this.reader.getElementText());
        this.reader.nextTag();
        this.reader.require(1, this.gmlNamespace, "Y");
        double y = Double.parseDouble(this.reader.getElementText());
        this.reader.nextTag();
        if (1 == this.reader.getEventType()) {
            this.reader.require(1, this.gmlNamespace, "Z");
            z = Double.parseDouble(this.reader.getElementText());
            this.reader.nextTag();
        }
        this.reader.require(2, this.gmlNamespace, "coord");
        return new Coordinate(x, y, z);
    }

    private CoordinateReferenceSystem crs(CoordinateReferenceSystem defaultValue) throws NoSuchAuthorityCodeException, FactoryException {
        String srsName = this.reader.getAttributeValue(null, "srsName");
        if (srsName == null) {
            return defaultValue;
        }
        if (srsName.startsWith("http://") && srsName.indexOf(35) != -1) {
            srsName = "EPSG:" + srsName.substring(1 + srsName.lastIndexOf(35));
        }
        return CRS.decode(srsName);
    }

    private int crsDimension(int defaultValue) {
        String srsDimension = this.reader.getAttributeValue(null, "srsDimension");
        if (srsDimension == null) {
            return defaultValue;
        }
        return Integer.parseInt(srsDimension);
    }

    private Coordinate[] parseCoordList(int dimension, CoordinateReferenceSystem crs) throws XMLStreamException, IOException {
        dimension = this.crsDimension(dimension);
        String rawTextValue = this.reader.getElementText();
        return this.toCoordList(rawTextValue, dimension, crs);
    }

    private Coordinate[] parseCoordinates(int dimension, CoordinateReferenceSystem crs) throws XMLStreamException, IOException {
        String tupleSeparator;
        String coordSeparator;
        this.reader.require(1, this.gmlNamespace, "coordinates");
        dimension = this.crsDimension(dimension);
        String decimalSeparator = this.reader.getAttributeValue("", "decimal");
        if (decimalSeparator == null) {
            decimalSeparator = ".";
        }
        if ((coordSeparator = this.reader.getAttributeValue("", "cs")) == null) {
            coordSeparator = ",";
        }
        if ((tupleSeparator = this.reader.getAttributeValue("", "ts")) == null) {
            tupleSeparator = " ";
        }
        String rawTextValue = this.reader.getElementText();
        Coordinate[] coords = this.toCoordList(rawTextValue, decimalSeparator, coordSeparator, tupleSeparator, dimension, crs);
        this.reader.require(2, this.gmlNamespace, "coordinates");
        return coords;
    }

    private boolean checkInvertAxisNeededCache(CoordinateReferenceSystem crs) {
        if (this.invertAxisNeeded == null) {
            return false;
        }
        Boolean invert = this.invertAxisNeededCache.get(crs);
        if (invert == null) {
            invert = this.invertAxisNeeded.test(crs);
            this.invertAxisNeededCache.put(crs, invert);
        }
        return invert;
    }

    private Coordinate[] toCoordList(String rawTextValue, int dimension, CoordinateReferenceSystem crs) {
        rawTextValue = rawTextValue.trim();
        rawTextValue = rawTextValue.replaceAll("\n", " ");
        String[] split = (rawTextValue = rawTextValue.replaceAll("\r", " ")).trim().split(" +");
        int ordinatesLength = split.length;
        if (ordinatesLength % dimension != 0) {
            throw new IllegalArgumentException("Number of ordinates (" + ordinatesLength + ") does not match crs dimension: " + dimension);
        }
        boolean invertXY = this.checkInvertAxisNeededCache(crs);
        int nCoords = ordinatesLength / dimension;
        Coordinate[] coords = new Coordinate[nCoords];
        int currCoordIdx = 0;
        for (int i = 0; i < ordinatesLength; i += dimension) {
            Coordinate coord;
            double x = Double.parseDouble(split[i]);
            double y = Double.parseDouble(split[i + 1]);
            if (dimension > 2) {
                double z = Double.parseDouble(split[i + 2]);
                coord = invertXY ? new Coordinate(y, x, z) : new Coordinate(x, y, z);
            } else {
                coord = invertXY ? new Coordinate(y, x) : new Coordinate(x, y);
            }
            coords[currCoordIdx] = coord;
            ++currCoordIdx;
        }
        return coords;
    }

    private Coordinate[] toCoordList(String rawTextValue, String decimalSeparator, String coordSeparator, String tupleSeparator, int dimension, CoordinateReferenceSystem crs) {
        rawTextValue = rawTextValue.replaceAll("[\n\r]", " ").trim();
        String[] tuples = rawTextValue.split("\\" + tupleSeparator + "+");
        int nCoords = tuples.length;
        Coordinate[] coords = new Coordinate[nCoords];
        boolean invertXY = this.checkInvertAxisNeededCache(crs);
        for (int i = 0; i < nCoords; ++i) {
            Coordinate coord;
            String tuple = tuples[i];
            String[] oridnates = tuple.split("\\" + coordSeparator + "+");
            double[] parsedOrdinates = new double[oridnates.length];
            for (int o = 0; o < oridnates.length; ++o) {
                String ordinate = oridnates[o];
                if (!".".equals(decimalSeparator)) {
                    String[] split = ordinate.split("\\" + decimalSeparator);
                    ordinate = split[0] + '.' + split[1];
                }
                parsedOrdinates[o] = Double.parseDouble(ordinate);
            }
            double x = parsedOrdinates[0];
            double y = parsedOrdinates[1];
            if (dimension > 2 && parsedOrdinates.length > 2) {
                double z = parsedOrdinates[2];
                coord = invertXY ? new Coordinate(y, x, z) : new Coordinate(x, y, z);
            } else {
                coord = invertXY ? new Coordinate(y, x) : new Coordinate(x, y);
            }
            coords[i] = coord;
        }
        return coords;
    }
}

