/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.map;

import bak.pcj.IntCollection;
import bak.pcj.hash.DefaultCharHashFunction;
import bak.pcj.hash.DefaultIntHashFunction;
import bak.pcj.map.CharKeyIntMap;
import bak.pcj.map.CharKeyIntMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.CharSet;
import bak.pcj.util.Exceptions;

public abstract class AbstractCharKeyIntMap
implements CharKeyIntMap {
    protected AbstractCharKeyIntMap() {
    }

    public void clear() {
        CharKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public int remove(char key) {
        CharKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            int value = i.getValue();
            i.remove();
            return value;
        }
        return MapDefaults.defaultInt();
    }

    public void putAll(CharKeyIntMap map) {
        CharKeyIntMapIterator i = map.entries();
        while (i.hasNext()) {
            i.next();
            this.put(i.getKey(), i.getValue());
        }
    }

    public boolean containsKey(char key) {
        CharKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return true;
        }
        return false;
    }

    public int get(char key) {
        CharKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return i.getValue();
        }
        return MapDefaults.defaultInt();
    }

    public boolean containsValue(int value) {
        CharKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getValue() != value) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CharKeyIntMap)) {
            return false;
        }
        CharKeyIntMap map = (CharKeyIntMap)obj;
        if (this.size() != map.size()) {
            return false;
        }
        CharKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            char k = i.getKey();
            if (map.containsKey(k) && map.lget() == i.getValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        CharKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            h += DefaultCharHashFunction.INSTANCE.hash(i.getKey()) ^ DefaultIntHashFunction.INSTANCE.hash(i.getValue());
        }
        return h;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        int size = 0;
        CharKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            ++size;
        }
        return size;
    }

    public int tget(char key) {
        int value = this.get(key);
        if (value == MapDefaults.defaultInt() && !this.containsKey(key)) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        CharKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            if (s.length() > 1) {
                s.append(',');
            }
            i.next();
            s.append(String.valueOf(i.getKey()));
            s.append("->");
            s.append(String.valueOf(i.getValue()));
        }
        s.append(']');
        return s.toString();
    }

    public void trimToSize() {
    }

    public abstract IntCollection values();

    public abstract int put(char var1, int var2);

    public abstract int lget();

    public abstract CharSet keySet();

    public abstract CharKeyIntMapIterator entries();
}

