/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.AbstractByteCollection;
import bak.pcj.Adapter;
import bak.pcj.ByteIterator;
import bak.pcj.adapter.IteratorToByteIteratorAdapter;
import bak.pcj.util.Exceptions;
import java.util.Collection;

public class CollectionToByteCollectionAdapter
extends AbstractByteCollection {
    protected Collection collection;

    public CollectionToByteCollectionAdapter(Collection collection) {
        this(collection, false);
    }

    public CollectionToByteCollectionAdapter(Collection collection, boolean validate) {
        if (collection == null) {
            Exceptions.nullArgument("collection");
        }
        this.collection = collection;
        if (validate) {
            this.evalidate();
        }
    }

    public boolean add(byte v) {
        return this.collection.add(new Byte(v));
    }

    public void clear() {
        this.collection.clear();
    }

    public boolean contains(byte v) {
        return this.collection.contains(new Byte(v));
    }

    public int hashCode() {
        return this.collection.hashCode();
    }

    public ByteIterator iterator() {
        return new IteratorToByteIteratorAdapter(this.collection.iterator());
    }

    public boolean remove(byte v) {
        return this.collection.remove(new Byte(v));
    }

    public int size() {
        return this.collection.size();
    }

    public boolean validate() {
        return Adapter.isByteAdaptable(this.collection);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("collection");
        }
    }
}

