/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.upgrades;

import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.upgrades.FeatureMigrationResults;
import org.elasticsearch.upgrades.SingleFeatureMigrationResult;

public class MigrationResultsUpdateTask
extends ClusterStateUpdateTask {
    private static final Logger logger = LogManager.getLogger(MigrationResultsUpdateTask.class);
    private final String featureName;
    private final SingleFeatureMigrationResult status;
    private final ActionListener<ClusterState> listener;

    private MigrationResultsUpdateTask(String featureName, SingleFeatureMigrationResult status, ActionListener<ClusterState> listener) {
        this.featureName = featureName;
        this.status = status;
        this.listener = listener;
    }

    public static MigrationResultsUpdateTask upsert(String featureName, SingleFeatureMigrationResult status, ActionListener<ClusterState> listener) {
        return new MigrationResultsUpdateTask(featureName, status, listener);
    }

    public void submit(ClusterService clusterService) {
        String source = new ParameterizedMessage("record [{}] migration [{}]", (Object)this.featureName, (Object)(this.status.succeeded() ? "success" : "failure")).getFormattedMessage();
        clusterService.submitStateUpdateTask(source, this);
    }

    @Override
    public ClusterState execute(ClusterState currentState) throws Exception {
        FeatureMigrationResults currentResults = (FeatureMigrationResults)currentState.metadata().custom("system_index_migration");
        if (currentResults == null) {
            currentResults = new FeatureMigrationResults(new HashMap<String, SingleFeatureMigrationResult>());
        }
        FeatureMigrationResults newResults = currentResults.withResult(this.featureName, this.status);
        Metadata newMetadata = Metadata.builder(currentState.metadata()).putCustom("system_index_migration", newResults).build();
        ClusterState newState = ClusterState.builder(currentState).metadata(newMetadata).build();
        return newState;
    }

    @Override
    public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
        this.listener.onResponse(newState);
    }

    @Override
    public void onFailure(String source, Exception clusterStateUpdateException) {
        if (this.status.succeeded()) {
            logger.warn((Message)new ParameterizedMessage("failed to update cluster state after successful migration of feature [{}]", (Object)this.featureName), (Throwable)clusterStateUpdateException);
        } else {
            logger.error(new ParameterizedMessage("failed to update cluster state after failed migration of feature [{}] on index [{}]", (Object)this.featureName, (Object)this.status.getFailedIndexName()).getFormattedMessage(), (Throwable)clusterStateUpdateException);
        }
        this.listener.onFailure(clusterStateUpdateException);
    }
}

