/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.syntax;

import java.util.Objects;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Node_Triple;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementVisitor;
import org.apache.jena.sparql.util.NodeIsomorphismMap;

public class ElementFind
extends Element {
    private final Var var;
    private final Triple triple;

    public ElementFind(Var v, Node node) {
        Objects.requireNonNull(node);
        if (!node.isNodeTriple()) {
            throw new ARQException("Not a triple term: " + node);
        }
        this.var = v;
        this.triple = Node_Triple.triple((Node)node);
    }

    public ElementFind(Var v, Triple triple) {
        this.var = Objects.requireNonNull(v);
        this.triple = Objects.requireNonNull(triple);
    }

    public Var getVar() {
        return this.var;
    }

    public Triple getTriple() {
        return this.triple;
    }

    @Override
    public boolean equalTo(Element el2, NodeIsomorphismMap isoMap) {
        if (!(el2 instanceof ElementFind)) {
            return false;
        }
        ElementFind f2 = (ElementFind)el2;
        if (!this.getVar().equals((Object)f2.getVar())) {
            return false;
        }
        return this.getTriple().equals((Object)f2.getTriple());
    }

    @Override
    public int hashCode() {
        return this.var.hashCode() ^ this.triple.hashCode();
    }

    @Override
    public void visit(ElementVisitor v) {
        v.visit(this);
    }
}

