/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.listener.metadata.draft;

import java.util.List;
import org.fao.geonet.domain.MetadataDraft;
import org.fao.geonet.events.md.MetadataRemove;
import org.fao.geonet.listener.metadata.draft.DraftUtilities;
import org.fao.geonet.repository.MetadataDraftRepository;
import org.fao.geonet.repository.specification.MetadataSpecs;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.event.TransactionalEventListener;

@Component
public class DraftCleanup {
    @Autowired
    private MetadataDraftRepository metadataDraftRepository;
    @Autowired
    private DraftUtilities draftUtilities;

    @TransactionalEventListener
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void doAfterCommit(MetadataRemove event) {
        Log.trace((String)"geonetwork.datamanager", (Object)("A metadata has been removed. Cleanup associated drafts of " + event.getSource()));
        try {
            List toRemove = this.metadataDraftRepository.findAll(MetadataSpecs.hasMetadataUuid((String)event.getMd().getUuid()));
            for (MetadataDraft md : toRemove) {
                this.draftUtilities.removeDraft(md);
            }
        }
        catch (Throwable e) {
            Log.error((String)"geonetwork.datamanager", (String)("Couldn't clean up associated drafts of " + event.getSource()), (Throwable)e);
        }
        Log.trace((String)"geonetwork.datamanager", (Object)("Finished cleaning up of " + event.getSource()));
    }
}

