/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.reports;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import jeeves.server.context.ServiceContext;
import org.apache.commons.csv.CSVPrinter;
import org.fao.geonet.api.reports.IReport;
import org.fao.geonet.api.reports.ReportFilter;
import org.fao.geonet.api.reports.ReportUtils;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.domain.User;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.repository.specification.OperationAllowedSpecs;

public class ReportInternalMetadata
implements IReport {
    private final ReportFilter reportFilter;

    public ReportInternalMetadata(ReportFilter filter) {
        this.reportFilter = filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(ServiceContext context, PrintWriter writer) throws Exception {
        CSVPrinter csvFilePrinter = null;
        try {
            csvFilePrinter = new CSVPrinter((Appendable)writer, ReportUtils.CSV_FORMAT);
            IMetadataUtils metadataRepository = (IMetadataUtils)context.getBean(IMetadataUtils.class);
            List records = metadataRepository.getMetadataReports().getInternalMetadata(this.reportFilter.getBeginDate(), this.reportFilter.getEndDate(), this.reportFilter.getGroups(), OperationAllowedSpecs.isPublic((ReservedOperation)ReservedOperation.view));
            csvFilePrinter.printRecord(new Object[]{"Metadata Internal"});
            csvFilePrinter.println();
            String[] entries = "Metadata ID#Metadata Title#Metadata Create date#Metadata Update date#Owner Username#Owner Surname#Owner Name#Owner Email#Group Owner#Group Owner Email".split("#");
            csvFilePrinter.printRecord(Arrays.asList(entries));
            List users = ((UserRepository)context.getBean(UserRepository.class)).findAll();
            List groups = ((GroupRepository)context.getBean(GroupRepository.class)).findAll();
            for (AbstractMetadata metadata : records) {
                Optional<Group> groupOwnerFilter;
                Integer mdGroupOwner;
                Optional<User> userOwnerFilter;
                String userOwnerUsername = "";
                String userOwnerName = "";
                String userOwnerSurname = "";
                String userOwnerMail = "";
                String groupOwnerName = "";
                String groupOwnerMail = "";
                Integer mdUserOwner = metadata.getSourceInfo().getOwner();
                if (mdUserOwner != null && (userOwnerFilter = users.stream().filter(u -> u.getId() == mdUserOwner.intValue()).findFirst()).isPresent()) {
                    User userOwner = userOwnerFilter.get();
                    userOwnerUsername = Optional.ofNullable(userOwner.getUsername()).orElse("");
                    userOwnerName = Optional.ofNullable(userOwner.getName()).orElse("");
                    userOwnerSurname = Optional.ofNullable(userOwner.getSurname()).orElse("");
                    userOwnerMail = Optional.ofNullable(userOwner.getEmail()).orElse("");
                }
                if ((mdGroupOwner = metadata.getSourceInfo().getGroupOwner()) != null && (groupOwnerFilter = groups.stream().filter(g -> g.getId() == mdGroupOwner.intValue()).findFirst()).isPresent()) {
                    Group groupOwner = groupOwnerFilter.get();
                    String groupNameTranslation = (String)groupOwner.getLabelTranslations().get(context.getLanguage());
                    groupOwnerName = Optional.ofNullable(groupNameTranslation).orElse(groupOwner.getName());
                    groupOwnerMail = Optional.ofNullable(groupOwner.getEmail()).orElse("");
                }
                String mdTitle = ReportUtils.retrieveMetadataIndex(metadata.getUuid(), "resourceTitleObject", "default");
                ArrayList<String> record = new ArrayList<String>();
                record.add(metadata.getUuid());
                record.add("" + mdTitle);
                record.add("" + metadata.getDataInfo().getCreateDate());
                record.add("" + metadata.getDataInfo().getChangeDate());
                record.add(userOwnerUsername);
                record.add(userOwnerSurname);
                record.add(userOwnerName);
                record.add(userOwnerMail);
                record.add(groupOwnerName);
                record.add(groupOwnerMail);
                csvFilePrinter.printRecord(record);
            }
        }
        finally {
            writer.flush();
            if (csvFilePrinter != null) {
                csvFilePrinter.flush();
            }
        }
    }
}

