/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records;

import com.google.common.collect.Sets;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import jeeves.services.ReadWriteController;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.processing.report.MetadataProcessingReport;
import org.fao.geonet.api.processing.report.SimpleMetadataProcessingReport;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataCategory;
import org.fao.geonet.domain.MetadataDraft;
import org.fao.geonet.domain.utils.ObjectJSONUtils;
import org.fao.geonet.events.history.RecordCategoryChangeEvent;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.search.EsSearchManager;
import org.fao.geonet.repository.MetadataCategoryRepository;
import org.fao.geonet.repository.MetadataRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/records"})
@Tag(name="records", description="Metadata record operations")
@Controller(value="tagRecords")
@ReadWriteController
public class MetadataTagApi {
    public static final String API_PARAM_TAG_IDENTIFIER = "Tag identifier";
    @Autowired
    MetadataCategoryRepository categoryRepository;
    @Autowired
    DataManager dataManager;
    @Autowired
    EsSearchManager searchManager;
    @Autowired
    IMetadataManager metadataManager;
    @Autowired
    MetadataRepository metadataRepository;
    @Autowired
    AccessManager accessMan;

    @Operation(summary="Get record tags", description="Tags are used to classify information.<br/><a href='https://docs.geonetwork-opensource.org/latest/user-guide/tag-information/tagging-with-categories/'>More info</a>")
    @GetMapping(value={"/{metadataUuid}/tags"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Record tags."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to view the resource.")})
    @ResponseBody
    public Set<MetadataCategory> getRecordTags(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata = ApiUtils.canViewRecord(metadataUuid, request);
        return metadata.getCategories();
    }

    @Operation(summary="Add tags to a record", description="")
    @PutMapping(value={"/{metadataUuid}/tags"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Record tags added."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseBody
    public void tagRecord(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Tag identifier", required=true) @RequestParam Integer[] id, @Parameter(description="Clear all before adding new ones", required=false) @RequestParam(defaultValue="false", required=false) boolean clear, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        Set before = metadata.getCategories();
        if (clear) {
            this.metadataManager.update(metadata.getId(), entity -> entity.getCategories().clear());
        }
        Integer[] integerArray = id;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int c = integerArray[i];
            Optional category = this.categoryRepository.findById((Object)c);
            if (!category.isPresent()) {
                throw new ResourceNotFoundException(String.format("Can't assign non existing category with id '%d' to record '%s'", c, metadataUuid));
            }
            this.dataManager.setCategory(ApiUtils.createServiceContext(request), String.valueOf(metadata.getId()), String.valueOf(c));
        }
        this.indexTags(metadata);
        metadata = ApiUtils.canEditRecord(metadataUuid, request);
        Set after = metadata.getCategories();
        UserSession userSession = ApiUtils.getUserSession(request.getSession());
        new RecordCategoryChangeEvent(Integer.valueOf(metadata.getId()), Integer.valueOf(userSession.getUserIdAsInt()), ObjectJSONUtils.convertObjectInJsonObject((Object)before, (String)"category"), ObjectJSONUtils.convertObjectInJsonObject((Object)after, (String)"category")).publish((ApplicationContext)appContext);
    }

    private void indexTags(AbstractMetadata metadata) throws Exception {
        HashMap fields = new HashMap();
        if (!metadata.getCategories().isEmpty()) {
            ArrayList<String> categories = new ArrayList<String>();
            for (MetadataCategory category : metadata.getCategories()) {
                categories.add(category.getName());
            }
            fields.put("cat", categories);
        }
        if (metadata instanceof MetadataDraft) {
            this.searchManager.updateFields(metadata.getUuid() + "-draft", fields, (Set)Sets.newHashSet((Object[])new String[]{"cat"}));
        } else {
            this.searchManager.updateFields(metadata.getUuid(), fields, (Set)Sets.newHashSet((Object[])new String[]{"cat"}));
        }
    }

    @Operation(summary="Delete tags of a record", description="")
    @DeleteMapping(value={"/{metadataUuid}/tags"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Record tags removed."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseBody
    public void deleteTags(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Tag identifier. If none, all tags are removed.", required=false) @RequestParam(required=false) Integer[] id, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        Set before = metadata.getCategories();
        if (id == null || id.length == 0) {
            this.metadataManager.update(metadata.getId(), entity -> entity.getCategories().clear());
        }
        if (id != null) {
            Integer[] integerArray = id;
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int c = integerArray[i];
                this.dataManager.unsetCategory(ApiUtils.createServiceContext(request), String.valueOf(metadata.getId()), c);
            }
        }
        this.indexTags(metadata);
        metadata = ApiUtils.canEditRecord(metadataUuid, request);
        Set after = metadata.getCategories();
        UserSession userSession = ApiUtils.getUserSession(request.getSession());
        new RecordCategoryChangeEvent(Integer.valueOf(metadata.getId()), Integer.valueOf(userSession.getUserIdAsInt()), ObjectJSONUtils.convertObjectInJsonObject((Object)before, (String)"category"), ObjectJSONUtils.convertObjectInJsonObject((Object)after, (String)"category")).publish((ApplicationContext)appContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="Add or remove tags to one or more records", description="")
    @PutMapping(value={"/tags"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Report about updated records."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Editors can access it.")})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseBody
    public MetadataProcessingReport tagRecords(@Parameter(description="Record UUIDs. If null current selection is used.", required=false) @RequestParam(required=false) String[] uuids, @Parameter(description="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @Parameter(description="Tag identifier", required=false) @RequestParam(required=false) Integer[] id, @Parameter(description="Tag identifier to remove.", required=false) @RequestParam(required=false) Integer[] removeId, @Parameter(description="Clear all before adding new ones", required=false) @RequestParam(defaultValue="false", required=false) boolean clear, HttpServletRequest request, @Parameter(hidden=true) HttpSession session) throws Exception {
        try (SimpleMetadataProcessingReport report = new SimpleMetadataProcessingReport();){
            Set<String> records = ApiUtils.getUuidsParameterOrSelection(uuids, bucket, ApiUtils.getUserSession(session));
            report.setTotalRecords(records.size());
            ConfigurableApplicationContext context = ApplicationContextHolder.get();
            ArrayList<String> listOfUpdatedRecords = new ArrayList<String>();
            for (String uuid : records) {
                Metadata info = this.metadataRepository.findOneByUuid(uuid);
                Set before = info.getCategories();
                if (info == null) {
                    report.incrementNullRecords();
                } else if (!this.accessMan.canEdit(ApiUtils.createServiceContext(request), String.valueOf(info.getId()))) {
                    report.addNotEditableMetadataId(info.getId());
                } else {
                    Optional category;
                    int c;
                    int n;
                    int n2;
                    Integer[] integerArray;
                    if (clear) {
                        info.getCategories().clear();
                    }
                    if (id != null) {
                        integerArray = id;
                        n2 = integerArray.length;
                        for (n = 0; n < n2; ++n) {
                            c = integerArray[n];
                            category = this.categoryRepository.findById((Object)c);
                            if (category.isPresent()) {
                                info.getCategories().add(category.get());
                                listOfUpdatedRecords.add(String.valueOf(info.getId()));
                                continue;
                            }
                            report.addMetadataInfos((AbstractMetadata)info, String.format("Can't assign non existing category with id '%d' to record '%s'", c, info.getUuid()));
                        }
                    }
                    if (removeId != null) {
                        integerArray = removeId;
                        n2 = integerArray.length;
                        for (n = 0; n < n2; ++n) {
                            c = integerArray[n];
                            category = this.categoryRepository.findById((Object)c);
                            if (category.isPresent()) {
                                info.getCategories().remove(category.get());
                                listOfUpdatedRecords.add(String.valueOf(info.getId()));
                                continue;
                            }
                            report.addMetadataInfos((AbstractMetadata)info, String.format("Can't remove non existing category with id '%d' to record '%s'", c, info.getUuid()));
                        }
                        this.metadataManager.save((AbstractMetadata)info);
                        report.incrementProcessedRecords();
                    }
                }
                info = this.metadataRepository.findOneByUuid(uuid);
                Set after = info.getCategories();
                this.indexTags((AbstractMetadata)info);
                UserSession userSession = ApiUtils.getUserSession(request.getSession());
                new RecordCategoryChangeEvent(Integer.valueOf(info.getId()), Integer.valueOf(userSession.getUserIdAsInt()), ObjectJSONUtils.convertObjectInJsonObject((Object)before, (String)"category"), ObjectJSONUtils.convertObjectInJsonObject((Object)after, (String)"category")).publish((ApplicationContext)context);
            }
            this.dataManager.flush();
        }
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="Delete tags to one or more records", description="")
    @DeleteMapping(value={"/tags"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Report about removed records."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Editors can access it.")})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseBody
    public MetadataProcessingReport deleteTagForRecords(@Parameter(description="Record UUIDs. If null current selection is used.", required=false) @RequestParam(required=false) String[] uuids, @Parameter(description="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @Parameter(description="Tag identifier") @RequestParam Integer[] id, HttpServletRequest request, @Parameter(hidden=true) HttpSession session) throws Exception {
        try (SimpleMetadataProcessingReport report = new SimpleMetadataProcessingReport();){
            Set<String> records = ApiUtils.getUuidsParameterOrSelection(uuids, bucket, ApiUtils.getUserSession(session));
            report.setTotalRecords(records.size());
            ConfigurableApplicationContext context = ApplicationContextHolder.get();
            for (String uuid : records) {
                Metadata info = this.metadataRepository.findOneByUuid(uuid);
                Set before = info.getCategories();
                if (info == null) {
                    report.incrementNullRecords();
                } else if (!this.accessMan.canEdit(ApiUtils.createServiceContext(request), String.valueOf(info.getId()))) {
                    report.addNotEditableMetadataId(info.getId());
                } else {
                    info.getCategories().clear();
                    this.metadataManager.save((AbstractMetadata)info);
                    report.incrementProcessedRecords();
                }
                info = this.metadataRepository.findOneByUuid(uuid);
                Set after = info.getCategories();
                this.indexTags((AbstractMetadata)info);
                UserSession userSession = ApiUtils.getUserSession(request.getSession());
                new RecordCategoryChangeEvent(Integer.valueOf(info.getId()), Integer.valueOf(userSession.getUserIdAsInt()), ObjectJSONUtils.convertObjectInJsonObject((Object)before, (String)"category"), ObjectJSONUtils.convertObjectInJsonObject((Object)after, (String)"category")).publish((ApplicationContext)context);
            }
            this.dataManager.flush();
        }
        return report;
    }
}

