/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jeeves.server.context.ServiceContext;
import jeeves.services.ReadWriteController;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.NotAllowedException;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.records.MetadataUtils;
import org.fao.geonet.api.records.model.related.FCRelatedMetadataItem;
import org.fao.geonet.api.records.model.related.FeatureResponse;
import org.fao.geonet.api.records.model.related.IListOnlyClassToArray;
import org.fao.geonet.api.records.model.related.RelatedItemType;
import org.fao.geonet.api.records.model.related.RelatedResponse;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.MetadataDraft;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.mef.MEFLib;
import org.fao.geonet.kernel.search.EsSearchManager;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Attribute;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/records"})
@Tag(name="records", description="Metadata record operations")
@Controller(value="records")
@ReadWriteController
public class MetadataApi {
    @Autowired
    SchemaManager schemaManager;
    @Autowired
    LanguageUtils languageUtils;
    @Autowired
    DataManager dataManager;
    @Autowired
    MetadataRepository metadataRepository;
    @Autowired
    IMetadataUtils metadataUtils;
    @Autowired
    GeonetworkDataDirectory dataDirectory;
    private ApplicationContext context;
    @Autowired
    EsSearchManager esSearchManager;

    public static RelatedResponse getRelatedResources(String language, ServiceContext context, AbstractMetadata md, RelatedItemType[] type, int start, int rows) throws Exception {
        Element raw = new Element("root").addContent(Arrays.asList(new Element("gui").addContent(Arrays.asList(new Element("language").setText(language), new Element("url").setText(context.getBaseUrl()))), MetadataUtils.getRelated(context, md.getId(), md.getUuid(), type, start, start + rows)));
        Path relatedXsl = ((GeonetworkDataDirectory)ApplicationContextHolder.get().getBean(GeonetworkDataDirectory.class)).getWebappDir().resolve("xslt/services/metadata/relation.xsl");
        Element transform = Xml.transform((Element)raw, (Path)relatedXsl);
        RelatedResponse response = (RelatedResponse)Xml.unmarshall((Element)transform, RelatedResponse.class);
        return response;
    }

    public synchronized void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }

    @Operation(summary="Get a metadata record", description="Accept header should indicate which is the appropriate format to return. It could be text/html, application/xml, application/zip, ...If no appropriate Accept header found, the XML format is returned.Depending on the accept header the appropriate formatter is used. When requesting a ZIP, a MEF version 2 file is returned. When requesting HTML, the default formatter is used.")
    @RequestMapping(value={"/{metadataUuid:.+}"}, method={RequestMethod.GET}, produces={"text/html", "application/xml", "application/xhtml+xml", "application/json", "application/pdf", "application/zip", "application/x-gn-mef-1-zip", "application/x-gn-mef-2-zip", "*/*"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Return the record.", content={@Content(schema=@Schema(type="string", format="binary"))}), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to view the resource.", content={@Content(mediaType="application/json", schema=@Schema(type="string")), @Content(mediaType="application/xml", schema=@Schema(type="string")), @Content(mediaType="application/xhtml+xml", schema=@Schema(type="string"))}), @ApiResponse(responseCode="404", description="Resource not found.", content={@Content(mediaType="application/json", schema=@Schema(type="string")), @Content(mediaType="application/xml", schema=@Schema(type="string")), @Content(mediaType="application/xhtml+xml", schema=@Schema(type="string"))})})
    public String getRecord(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, HttpServletResponse response, HttpServletRequest request) throws Exception {
        try {
            ApiUtils.canViewRecord(metadataUuid, request);
        }
        catch (SecurityException e) {
            Log.debug((String)"geonetwork.api", (String)e.getMessage(), (Throwable)e);
            throw new NotAllowedException("Operation not allowed. User needs to be able to view the resource.");
        }
        String acceptHeader = StringUtils.isBlank((String)request.getHeader("Accept")) ? "application/xml" : request.getHeader("Accept");
        List<String> accept = Arrays.asList(acceptHeader.split(","));
        String defaultFormatter = "xsl-view";
        if (accept.contains("text/html") || accept.contains("application/xhtml+xml") || accept.contains("application/pdf")) {
            return "forward:" + metadataUuid + "/formatters/" + defaultFormatter;
        }
        if (accept.contains("application/xml")) {
            return "forward:" + metadataUuid + "/formatters/xml";
        }
        if (accept.contains("application/json")) {
            return "forward:" + metadataUuid + "/formatters/json";
        }
        if (accept.contains("application/zip") || accept.contains("application/x-gn-mef-1-zip") || accept.contains("application/x-gn-mef-2-zip")) {
            return "forward:" + metadataUuid + "/formatters/zip";
        }
        response.setHeader("Accept", "application/xhtml+xml");
        return "forward:" + metadataUuid + "/formatters/" + defaultFormatter;
    }

    @Operation(summary="Get metadata record permalink", description="Permalink is by default the landing page formatter but can be configured in the admin console > settings. If the record as a DOI and if enabled in the settings, then it takes priority.")
    @GetMapping(value={"/{metadataUuid:.+}/permalink"}, consumes={"*/*"}, produces={"text/plain"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Return the permalink URL."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to view the resource."), @ApiResponse(responseCode="404", description="Resource not found.")})
    public ResponseEntity<String> getRecordPermalink(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, HttpServletResponse response, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata;
        try {
            metadata = ApiUtils.canViewRecord(metadataUuid, request);
        }
        catch (SecurityException e) {
            Log.debug((String)"geonetwork.api", (String)e.getMessage(), (Throwable)e);
            throw new NotAllowedException("Operation not allowed. User needs to be able to view the resource.");
        }
        String language = this.languageUtils.getIso3langCode(request.getLocales());
        return new ResponseEntity((Object)this.metadataUtils.getPermalink(metadata.getUuid(), language), HttpStatus.OK);
    }

    @Operation(summary="Get a metadata record as JSON")
    @RequestMapping(value={"/{metadataUuid}/formatters/json"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Return the record.", content={@Content(schema=@Schema(type="string", format="binary"))}), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to view the resource.")})
    @ResponseBody
    public Object getRecordAsJson(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Add XSD schema location based on standard configuration (see schema-ident.xml).", required=false) @RequestParam(required=false, defaultValue="true") boolean addSchemaLocation, @Parameter(description="Increase record popularity", required=false) @RequestParam(required=false, defaultValue="true") boolean increasePopularity, @Parameter(description="Add geonet:info details", required=false) @RequestParam(required=false, defaultValue="false") boolean withInfo, @Parameter(description="Download as a file", required=false) @RequestParam(required=false, defaultValue="false") boolean attachment, @Parameter(description="Download the approved version", required=false) @RequestParam(required=false, defaultValue="true") boolean approved, HttpServletResponse response, HttpServletRequest request) throws Exception {
        return this.getRecordAs(metadataUuid, addSchemaLocation, increasePopularity, withInfo, attachment, approved, response, request, MediaType.APPLICATION_JSON);
    }

    @Operation(summary="Get a metadata record as XML")
    @RequestMapping(value={"/{metadataUuid}/formatters/xml"}, method={RequestMethod.GET}, produces={"application/xml"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Return the record.", content={@Content(schema=@Schema(type="string", format="binary"))}), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to view the resource.")})
    @ResponseBody
    public Object getRecordAsXml(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Add XSD schema location based on standard configuration (see schema-ident.xml).", required=false) @RequestParam(required=false, defaultValue="true") boolean addSchemaLocation, @Parameter(description="Increase record popularity", required=false) @RequestParam(required=false, defaultValue="true") boolean increasePopularity, @Parameter(description="Add geonet:info details", required=false) @RequestParam(required=false, defaultValue="false") boolean withInfo, @Parameter(description="Download as a file", required=false) @RequestParam(required=false, defaultValue="false") boolean attachment, @Parameter(description="Download the approved version", required=false) @RequestParam(required=false, defaultValue="true") boolean approved, HttpServletResponse response, HttpServletRequest request) throws Exception {
        return this.getRecordAs(metadataUuid, addSchemaLocation, increasePopularity, withInfo, attachment, approved, response, request, MediaType.APPLICATION_XML);
    }

    private Object getRecordAs(String metadataUuid, boolean addSchemaLocation, boolean increasePopularity, boolean withInfo, boolean attachment, boolean approved, HttpServletResponse response, HttpServletRequest request, MediaType mediaType) throws Exception {
        Attribute schemaLocAtt;
        Element xml;
        AbstractMetadata metadata;
        try {
            metadata = ApiUtils.canViewRecord(metadataUuid, approved, request);
        }
        catch (ResourceNotFoundException e) {
            Log.debug((String)"geonetwork.api", (String)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Log.debug((String)"geonetwork.api", (String)e.getMessage(), (Throwable)e);
            throw new NotAllowedException("Operation not allowed. User needs to be able to view the resource.");
        }
        ServiceContext context = ApiUtils.createServiceContext(request);
        try {
            Lib.resource.checkPrivilege(context, String.valueOf(metadata.getId()), ReservedOperation.view);
        }
        catch (Exception e) {
            Log.debug((String)"geonetwork.api", (String)e.getMessage(), (Throwable)e);
            throw new NotAllowedException("Operation not allowed. User needs to be able to view the resource.");
        }
        boolean withValidationErrors = false;
        boolean keepXlinkAttributes = false;
        boolean forEditing = false;
        String mdId = String.valueOf(metadata.getId());
        if (approved) {
            mdId = String.valueOf(this.metadataRepository.findOneByUuid(metadata.getUuid()).getId());
            if (increasePopularity) {
                this.dataManager.increasePopularity(context, mdId + "");
            }
        }
        Element element = xml = withInfo ? this.dataManager.getMetadata(context, mdId, forEditing, withValidationErrors, keepXlinkAttributes) : this.dataManager.getMetadataNoInfo(context, mdId + "");
        if (addSchemaLocation && (schemaLocAtt = this.schemaManager.getSchemaLocation(metadata.getDataInfo().getSchemaId(), context)) != null && xml.getAttribute(schemaLocAtt.getName(), schemaLocAtt.getNamespace()) == null) {
            xml.setAttribute(schemaLocAtt);
            xml.removeNamespaceDeclaration(schemaLocAtt.getNamespace());
            xml.addNamespaceDeclaration(schemaLocAtt.getNamespace());
        }
        boolean isJson = MediaType.APPLICATION_JSON.equals((Object)mediaType);
        String mode = attachment ? "attachment" : "inline";
        response.setHeader("Content-Disposition", String.format(mode + "; filename=\"%s.%s\"", metadata.getUuid(), isJson ? "json" : "xml"));
        return isJson ? Xml.getJSON((Element)xml) : xml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="Get a metadata record as ZIP", description="Metadata Exchange Format (MEF) is returned. MEF is a ZIP file containing the metadata as XML and some others files depending on the version requested. See https://docs.geonetwork-opensource.org/latest/annexes/mef-format/.")
    @RequestMapping(value={"/{metadataUuid}/formatters/zip"}, method={RequestMethod.GET}, consumes={"*/*"}, produces={"application/zip", "application/x-gn-mef-1-zip", "application/x-gn-mef-2-zip"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Return the record."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to view the resource.")})
    @ResponseBody
    public void getRecordAsZip(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="MEF file format.", required=false) @RequestParam(required=false, defaultValue="FULL") MEFLib.Format format, @Parameter(description="With related records (parent and service).", required=false) @RequestParam(required=false, defaultValue="true") boolean withRelated, @Parameter(description="Resolve XLinks in the records.", required=false) @RequestParam(required=false, defaultValue="true") boolean withXLinksResolved, @Parameter(description="Preserve XLink URLs in the records.", required=false) @RequestParam(required=false, defaultValue="false") boolean withXLinkAttribute, @RequestParam(required=false, defaultValue="true") boolean addSchemaLocation, @Parameter(description="Download the approved version", required=false) @RequestParam(required=false, defaultValue="true") boolean approved, HttpServletResponse response, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata;
        try {
            metadata = ApiUtils.canViewRecord(metadataUuid, request);
        }
        catch (SecurityException e) {
            Log.debug((String)"geonetwork.api", (String)e.getMessage(), (Throwable)e);
            throw new NotAllowedException("Operation not allowed. User needs to be able to view the resource.");
        }
        Path stylePath = this.dataDirectory.getWebappDir().resolve("xml/schemas/");
        Path file = null;
        ServiceContext serviceContext = ApiUtils.createServiceContext(request);
        String acceptHeader = StringUtils.isBlank((String)request.getHeader("Accept")) ? "application/x-gn-mef-2-zip" : request.getHeader("Accept");
        MEFLib.Version version = MEFLib.Version.find((String)acceptHeader);
        try {
            if (version == MEFLib.Version.V1) {
                boolean skipUUID = false;
                Integer id = -1;
                id = approved ? Integer.valueOf(this.metadataRepository.findOneByUuid(metadataUuid).getId()) : Integer.valueOf(this.metadataUtils.findOneByUuid(metadataUuid).getId());
                file = MEFLib.doExport((ServiceContext)serviceContext, (Integer)id, (String)format.toString(), (boolean)skipUUID, (boolean)withXLinksResolved, (boolean)withXLinkAttribute, (boolean)addSchemaLocation);
                response.setContentType("application/x-gn-mef-1-zip");
            } else {
                HashSet<String> uuidsToExport = new HashSet<String>();
                uuidsToExport.add(metadataUuid);
                if (withRelated) {
                    RelatedResponse related = this.getRelatedResources(metadataUuid, null, approved, 0, 100, request);
                    uuidsToExport.addAll(this.getUuidsOfAssociatedRecords(related.getParent()));
                    uuidsToExport.addAll(this.getUuidsOfAssociatedRecords(related.getChildren()));
                    uuidsToExport.addAll(this.getUuidsOfAssociatedRecords(related.getDatasets()));
                    uuidsToExport.addAll(this.getUuidsOfAssociatedRecords(related.getServices()));
                    uuidsToExport.addAll(this.getUuidsOfAssociatedRecords(related.getSiblings()));
                    uuidsToExport.addAll(this.getUuidsOfAssociatedRecords(related.getRelated()));
                    uuidsToExport.addAll(this.getUuidsOfAssociatedRecords(related.getAssociated()));
                    uuidsToExport.addAll(this.getUuidsOfAssociatedRecords(related.getFcats()));
                    uuidsToExport.addAll(this.getUuidsOfAssociatedRecords(related.getHasfeaturecats()));
                    uuidsToExport.addAll(this.getUuidsOfAssociatedRecords(related.getHassources()));
                }
                Log.info((String)"geonetwork.mef", (Object)("Building MEF2 file with " + uuidsToExport.size() + " records."));
                file = MEFLib.doMEF2Export((ServiceContext)serviceContext, uuidsToExport, (String)format.toString(), (boolean)false, (Path)stylePath, (boolean)withXLinksResolved, (boolean)withXLinkAttribute, (boolean)false, (boolean)addSchemaLocation, (boolean)approved);
                response.setContentType("application/x-gn-mef-2-zip");
            }
            response.setHeader("Content-Disposition", String.format("inline; filename=\"%s.zip\"", metadata.getUuid()));
            response.setHeader("Content-Length", String.valueOf(Files.size(file)));
            FileUtils.copyFile((File)file.toFile(), (OutputStream)response.getOutputStream());
        }
        finally {
            if (file != null) {
                FileUtils.deleteQuietly((File)file.toFile());
            }
        }
    }

    private List<String> getUuidsOfAssociatedRecords(IListOnlyClassToArray associatedRecords) {
        return Optional.ofNullable(associatedRecords).map(r -> r.getItem().stream()).orElseGet(Stream::empty).map(i -> i.getId()).collect(Collectors.toList());
    }

    @Operation(summary="Get record popularity", description="")
    @GetMapping(value={"/{metadataUuid:.+}/popularity"}, consumes={"*/*"}, produces={"text/plain"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Popularity."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to view the resource."), @ApiResponse(responseCode="404", description="Resource not found.")})
    @ResponseStatus(value=HttpStatus.OK)
    public ResponseEntity<String> getRecordPopularity(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata;
        try {
            metadata = ApiUtils.canViewRecord(metadataUuid, request);
            if (metadata instanceof MetadataDraft) {
                metadata = this.metadataRepository.findOneByUuid(metadataUuid);
            }
        }
        catch (ResourceNotFoundException e) {
            Log.debug((String)"geonetwork.api", (String)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Log.debug((String)"geonetwork.api", (String)e.getMessage(), (Throwable)e);
            throw new NotAllowedException("Operation not allowed. User needs to be able to view the resource.");
        }
        return new ResponseEntity((Object)(metadata.getDataInfo().getPopularity() + ""), HttpStatus.OK);
    }

    @Operation(summary="Increase record popularity", description="Used when a view is based on the search results content and does not really access the record. Record is then added to the indexing queue and popularity will be updated soon.")
    @PostMapping(value={"/{metadataUuid:.+}/popularity"}, consumes={"*/*"}, produces={"text/plain"})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Popularity updated."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to view the resource."), @ApiResponse(responseCode="404", description="Resource not found.")})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public ResponseEntity<String> increaseRecordPopularity(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata;
        try {
            metadata = ApiUtils.canViewRecord(metadataUuid, request);
            if (metadata instanceof MetadataDraft) {
                metadata = this.metadataRepository.findOneByUuid(metadataUuid);
            }
        }
        catch (ResourceNotFoundException e) {
            Log.debug((String)"geonetwork.api", (String)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Log.debug((String)"geonetwork.api", (String)e.getMessage(), (Throwable)e);
            throw new NotAllowedException("Operation not allowed. User needs to be able to view the resource.");
        }
        ServiceContext serviceContext = ApiUtils.createServiceContext(request);
        this.dataManager.increasePopularity(serviceContext, metadata.getId() + "");
        return new ResponseEntity((Object)(metadata.getDataInfo().getPopularity() + ""), HttpStatus.CREATED);
    }

    @Operation(summary="Get record related resources", description="Retrieve related services, datasets, onlines, thumbnails, sources, ... to this records.<br/><a href='https://geonetwork-opensource.org/manuals/trunk/eng/users/user-guide/associating-resources/index.html'>More info</a>")
    @RequestMapping(value={"/{metadataUuid:.+}/related"}, method={RequestMethod.GET}, produces={"application/xml", "application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Return the associated resources."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to view the resource.")})
    @ResponseBody
    public RelatedResponse getRelatedResources(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Type of related resource. If none, all resources are returned.", required=false) @RequestParam(defaultValue="") RelatedItemType[] type, @Parameter(description="Use approved version or not", example="true") @RequestParam(required=false, defaultValue="true") Boolean approved, @Parameter(description="Start offset for paging. Default 1. Only applies to related metadata records (ie. not for thumbnails).", required=false) @RequestParam(defaultValue="0") int start, @Parameter(description="Number of rows returned. Default 100.") @RequestParam(defaultValue="100") int rows, HttpServletRequest request) throws Exception {
        AbstractMetadata md;
        try {
            md = ApiUtils.canViewRecord(metadataUuid, approved, request);
        }
        catch (SecurityException e) {
            Log.debug((String)"geonetwork.api", (String)e.getMessage(), (Throwable)e);
            throw new NotAllowedException("Operation not allowed. User needs to be able to view the resource.");
        }
        String language = this.languageUtils.getIso3langCode(request.getLocales());
        ServiceContext serviceContext = ApiUtils.createServiceContext(request);
        return MetadataApi.getRelatedResources(language, serviceContext, md, type, start, rows);
    }

    @Operation(summary="Returns a map to decode attributes in a dataset (from the associated feature catalog)", description="")
    @RequestMapping(value={"/{metadataUuid}/featureCatalog"}, method={RequestMethod.GET}, produces={"application/xml", "application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Return the associated resources."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to view the resource.")})
    @ResponseBody
    public FeatureResponse getFeatureCatalog(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Use approved version or not", example="true") @RequestParam(required=false, defaultValue="true") Boolean approved, HttpServletRequest request) throws ResourceNotFoundException {
        RelatedItemType[] type = new RelatedItemType[]{RelatedItemType.fcats};
        FeatureResponse response = new FeatureResponse();
        HashMap<String, String[]> decodeMap = new HashMap<String, String[]>();
        try {
            RelatedResponse related = this.getRelatedResources(metadataUuid, type, approved, 0, 100, request);
            if (this.isIncludedAttributeTable(related.getFcats())) {
                for (FCRelatedMetadataItem.FeatureType.AttributeTable.Element element : related.getFcats().getItem().get(0).getFeatureType().getAttributeTable().getElement()) {
                    String[] decodedValues;
                    if (StringUtils.isNotBlank((String)element.getCode())) {
                        if (decodeMap.containsKey(element.getCode())) continue;
                        decodedValues = new String[]{element.getName(), element.getDefinition()};
                        decodeMap.put(element.getCode(), decodedValues);
                        continue;
                    }
                    if (decodeMap.containsKey(element.getName())) continue;
                    decodedValues = new String[]{element.getName(), element.getDefinition()};
                    decodeMap.put(element.getName(), decodedValues);
                }
            }
            response.setDecodeMap(decodeMap);
            return response;
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.api", (String)e.getMessage(), (Throwable)e);
            throw new ResourceNotFoundException();
        }
    }

    @Operation(summary="Check if metadata field value is duplicated in another metadata", description="Verifies if a metadata field value is in use. Fields supported: title (title), alternate title (altTitle) or resource identifier (identifier)")
    @PostMapping(value={"/{metadataUuid:.+}/checkDuplicatedFieldValue"}, produces={"application/json"})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Return true if the field value is duplicated in another metadata or false in other case."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to view the resource.")})
    public ResponseEntity<Boolean> checkDuplicatedFieldValue(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Metadata field information to check", required=true) @RequestBody DuplicatedValueDto duplicatedValueDto, HttpServletRequest request) throws Exception {
        try {
            ApiUtils.canViewRecord(metadataUuid, request);
        }
        catch (SecurityException e) {
            Log.debug((String)"geonetwork.api", (String)e.getMessage(), (Throwable)e);
            throw new NotAllowedException("Operation not allowed. User needs to be able to view the resource.");
        }
        List<String> validFields = Arrays.asList("title", "altTitle", "identifier");
        if (!validFields.contains(duplicatedValueDto.getField())) {
            throw new IllegalArgumentException(String.format("A valid field name is required:", String.join((CharSequence)",", validFields)));
        }
        if (StringUtils.isEmpty((String)duplicatedValueDto.getValue())) {
            throw new IllegalArgumentException("A non-empty value is required.");
        }
        boolean uuidsWithSameTitle = MetadataUtils.isMetadataFieldValueExistingInOtherRecords(duplicatedValueDto.getValue(), duplicatedValueDto.getField(), metadataUuid);
        return ResponseEntity.ok((Object)uuidsWithSameTitle);
    }

    private boolean isIncludedAttributeTable(RelatedResponse.Fcat fcat) {
        return fcat != null && fcat.getItem() != null && !fcat.getItem().isEmpty() && fcat.getItem().get(0).getFeatureType() != null && fcat.getItem().get(0).getFeatureType().getAttributeTable() != null && fcat.getItem().get(0).getFeatureType().getAttributeTable().getElement() != null;
    }

    private static class DuplicatedValueDto {
        private String field;
        private String value;

        private DuplicatedValueDto() {
        }

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

