/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jeeves.server.context.ServiceContext;
import jeeves.services.ReadWriteController;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.doi.client.DoiManager;
import org.fao.geonet.domain.AbstractMetadata;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/{portal}/api/records"})
@Tag(name="records", description="Metadata record operations")
@Controller(value="doi")
@PreAuthorize(value="hasAuthority('Editor')")
@ReadWriteController
public class DoiApi {
    @Autowired
    private DoiManager doiManager;

    @Operation(summary="Check that a record can be submitted to DataCite for DOI creation. DataCite requires some fields to be populated.")
    @RequestMapping(value={"/{metadataUuid}/doi/checkPreConditions"}, method={RequestMethod.GET}, produces={"application/json"})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Record can be proposed to DataCite."), @ApiResponse(responseCode="404", description="Metadata not found."), @ApiResponse(responseCode="400", description="Record does not meet preconditions. Check error message."), @ApiResponse(responseCode="500", description="Service unavailable."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseBody
    public ResponseEntity<Map<String, Boolean>> checkDoiStatus(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        ServiceContext serviceContext = ApiUtils.createServiceContext(request);
        Map reportStatus = this.doiManager.check(serviceContext, metadata, null);
        return new ResponseEntity((Object)reportStatus, HttpStatus.OK);
    }

    @Operation(summary="Check the DOI URL created based on current configuration and pattern.")
    @RequestMapping(value={"/{metadataUuid}/doi/checkDoiUrl"}, method={RequestMethod.GET}, produces={"text/plain"})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="DOI URL created."), @ApiResponse(responseCode="404", description="Metadata not found."), @ApiResponse(responseCode="500", description="Service unavailable."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseBody
    public ResponseEntity<String> checkDoiUrl(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        return new ResponseEntity((Object)this.doiManager.checkDoiUrl(metadata), HttpStatus.OK);
    }

    @Operation(summary="Submit a record to the Datacite metadata store in order to create a DOI.")
    @RequestMapping(value={"/{metadataUuid}/doi"}, method={RequestMethod.PUT}, produces={"application/json"})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Check status of the report."), @ApiResponse(responseCode="404", description="Metadata not found."), @ApiResponse(responseCode="500", description="Service unavailable."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @ResponseBody
    public ResponseEntity<Map<String, String>> createDoi(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(hidden=true) HttpServletRequest request, @Parameter(hidden=true) HttpSession session) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        ServiceContext serviceContext = ApiUtils.createServiceContext(request);
        Map doiInfo = this.doiManager.register(serviceContext, metadata);
        return new ResponseEntity((Object)doiInfo, HttpStatus.CREATED);
    }

    @Operation(summary="Remove a DOI (this is not recommended, DOI are supposed to be persistent once created. This is mainly here for testing).")
    @RequestMapping(value={"/{metadataUuid}/doi"}, method={RequestMethod.DELETE}, produces={"application/json"})
    @PreAuthorize(value="hasAuthority('Administrator')")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="DOI unregistered."), @ApiResponse(responseCode="404", description="Metadata or DOI not found."), @ApiResponse(responseCode="500", description="Service unavailable."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Administrators can access it.")})
    @ResponseBody
    public ResponseEntity unregisterDoi(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(hidden=true) HttpServletRequest request, @Parameter(hidden=true) HttpSession session) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        ServiceContext serviceContext = ApiUtils.createServiceContext(request);
        this.doiManager.unregisterDoi(metadata, serviceContext);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }
}

