/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.geotools.data.ows.AbstractOpenWebService;
import org.geotools.data.ows.Capabilities;
import org.geotools.data.ows.GetCapabilitiesRequest;
import org.geotools.data.ows.Request;
import org.geotools.data.ows.Response;
import org.geotools.data.ows.Specification;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.data.wfs.WFSServiceInfo;
import org.geotools.data.wfs.internal.AbstractWFSStrategy;
import org.geotools.data.wfs.internal.ComplexGetFeatureResponse;
import org.geotools.data.wfs.internal.DescribeFeatureTypeRequest;
import org.geotools.data.wfs.internal.DescribeFeatureTypeResponse;
import org.geotools.data.wfs.internal.DescribeStoredQueriesRequest;
import org.geotools.data.wfs.internal.DescribeStoredQueriesResponse;
import org.geotools.data.wfs.internal.FeatureTypeInfo;
import org.geotools.data.wfs.internal.GetCapabilitiesResponse;
import org.geotools.data.wfs.internal.GetFeatureRequest;
import org.geotools.data.wfs.internal.GetFeatureResponse;
import org.geotools.data.wfs.internal.HttpMethod;
import org.geotools.data.wfs.internal.ListStoredQueriesRequest;
import org.geotools.data.wfs.internal.ListStoredQueriesResponse;
import org.geotools.data.wfs.internal.Loggers;
import org.geotools.data.wfs.internal.TransactionRequest;
import org.geotools.data.wfs.internal.TransactionResponse;
import org.geotools.data.wfs.internal.Versions;
import org.geotools.data.wfs.internal.WFSConfig;
import org.geotools.data.wfs.internal.WFSGetCapabilities;
import org.geotools.data.wfs.internal.WFSOperationType;
import org.geotools.data.wfs.internal.WFSStrategy;
import org.geotools.data.wfs.internal.v1_x.ArcGisStrategy_1_X;
import org.geotools.data.wfs.internal.v1_x.CubeWerxStrategy;
import org.geotools.data.wfs.internal.v1_x.GeoServerPre200Strategy;
import org.geotools.data.wfs.internal.v1_x.IonicStrategy;
import org.geotools.data.wfs.internal.v1_x.MapServerWFSStrategy;
import org.geotools.data.wfs.internal.v1_x.StrictWFS_1_x_Strategy;
import org.geotools.data.wfs.internal.v2_0.ArcGisStrategy_2_0;
import org.geotools.data.wfs.internal.v2_0.StrictWFS_2_0_Strategy;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.http.HTTPClient;
import org.geotools.ows.ServiceException;
import org.geotools.util.SuppressFBWarnings;
import org.geotools.util.Version;
import org.geotools.util.logging.Logging;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WFSClient
extends AbstractOpenWebService<WFSGetCapabilities, QName> {
    private static final Logger LOGGER = Logging.getLogger(WFSClient.class);
    protected final WFSConfig config;

    public WFSClient(URL capabilitiesURL, HTTPClient httpClient, WFSConfig config) throws IOException, ServiceException {
        this(capabilitiesURL, httpClient, config, null);
    }

    public WFSClient(URL capabilitiesURL, HTTPClient httpClient, WFSConfig config, WFSGetCapabilities capabilities) throws IOException, ServiceException {
        super(capabilitiesURL, httpClient, (Capabilities)capabilities, Collections.singletonMap("org.xml.sax.EntityResolver", config.getEntityResolver()));
        this.config = config;
        this.specification = this.determineCorrectStrategy();
        ((WFSStrategy)this.specification).setCapabilities((WFSGetCapabilities)this.capabilities);
    }

    protected WFSStrategy getStrategy() {
        return (WFSStrategy)this.specification;
    }

    public WFSGetCapabilities getCapabilities() {
        return (WFSGetCapabilities)this.capabilities;
    }

    public WFSServiceInfo getInfo() {
        return (WFSServiceInfo)super.getInfo();
    }

    protected WFSServiceInfo createInfo() {
        return this.getStrategy().getServiceInfo();
    }

    protected FeatureTypeInfo createInfo(QName typeName) {
        return this.getStrategy().getFeatureTypeInfo(typeName);
    }

    @SuppressFBWarnings(value={"UR_UNINIT_READ_CALLED_FROM_SUPER_CONSTRUCTOR"})
    protected void setupSpecifications() {
        this.specs = new Specification[3];
        StrictWFS_1_x_Strategy strictWFS_1_0_0_Strategy = new StrictWFS_1_x_Strategy(Versions.v1_0_0);
        StrictWFS_1_x_Strategy strictWFS_1_1_0_Strategy = new StrictWFS_1_x_Strategy(Versions.v1_1_0);
        StrictWFS_2_0_Strategy strictWFS_2_0_0_Strategy = new StrictWFS_2_0_Strategy();
        ((WFSStrategy)strictWFS_1_0_0_Strategy).setConfig(this.config);
        ((WFSStrategy)strictWFS_1_1_0_Strategy).setConfig(this.config);
        ((WFSStrategy)strictWFS_2_0_0_Strategy).setConfig(this.config);
        this.specs[0] = strictWFS_1_0_0_Strategy;
        this.specs[1] = strictWFS_1_1_0_Strategy;
        this.specs[2] = strictWFS_2_0_0_Strategy;
    }

    private WFSStrategy determineCorrectStrategy() {
        Element root;
        String ionicNs;
        Version capsVersion = new Version(((WFSGetCapabilities)this.capabilities).getVersion());
        Document capabilitiesDoc = ((WFSGetCapabilities)this.capabilities).getRawDocument();
        String override = this.config.getWfsStrategy();
        AbstractWFSStrategy strategy = null;
        if (!"auto".equals(override)) {
            if (override.equalsIgnoreCase("geoserver")) {
                strategy = new GeoServerPre200Strategy();
            } else if (override.equalsIgnoreCase("mapserver")) {
                strategy = new MapServerWFSStrategy(capabilitiesDoc);
            } else if (override.equalsIgnoreCase("cubewerx")) {
                strategy = new CubeWerxStrategy();
            } else if (override.equalsIgnoreCase("ionic")) {
                strategy = new IonicStrategy();
            } else if (override.equalsIgnoreCase("arcgis") && !Versions.v2_0_0.equals((Object)capsVersion)) {
                strategy = new ArcGisStrategy_1_X();
            } else if (override.equalsIgnoreCase("arcgis") && Versions.v2_0_0.equals((Object)capsVersion)) {
                strategy = new ArcGisStrategy_2_0();
            } else {
                LOGGER.warning("Could not handle wfs strategy override " + override + " proceeding with autodetection");
            }
        }
        if (strategy == null) {
            NodeList childNodes = capabilitiesDoc.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node child = childNodes.item(i);
                if (child.getNodeType() != 8) continue;
                String nodeValue = child.getNodeValue();
                if (!(nodeValue = nodeValue.toLowerCase()).contains("cubewerx")) continue;
                strategy = new CubeWerxStrategy();
                break;
            }
        }
        if (strategy == null && (ionicNs = (root = capabilitiesDoc.getDocumentElement()).getAttribute("xmlns:ionic")) != null) {
            if (ionicNs.equals("http://www.ionicsoft.com/versions/4")) {
                strategy = new IonicStrategy();
            } else if (ionicNs.startsWith("http://www.ionicsoft.com/versions")) {
                LOGGER.warning("Found a Ionic server but the version may not match the strategy we have (v.4). Ionic namespace url: " + ionicNs);
                strategy = new IonicStrategy();
            }
        }
        if (strategy == null) {
            URL capabilitiesURL = this.serverURL;
            String uri = capabilitiesURL.toExternalForm();
            if (!uri.startsWith("file:") && uri.contains("geoserver") && !Versions.v2_0_0.equals((Object)capsVersion)) {
                strategy = new GeoServerPre200Strategy();
            } else if (uri.toLowerCase().contains("/arcgis/services/") && !Versions.v2_0_0.equals((Object)capsVersion)) {
                strategy = new ArcGisStrategy_1_X();
            } else if (uri.toLowerCase().contains("/arcgis/services/") && Versions.v2_0_0.equals((Object)capsVersion)) {
                strategy = new ArcGisStrategy_2_0();
            } else if ((uri.contains("mapserver") || uri.contains("map=")) && !Versions.v2_0_0.equals((Object)capsVersion)) {
                strategy = new MapServerWFSStrategy(capabilitiesDoc);
            }
        }
        if (strategy == null) {
            if (Versions.v1_0_0.equals((Object)capsVersion)) {
                strategy = new StrictWFS_1_x_Strategy(Versions.v1_0_0);
            } else if (Versions.v1_1_0.equals((Object)capsVersion)) {
                strategy = new StrictWFS_1_x_Strategy(Versions.v1_1_0);
            } else if (Versions.v2_0_0.equals((Object)capsVersion)) {
                strategy = new StrictWFS_2_0_Strategy();
            } else {
                throw new IllegalArgumentException("Unsupported version: " + capsVersion);
            }
        }
        LOGGER.finer("Using WFS Strategy: " + ((Object)((Object)strategy)).getClass().getName());
        ((WFSStrategy)strategy).setConfig(this.config);
        return strategy;
    }

    public Set<QName> getRemoteTypeNames() {
        Set<QName> featureTypeNames = this.getStrategy().getFeatureTypeNames();
        return featureTypeNames;
    }

    public boolean supportsTransaction(QName typeName) {
        return this.getStrategy().supportsTransaction(typeName);
    }

    public boolean canLimit() {
        return this.getStrategy().canLimit();
    }

    public boolean canFilter() {
        return true;
    }

    public boolean canRetype() {
        return true;
    }

    public boolean canSort() {
        Version capsVersion = new Version(((WFSGetCapabilities)this.capabilities).getVersion());
        return Versions.v1_1_0.equals((Object)capsVersion);
    }

    public boolean supportsStoredQueries() {
        return this.getStrategy().supportsOperation(WFSOperationType.LIST_STORED_QUERIES, HttpMethod.POST) || this.getStrategy().supportsOperation(WFSOperationType.LIST_STORED_QUERIES, HttpMethod.GET);
    }

    public ReferencedEnvelope getBounds(QName typeName, CoordinateReferenceSystem targetCrs) {
        ReferencedEnvelope bounds;
        WFSStrategy strategy = this.getStrategy();
        FeatureTypeInfo typeInfo = strategy.getFeatureTypeInfo(typeName);
        ReferencedEnvelope nativeBounds = typeInfo.getBounds();
        try {
            bounds = nativeBounds.transform(targetCrs, true);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Can't transform native bounds of " + typeName + ": " + e.getMessage());
            try {
                bounds = typeInfo.getWGS84BoundingBox().transform(targetCrs, true);
            }
            catch (Exception ew) {
                LOGGER.log(Level.WARNING, "Can't transform wgs84 bounds of " + typeName + ": " + e.getMessage());
                bounds = new ReferencedEnvelope(targetCrs);
            }
        }
        return bounds;
    }

    public boolean canCount() {
        return this.getStrategy().supports(GetFeatureRequest.ResultType.HITS);
    }

    public GetFeatureRequest createGetFeatureRequest() {
        return new GetFeatureRequest(this.config, this.getStrategy(), this.getHTTPClient());
    }

    protected Response internalIssueRequest(Request request) throws IOException {
        Response response;
        try {
            LOGGER.fine("FinalURL: " + request.getFinalURL().toString());
            if (LOGGER.isLoggable(Level.FINE) && request.requiresPost()) {
                String msg = request.getPostContentType();
                LOGGER.fine("Post message: " + msg);
            }
            response = super.internalIssueRequest(request);
        }
        catch (ServiceException e) {
            throw new IOException(e);
        }
        return response;
    }

    public GetCapabilitiesResponse issueRequest(GetCapabilitiesRequest request) throws IOException, ServiceException {
        return (GetCapabilitiesResponse)this.internalIssueRequest((Request)request);
    }

    public ListStoredQueriesResponse issueRequest(ListStoredQueriesRequest request) throws IOException {
        return (ListStoredQueriesResponse)this.internalIssueRequest(request);
    }

    public DescribeStoredQueriesResponse issueRequest(DescribeStoredQueriesRequest request) throws IOException {
        return (DescribeStoredQueriesResponse)this.internalIssueRequest(request);
    }

    public TransactionRequest createTransaction() {
        WFSStrategy strategy = this.getStrategy();
        return new TransactionRequest(this.config, strategy);
    }

    public TransactionResponse issueTransaction(TransactionRequest request) throws IOException {
        Loggers.requestDebug("Sending Transaction request to ", request.getFinalURL());
        Response response = this.internalIssueRequest(request);
        return (TransactionResponse)response;
    }

    public GetFeatureResponse issueRequest(GetFeatureRequest request) throws IOException {
        Loggers.requestDebug("Sending GetFeature request to ", request.getFinalURL());
        Response response = this.internalIssueRequest(request);
        if (!(response instanceof GetFeatureResponse)) {
            throw new RuntimeException("Should have been a GetFeatureResponse, but instead is:" + response.getClass().getSimpleName());
        }
        return (GetFeatureResponse)response;
    }

    public ComplexGetFeatureResponse issueComplexRequest(GetFeatureRequest request) throws IOException {
        Loggers.requestDebug("Sending GetFeature request to ", request.getFinalURL());
        Response response = this.internalIssueRequest(request);
        if (!(response instanceof ComplexGetFeatureResponse)) {
            throw new RuntimeException("Should have been a ComplexGetFeatureResponse, but instead is:" + response.getClass().getSimpleName());
        }
        return (ComplexGetFeatureResponse)response;
    }

    public DescribeFeatureTypeRequest createDescribeFeatureTypeRequest() {
        return new DescribeFeatureTypeRequest(this.config, this.getStrategy());
    }

    public URL getDescribeFeatureTypeGetURL(QName name) {
        try {
            WFSConfig config = WFSConfig.fromParams(Collections.singletonMap(WFSDataStoreFactory.PROTOCOL.key, Boolean.FALSE));
            DescribeFeatureTypeRequest request = new DescribeFeatureTypeRequest(config, this.getStrategy());
            request.setTypeName(name);
            return request.getFinalURL();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't create a WFS config object.", e);
        }
    }

    public ListStoredQueriesRequest createListStoredQueriesRequest() {
        return new ListStoredQueriesRequest(this.config, this.getStrategy());
    }

    public DescribeStoredQueriesRequest createDescribeStoredQueriesRequest() {
        return new DescribeStoredQueriesRequest(this.config, this.getStrategy());
    }

    public DescribeFeatureTypeResponse issueRequest(DescribeFeatureTypeRequest request) throws IOException {
        Loggers.requestDebug("Sending DFT request to ", request.getFinalURL());
        Response response = this.internalIssueRequest(request);
        return (DescribeFeatureTypeResponse)response;
    }

    public Filter[] splitFilters(QName typeName, Filter filter) {
        return this.getStrategy().splitFilters(typeName, filter);
    }

    public CoordinateReferenceSystem getDefaultCRS(QName typeName) {
        WFSStrategy strategy = this.getStrategy();
        FeatureTypeInfo typeInfo = strategy.getFeatureTypeInfo(typeName);
        CoordinateReferenceSystem crs = typeInfo.getCRS();
        return crs;
    }

    public String getAxisOrderFilter() {
        return this.config.getAxisOrderFilter();
    }

    public URL getCapabilitiesURL() {
        return this.serverURL;
    }

    public WFSConfig getConfig() {
        return this.config;
    }
}

