/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.util.log;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class ThreadLog {
    public static final int NONE = 0;
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int STATUS = 3;
    public static final int TRACE = 4;
    public static final int ALL = 5;
    static SimpleDateFormat _formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
    static String[] _levelNames = new String[]{"NONE   ", "ERROR  ", "WARNING", "STATUS ", "TRACE  ", "ALL    "};
    static InheritableThreadLocal _threadContext = new InheritableThreadLocal();
    static ThreadLog _defaultThreadLog;
    static HashMap _writerTable;
    Writer _logWriter;
    int _logLevel;
    String _threadName;

    public static void setDefaultLog(String logFile, int logLevel) {
        if (_defaultThreadLog == null) {
            _defaultThreadLog = new ThreadLog();
        }
        Writer logWriter = null;
        try {
            logWriter = ThreadLog._getLogWriter(logFile);
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            try {
                logWriter = ThreadLog._getLogWriter(null);
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        _defaultThreadLog.setLogWriter(logWriter);
        _defaultThreadLog.setLogLev(logLevel);
    }

    public static void unsetDefaultLog() {
        _defaultThreadLog = null;
    }

    public static void registerThread(String logFile, int logLevel) {
        ThreadLog threadLog = ThreadLog._createThreadLog();
        Writer logWriter = null;
        try {
            logWriter = ThreadLog._getLogWriter(logFile);
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            try {
                logWriter = ThreadLog._getLogWriter(null);
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        threadLog.setLogWriter(logWriter);
        threadLog.setLogLev(logLevel);
        Thread currentThread = Thread.currentThread();
        threadLog.setThreadName(currentThread.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLogLevel(int logLevel) {
        ThreadLog threadLog = null;
        InheritableThreadLocal inheritableThreadLocal = _threadContext;
        synchronized (inheritableThreadLocal) {
            threadLog = (ThreadLog)_threadContext.get();
        }
        if (threadLog != null) {
            threadLog.setLogLev(logLevel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ThreadLog _createThreadLog() {
        ThreadLog threadLog = null;
        InheritableThreadLocal inheritableThreadLocal = _threadContext;
        synchronized (inheritableThreadLocal) {
            threadLog = (ThreadLog)_threadContext.get();
            if (threadLog == null) {
                threadLog = new ThreadLog();
                _threadContext.set(threadLog);
            }
        }
        return threadLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Writer _getLogWriter(String logFile) throws IOException {
        Writer logWriter = null;
        String absPath = null;
        File file = null;
        if (logFile != null) {
            file = new File(logFile);
            absPath = file.getAbsolutePath();
        }
        HashMap hashMap = _writerTable;
        synchronized (hashMap) {
            logWriter = (Writer)_writerTable.get(absPath);
            if (logWriter == null) {
                if (absPath != null) {
                    if (!file.getParentFile().exists()) {
                        file.getParentFile().mkdirs();
                    }
                    logWriter = new FileWriter(absPath, true);
                } else {
                    logWriter = new OutputStreamWriter(System.err);
                }
                _writerTable.put(absPath, logWriter);
            }
        }
        return logWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregisterThread() {
        InheritableThreadLocal inheritableThreadLocal = _threadContext;
        synchronized (inheritableThreadLocal) {
            _threadContext.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ThreadLog _getThreadLog() {
        ThreadLog threadLog = null;
        InheritableThreadLocal inheritableThreadLocal = _threadContext;
        synchronized (inheritableThreadLocal) {
            threadLog = (ThreadLog)_threadContext.get();
        }
        if (threadLog == null) {
            threadLog = _defaultThreadLog;
        }
        return threadLog;
    }

    ThreadLog() {
        this(null, 5);
    }

    ThreadLog(Writer logWriter) {
        this(logWriter, 5);
    }

    ThreadLog(Writer logWriter, int logLevel) {
        this.setLogWriter(logWriter);
        this.setLogLev(logLevel);
        this._threadName = null;
    }

    void setLogWriter(Writer logWriter) {
        this._logWriter = logWriter;
    }

    void setLogLev(int logLevel) {
        this._logLevel = logLevel;
    }

    int getLogLevel() {
        return this._logLevel;
    }

    void setThreadName(String threadName) {
        this._threadName = threadName;
    }

    String getThreadName() {
        return this._threadName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doLog(String msg, Object arg, int level) {
        if (this._logLevel < level) {
            return;
        }
        String logMsg = ThreadLog._createLogMessage(msg, arg, level, this._threadName);
        try {
            Writer writer = this._logWriter;
            synchronized (writer) {
                this._logWriter.write(logMsg);
                this._logWriter.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static String _createLogMessage(String msg, Object arg, int level, String threadName) {
        StringBuffer logMsg = new StringBuffer(128);
        logMsg.append(_formatter.format(new Date()));
        if (threadName != null) {
            logMsg.append(" [");
            logMsg.append(threadName);
            logMsg.append("]");
        }
        logMsg.append(" [");
        logMsg.append(_levelNames[level]);
        logMsg.append("] ");
        logMsg.append(msg);
        if (arg != null) {
            logMsg.append(": ");
            if (arg instanceof Throwable) {
                Throwable throwable = (Throwable)arg;
                logMsg.append(throwable.getMessage());
                logMsg.append("\n");
                StringWriter stackTrace = new StringWriter();
                PrintWriter pw = new PrintWriter(stackTrace);
                throwable.printStackTrace(pw);
                logMsg.append(stackTrace.toString());
            } else {
                logMsg.append(arg);
            }
        }
        logMsg.append("\n");
        return logMsg.toString();
    }

    public static void error(String msg) {
        ThreadLog._log(msg, null, 1);
    }

    public static void error(String msg, Object arg) {
        ThreadLog._log(msg, arg, 1);
    }

    public static void warning(String msg) {
        ThreadLog._log(msg, null, 2);
    }

    public static void warning(String msg, Object arg) {
        ThreadLog._log(msg, arg, 2);
    }

    public static void log(String msg) {
        ThreadLog._log(msg, null, 3);
    }

    public static void log(String msg, Object arg) {
        ThreadLog._log(msg, arg, 3);
    }

    public static void trace(String msg) {
        ThreadLog._log(msg, null, 4);
    }

    public static void trace(String msg, Object arg) {
        ThreadLog._log(msg, arg, 4);
    }

    protected static void _log(String msg, Object arg, int level) {
        ThreadLog threadLog = ThreadLog._getThreadLog();
        if (threadLog != null) {
            threadLog.doLog(msg, arg, level);
        }
    }

    static {
        _writerTable = new HashMap();
    }
}

