/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.util;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.kernel.search.JSONLocCacheLoader;
import org.fao.geonet.util.XslUtil;

public class LocalizedEmailParameter {
    private final Object id;
    private final ParameterType parameterType;
    private final Object value;
    private final Object metadataUuid;

    public LocalizedEmailParameter(ParameterType parameterType, Object id, Object value) {
        this.parameterType = parameterType;
        this.id = id;
        this.value = value;
        this.metadataUuid = null;
    }

    public LocalizedEmailParameter(ParameterType parameterType, Object id, Object value, String metadataUuid) {
        this.parameterType = parameterType;
        this.id = id;
        this.value = value;
        this.metadataUuid = metadataUuid;
    }

    public Object getId() {
        return this.id;
    }

    public String parseValue(Locale locale) {
        if (this.value == null) {
            return "null";
        }
        switch (this.parameterType) {
            case MESSAGE_OR_JSON_KEY: {
                try {
                    return this.getResourceBundleString(locale);
                }
                catch (MissingResourceException missingResourceException) {
                    return this.getJsonTranslationMapString(locale);
                }
            }
            case MESSAGE_KEY: {
                try {
                    return this.getResourceBundleString(locale);
                }
                catch (MissingResourceException e) {
                    return this.value.toString();
                }
            }
            case JSON_KEY: {
                return this.getJsonTranslationMapString(locale);
            }
            case INDEX_FIELD: {
                if (this.metadataUuid == null) {
                    throw new IllegalArgumentException("Metadata UUID is required for parameters of type INDEX_FIELD");
                }
                return XslUtil.getIndexField(null, this.metadataUuid, this.value, locale);
            }
            case RAW_VALUE: {
                return this.value.toString();
            }
        }
        throw new IllegalArgumentException("Unsupported parameter type: " + (Object)((Object)this.parameterType));
    }

    private String getResourceBundleString(Locale locale) {
        return ResourceBundle.getBundle("org.fao.geonet.api.Messages", locale).getString(this.value.toString());
    }

    private String getJsonTranslationMapString(Locale locale) {
        try {
            Object translationMap = new JSONLocCacheLoader(ApplicationContextHolder.get(), locale.getISO3Language()).call();
            return translationMap.getOrDefault(this.value.toString(), this.value.toString());
        }
        catch (Exception exception) {
            return this.value.toString();
        }
    }

    public static enum ParameterType {
        MESSAGE_OR_JSON_KEY,
        MESSAGE_KEY,
        JSON_KEY,
        INDEX_FIELD,
        RAW_VALUE;

    }
}

