/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.thumbnail;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import javax.imageio.ImageIO;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.Log;
import org.mapfish.print.MapPrinter;
import org.mapfish.print.output.OutputFormat;
import org.mapfish.print.output.PrintParams;
import org.mapfish.print.utils.PJsonObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class ThumbnailMaker {
    private static final String LOGGER_NAME = "thumbnail.maker";
    private static final String CONFIG_FILE = "WEB-INF/config-print/print-config.yaml";
    private MapPrinter mapPrinter = null;
    private File configFile = null;
    private String configFilePath = null;
    private long lastModified = Long.MIN_VALUE;
    @Autowired
    private ApplicationContext _applicationContext;

    public static void rotate(Path imageFile, String extension, int angle) {
        try {
            BufferedImage originalImage = ThumbnailMaker.readImage(imageFile);
            BufferedImage rotatedImage = ThumbnailMaker.rotate(originalImage, angle);
            ThumbnailMaker.writeImage(rotatedImage, imageFile, extension);
        }
        catch (IOException e) {
            Log.error((String)"geonetwork", (String)("Error rotating thumbnail: " + e.getMessage()), (Throwable)e);
        }
    }

    public static BufferedImage readImage(Path fileLocation) throws IOException {
        BufferedImage img;
        try (InputStream in = IO.newInputStream((Path)fileLocation);){
            img = ImageIO.read(in);
        }
        return img;
    }

    public static void writeImage(BufferedImage img, Path fileLocation, String extension) throws IOException {
        try (OutputStream out = Files.newOutputStream(fileLocation, new OpenOption[0]);){
            ImageIO.write((RenderedImage)img, extension, out);
        }
    }

    public static BufferedImage rotate(BufferedImage image, double angle) {
        angle = Math.toRadians(angle);
        double sin = Math.abs(Math.sin(angle));
        double cos = Math.abs(Math.cos(angle));
        int w = image.getWidth();
        int h = image.getHeight();
        int neww = (int)Math.floor((double)w * cos + (double)h * sin);
        int newh = (int)Math.floor((double)h * cos + (double)w * sin);
        BufferedImage result = new BufferedImage(neww, newh, 3);
        Graphics2D g = result.createGraphics();
        g.translate((neww - w) / 2, (newh - h) / 2);
        g.rotate(angle, (double)w / 2.0, (double)h / 2.0);
        g.drawRenderedImage(image, null);
        g.dispose();
        return result;
    }

    public void init(ServiceContext context) {
        this.configFilePath = context.getAppPath() + File.separator + CONFIG_FILE;
        this.initMapPrinter();
    }

    private void initMapPrinter() {
        long lastModifiedCheck = this.lastModified;
        if (this.configFile != null) {
            lastModifiedCheck = this.configFile.lastModified();
        }
        if (this.configFile == null || this.lastModified < lastModifiedCheck) {
            this.mapPrinter = (MapPrinter)this._applicationContext.getBean(MapPrinter.class);
            this.configFile = new File(this.configFilePath);
            if (Log.isDebugEnabled((String)LOGGER_NAME)) {
                Log.debug((String)LOGGER_NAME, (Object)("Loading or reloading configuration file: " + this.configFile.getAbsolutePath()));
            }
            try {
                this.mapPrinter.setYamlConfigFile(this.configFile);
                if (Log.isDebugEnabled((String)LOGGER_NAME)) {
                    Log.debug((String)LOGGER_NAME, (Object)("Print module configuration: " + this.mapPrinter.getConfig().toString()));
                }
                this.lastModified = lastModifiedCheck;
            }
            catch (FileNotFoundException e) {
                Log.error((String)LOGGER_NAME, (Object)("Thumbnail maker configuration file " + this.configFilePath + " not found. Error is " + e.getMessage()));
            }
        }
    }

    private MapPrinter getMapPrinter() {
        return this.mapPrinter;
    }

    public Path generateThumbnail(String jsonConfig, Integer rotationAngle) throws IOException {
        PJsonObject specJson = MapPrinter.parseSpec((String)jsonConfig);
        if (Log.isDebugEnabled((String)LOGGER_NAME)) {
            Log.debug((String)LOGGER_NAME, (Object)("Generating thumbnail from config: " + jsonConfig));
        }
        OutputFormat outputFormat = this.getMapPrinter().getOutputFormat(specJson);
        Path tempFile = Files.createTempFile("thumbnail", "." + outputFormat.getFileSuffix(), new FileAttribute[0]);
        try (OutputStream out = Files.newOutputStream(tempFile, new OpenOption[0]);){
            PrintParams params = new PrintParams(this.getMapPrinter().getConfig(), this.configFile.getParentFile(), specJson, out, new HashMap());
            outputFormat.print(params);
        }
        catch (InterruptedException e) {
            Log.error((String)"geonetwork", (String)"Error creating a thumbnail", (Throwable)e);
        }
        if (rotationAngle != null) {
            ThumbnailMaker.rotate(tempFile, outputFormat.getFileSuffix(), rotationAngle);
        }
        return tempFile;
    }
}

