/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.schema;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.domain.Schematron;
import org.fao.geonet.domain.SchematronCriteria;
import org.fao.geonet.domain.SchematronCriteriaGroup;
import org.fao.geonet.domain.SchematronCriteriaGroupId;
import org.fao.geonet.domain.SchematronCriteriaType;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.schema.Logger;
import org.fao.geonet.kernel.schema.MetadataSchemaOperationFilter;
import org.fao.geonet.kernel.schema.MetadataType;
import org.fao.geonet.kernel.schema.SavedQuery;
import org.fao.geonet.kernel.schema.SchemaPlugin;
import org.fao.geonet.kernel.schema.editorconfig.Editor;
import org.fao.geonet.repository.SchematronCriteriaGroupRepository;
import org.fao.geonet.repository.SchematronRepository;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;

@JsonPropertyOrder(value={"name", "titles", "descriptions", "standardUrl", "targetNamespace", "namespaces", "readwriteUUID", "schematronRules"})
public class MetadataSchema {
    public static final String SCHEMATRON_DIR = "schematron";
    private static final String XSL_FILE_EXTENSION = ".xsl";
    private static final String SCH_FILE_EXTENSION = ".sch";
    private static final String SCHEMATRON_RULE_FILE_PREFIX = "schematron-rules";
    private Map<String, List<String>> hmElements = new HashMap<String, List<String>>();
    private Map<String, List<List<String>>> hmRestric = new HashMap<String, List<List<String>>>();
    private Map<String, MetadataType> hmTypes = new HashMap<String, MetadataType>();
    private Map<String, List<String>> hmSubs = new HashMap<String, List<String>>();
    private Map<String, String> hmSubsLink = new HashMap<String, String>();
    private Map<String, Namespace> hmNameSpaces = new HashMap<String, Namespace>();
    private Map<String, Namespace> hmPrefixes = new HashMap<String, Namespace>();
    private Map<String, MetadataSchemaOperationFilter> hmOperationFilters = new HashMap<String, MetadataSchemaOperationFilter>();
    private String schemaName = "UNKNOWN";
    private Path schemaDir;
    private String standardUrl;
    private String version;
    private String appMinorVersionSupported;
    private String appMajorVersionSupported;
    private Map<String, String> titles = new HashMap<String, String>();
    private Map<String, String> descriptions = new HashMap<String, String>();
    private String primeNS;
    private String[] schematronRules;
    private boolean canEdit = false;
    private boolean readwriteUUID = false;
    private List<Element> rootAppInfoElements;
    private SchematronRepository schemaRepo;
    private SchematronCriteriaGroupRepository criteriaGroupRepository;
    private SchemaPlugin schemaPlugin;
    private String dependsOn;

    MetadataSchema(SchematronRepository schemaRepo, SchematronCriteriaGroupRepository criteriaGroupRepository) {
        this.schemaRepo = schemaRepo;
        this.criteriaGroupRepository = criteriaGroupRepository;
    }

    public boolean canEdit() {
        return this.canEdit;
    }

    public void setCanEdit(boolean canEdit) {
        this.canEdit = canEdit;
    }

    public String getName() {
        return this.schemaName;
    }

    public void setName(String inName) {
        this.schemaName = inName;
        this.schemaPlugin = SchemaManager.getSchemaPlugin(this.schemaName);
    }

    @JsonIgnore
    public Editor getConfigEditor() {
        Path metadataSchemaConfig = this.getSchemaDir().resolve("layout").resolve("config-editor.xml");
        if (metadataSchemaConfig.toFile().exists()) {
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Editor.class});
                Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                return (Editor)unmarshaller.unmarshal(metadataSchemaConfig.toFile());
            }
            catch (JAXBException e) {
                Log.error((String)"geonetwork.schemamanager", (String)(" Get config editor. Error is " + e.getMessage()), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @JsonIgnore
    public Path getSchemaDir() {
        return this.schemaDir;
    }

    public void setSchemaDir(Path schemaDir) {
        this.schemaDir = schemaDir;
    }

    @JsonProperty(value="targetNamespace")
    public String getPrimeNS() {
        return this.primeNS;
    }

    public void setPrimeNS(String theNS) {
        this.primeNS = theNS;
    }

    public MetadataType getTypeInfo(String type) {
        Logger.log();
        if (this.hmTypes.get(type) == null) {
            return new MetadataType();
        }
        return this.hmTypes.get(type);
    }

    public String getElementType(String elem, String parent) throws Exception {
        Logger.log();
        List<String> childType = this.hmElements.get(elem);
        if (childType == null) {
            String oldelem = elem;
            elem = this.hmSubsLink.get(elem);
            Logger.log();
            childType = this.hmElements.get(elem);
            if (childType == null) {
                Log.warning((String)"geonetwork.schemamanager", (Object)("ERROR: Mismatch between schema and xml: No type for 'element' : " + oldelem + " with parent " + parent + ". Returning xs:string"));
                return "xs:string";
            }
        }
        if (childType.size() == 1) {
            return childType.get(0);
        }
        Logger.log();
        List<String> exType = this.hmElements.get(parent);
        if (exType == null) {
            return "xs:string";
        }
        for (String type : exType) {
            MetadataType mdt = this.getTypeInfo(type);
            for (int k = 0; k < mdt.getElementCount(); ++k) {
                String elemTest = mdt.getElementAt(k);
                if (!elem.equals(elemTest)) continue;
                return mdt.getElementTypeAt(k);
            }
        }
        Logger.log();
        return null;
    }

    public boolean isSimpleElement(String elem, String parent) throws Exception {
        String type = this.getElementType(elem, parent);
        return type != null && !this.hmTypes.containsKey(type);
    }

    public List<String> getElementValues(String elem, String parent) throws Exception {
        List<List<String>> childValues;
        String type = this.getElementType(elem, parent);
        String restricName = elem;
        if (type != null) {
            restricName = restricName + "+" + type;
        }
        if ((childValues = this.hmRestric.get(restricName)) == null) {
            return null;
        }
        if (childValues.size() == 1) {
            return childValues.get(0);
        }
        Logger.log();
        return childValues.get(0);
    }

    void addElement(String name, String type, List<String> alValues, List<String> alSubs, String subLink) {
        List<List<String>> exValues;
        List<String> exType;
        if (alSubs != null && !alSubs.isEmpty()) {
            this.hmSubs.put(name, alSubs);
        }
        if (subLink != null && StringUtils.isNotBlank((String)subLink)) {
            this.hmSubsLink.put(name, subLink);
        }
        if ((exType = this.hmElements.get(name)) != null && exType.contains(type)) {
            return;
        }
        if (exType != null && !exType.contains(type)) {
            Logger.log();
        } else {
            exType = new ArrayList<String>();
            this.hmElements.put(name, exType);
        }
        exType.add(type);
        String restricName = name;
        if (type != null) {
            restricName = name + "+" + type;
        }
        if ((exValues = this.hmRestric.get(restricName)) != null) {
            Logger.log();
        } else {
            exValues = new ArrayList<List<String>>();
            this.hmRestric.put(restricName, exValues);
        }
        exValues.add(alValues);
    }

    public void addType(String name, MetadataType mdt) {
        mdt.setName(name);
        this.hmTypes.put(name, mdt);
    }

    public void addNS(String targetNSPrefix, String targetNSUri) {
        Namespace ns = Namespace.getNamespace((String)targetNSPrefix, (String)targetNSUri);
        this.hmNameSpaces.put(targetNSPrefix, ns);
        this.hmPrefixes.put(targetNSUri, ns);
    }

    @JsonIgnore
    public String getNS(String targetNSPrefix) {
        Namespace ns = this.hmNameSpaces.get(targetNSPrefix);
        if (ns != null) {
            return ns.getURI();
        }
        return null;
    }

    @JsonIgnore
    public List<Namespace> getNamespaces() {
        ArrayList<Namespace> list = new ArrayList<Namespace>(this.hmNameSpaces.size());
        for (Namespace ns : this.hmNameSpaces.values()) {
            list.add(ns);
        }
        return list;
    }

    public String getPrefix(String theNSUri) {
        Namespace ns = this.hmPrefixes.get(theNSUri);
        if (ns != null) {
            return ns.getPrefix();
        }
        return null;
    }

    @JsonIgnore
    public List<Namespace> getSchemaNS() {
        return new ArrayList<Namespace>(this.hmPrefixes.values());
    }

    @JsonProperty(value="namespaces")
    public Map<String, String> getSchemaNSWithPrefix() {
        HashMap<String, String> mapNs = new HashMap<String, String>();
        List<Namespace> schemaNsList = this.getSchemaNS();
        for (Namespace ns : schemaNsList) {
            mapNs.put(ns.getPrefix(), ns.getURI());
        }
        return mapNs;
    }

    public void buildchematronRules(Path basePath) {
        Path schematronResourceDir = basePath.resolve("WEB-INF").resolve("classes").resolve(SCHEMATRON_DIR);
        Path schemaSchematronDir = this.schemaDir.resolve(SCHEMATRON_DIR);
        Path schematronCompilationFile = schematronResourceDir.resolve("iso_svrl_for_xslt2.xsl");
        Path schematronExpandFile = schematronResourceDir.resolve("iso_abstract_expand.xsl");
        if (Log.isDebugEnabled((String)"geonetwork.schemamanager")) {
            Log.debug((String)"geonetwork.schemamanager", (Object)("     Schematron compilation for schema " + this.schemaName));
            Log.debug((String)"geonetwork.schemamanager", (Object)("          - compiling with " + schematronCompilationFile));
            Log.debug((String)"geonetwork.schemamanager", (Object)("          - rules location is " + schemaSchematronDir));
        }
        if (Files.exists(schemaSchematronDir, new LinkOption[0])) {
            try (DirectoryStream<Path> paths = Files.newDirectoryStream(schemaSchematronDir, "*.sch");){
                for (Path rule : paths) {
                    if (Log.isDebugEnabled((String)"geonetwork.schemamanager")) {
                        Log.debug((String)"geonetwork.schemamanager", (Object)("                - rule " + rule));
                    }
                    String xslPath = rule.toAbsolutePath().toString().replace(SCH_FILE_EXTENSION, XSL_FILE_EXTENSION);
                    Path schematronXslFilePath = rule.getFileSystem().getPath(xslPath, new String[0]);
                    try {
                        OutputStream schematronXsl = Files.newOutputStream(schematronXslFilePath, new OpenOption[0]);
                        Throwable throwable = null;
                        try {
                            Element schematronRule = Xml.loadFile((Path)schemaSchematronDir.resolve(rule));
                            Element schematronExpandXml = Xml.transform((Element)schematronRule, (Path)schematronExpandFile);
                            Xml.transform((Element)schematronExpandXml, (Path)schematronCompilationFile, (OutputStream)schematronXsl);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (schematronXsl == null) continue;
                            if (throwable != null) {
                                try {
                                    schematronXsl.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            schematronXsl.close();
                        }
                    }
                    catch (FileNotFoundException e) {
                        Log.error((String)"geonetwork.schemamanager", (String)("     Schematron rule file not found " + schematronXslFilePath + ". Error is " + e.getMessage()), (Throwable)e);
                    }
                    catch (Exception e) {
                        Log.error((String)"geonetwork.schemamanager", (String)("     Schematron rule compilation failed for " + schematronXslFilePath + ". Error is " + e.getMessage()), (Throwable)e);
                    }
                }
            }
            catch (IOException e) {
                Log.error((String)"geonetwork.schemamanager", (String)("     Schematron rule file not found " + schemaSchematronDir + ". Error is " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void loadSchematronRules(Path basePath) {
        this.buildchematronRules(basePath);
        ArrayList saSchemas = Lists.newArrayList();
        Path schematronDir = this.schemaDir.resolve(SCHEMATRON_DIR);
        if (Files.exists(schematronDir, new LinkOption[0])) {
            HashMap existing = Maps.newHashMap();
            for (Schematron schematron : this.schemaRepo.findAllBySchemaName(this.schemaName)) {
                existing.put(schematron.getRuleName(), schematron);
            }
            try (DirectoryStream<Path> schematronFiles = Files.newDirectoryStream(schematronDir, new SchematronReportRulesFilter());){
                for (Path schematronFile : schematronFiles) {
                    String schematronFileName = schematronFile.getFileName().toString();
                    saSchemas.add(schematronFileName);
                    Schematron schematron = new Schematron();
                    schematron.setSchemaName(this.schemaName);
                    schematron.setFile(schematronFileName);
                    schematron.setDisplayPriority(0);
                    if (existing.containsKey(schematron.getRuleName())) {
                        if (Files.exists(schematronDir.resolve(schematron.getFile()), new LinkOption[0])) continue;
                        schematron.setFile(schematronFileName);
                        this.schemaRepo.saveAndFlush((Object)schematron);
                        continue;
                    }
                    schematron.getLabelTranslations().put("eng", schematron.getRuleName());
                    this.schemaRepo.saveAndFlush((Object)schematron);
                    SchematronCriteriaGroup schematronCriteriaGroup = new SchematronCriteriaGroup();
                    schematronCriteriaGroup.setId(new SchematronCriteriaGroupId("*Generated*", schematron.getId()));
                    schematronCriteriaGroup.setRequirement(schematron.getDefaultRequirement());
                    SchematronCriteria criteria = new SchematronCriteria();
                    criteria.setValue("_ignored_");
                    criteria.setType(SchematronCriteriaType.ALWAYS_ACCEPT);
                    schematronCriteriaGroup.addCriteria(criteria);
                    this.criteriaGroupRepository.saveAndFlush((Object)schematronCriteriaGroup);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.setSchematronPriorities();
        }
        this.setSchematronRules(saSchemas.toArray(new String[saSchemas.size()]));
    }

    private void setSchematronPriorities() {
        List schematronList = this.schemaRepo.findAllBySchemaName(this.schemaName);
        Collections.sort(schematronList, Schematron.DISPLAY_PRIORITY_COMPARATOR);
        ArrayList updated = Lists.newArrayList();
        for (int i = 0; i < schematronList.size(); ++i) {
            Schematron schematron = (Schematron)schematronList.get(i);
            if (schematron.getDisplayPriority() == i) continue;
            schematron.setDisplayPriority(i);
            updated.add(schematron);
        }
        this.schemaRepo.saveAll((Iterable)updated);
    }

    public void setOperationFilters(Map<String, MetadataSchemaOperationFilter> operationFilters) {
        this.hmOperationFilters = operationFilters;
    }

    public MetadataSchemaOperationFilter getOperationFilter(ReservedOperation operation) {
        return this.hmOperationFilters.get(operation.name());
    }

    public MetadataSchemaOperationFilter getOperationFilter(String operation) {
        return this.hmOperationFilters.get(operation);
    }

    @JsonIgnore
    public SchemaPlugin getSchemaPlugin() {
        return this.schemaPlugin;
    }

    public String[] getSchematronRules() {
        if (this.schematronRules != null) {
            return (String[])this.schematronRules.clone();
        }
        return new String[0];
    }

    private void setSchematronRules(String[] schematronRules) {
        if (schematronRules != null) {
            this.schematronRules = (String[])schematronRules.clone();
        }
    }

    public void setRootAppInfoElements(List<Element> rootAppInfoElements) {
        this.rootAppInfoElements = rootAppInfoElements;
    }

    @JsonIgnore
    public List<Element> getSchemaAppInfoElements() {
        return this.rootAppInfoElements;
    }

    public boolean isReadwriteUUID() {
        return this.readwriteUUID;
    }

    public void setReadwriteUUID(boolean readwriteUUID) {
        this.readwriteUUID = readwriteUUID;
    }

    public String getStandardUrl() {
        return this.standardUrl;
    }

    public void setStandardUrl(String standardUrl) {
        this.standardUrl = standardUrl;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getAppMinorVersionSupported() {
        return this.appMinorVersionSupported;
    }

    public void setAppMinorVersionSupported(String appMinorVersionSupported) {
        this.appMinorVersionSupported = appMinorVersionSupported;
    }

    public String getAppMajorVersionSupported() {
        return this.appMajorVersionSupported;
    }

    public void setAppMajorVersionSupported(String appMajorVersionSupported) {
        this.appMajorVersionSupported = appMajorVersionSupported;
    }

    public String getDependsOn() {
        return this.dependsOn;
    }

    public void setDependsOn(String depends) {
        this.dependsOn = depends;
    }

    public Map<String, String> getTitles() {
        return this.titles;
    }

    public void setTitles(Map<String, String> titles) {
        this.titles = titles;
    }

    public Map<String, String> getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(Map<String, String> descriptions) {
        this.descriptions = descriptions;
    }

    public String queryString(String savedQuery, Element xml) throws ResourceNotFoundException, JDOMException {
        SavedQuery query = this.schemaPlugin.getSavedQuery(savedQuery);
        if (query == null) {
            throw new ResourceNotFoundException(String.format("Saved query '%s' for schema '%s' not found. Available queries are '%s'.", savedQuery, this.getName(), this.schemaPlugin.getSavedQueries().stream().map(SavedQuery::getId).collect(Collectors.joining(", "))));
        }
        String xpath = query.getXpath();
        if (Log.isDebugEnabled((String)"geonetwork.schemamanager")) {
            Log.error((String)"geonetwork.schemamanager", (Object)String.format("Saved query XPath: %s", xpath));
        }
        return Xml.selectString((Element)xml, (String)xpath, this.getNamespaces());
    }

    private static class SchematronReportRulesFilter
    implements DirectoryStream.Filter<Path> {
        private SchematronReportRulesFilter() {
        }

        @Override
        public boolean accept(Path entry) {
            String filename = entry.getFileName().toString();
            return filename.startsWith(MetadataSchema.SCHEMATRON_RULE_FILE_PREFIX) && filename.endsWith(MetadataSchema.XSL_FILE_EXTENSION);
        }
    }
}

