/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.rdf;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collection;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.kernel.KeywordBean;
import org.fao.geonet.kernel.Thesaurus;
import org.fao.geonet.kernel.rdf.ResultInterpreter;
import org.fao.geonet.kernel.rdf.Selectors;
import org.openrdf.model.Value;
import org.openrdf.sesame.query.QueryResultsTable;

class KeywordResultInterpreter
extends ResultInterpreter<KeywordBean> {
    private Collection<String> languages;

    public KeywordResultInterpreter(Collection<String> languages) {
        this.languages = languages;
    }

    @Override
    public KeywordBean createFromRow(Thesaurus thesaurus, QueryResultsTable resultsTable, int row) {
        BiMap<String, Integer> columnNameMap = this.createColumnNameMap(resultsTable);
        Pair<String, String> lowerCorner = this.parseCorner(resultsTable, columnNameMap, row, Selectors.LOWER_CORNER.id);
        String coordWest = (String)lowerCorner.one();
        String coordSouth = (String)lowerCorner.two();
        Pair<String, String> upperCorner = this.parseCorner(resultsTable, columnNameMap, row, Selectors.UPPER_CORNER.id);
        String coordEast = (String)upperCorner.one();
        String coordNorth = (String)upperCorner.two();
        KeywordBean keywordBean = new KeywordBean(thesaurus.getIsoLanguageMapper()).setThesaurusInfo(thesaurus).setId(row).setUriCode(this.columnValue(resultsTable, columnNameMap, row, Selectors.ID.id)).setCoordEast(coordEast).setCoordNorth(coordNorth).setCoordSouth(coordSouth).setCoordWest(coordWest).setDownloadUrl(thesaurus.getDownloadUrl()).setKeywordUrl(thesaurus.getKeywordUrl());
        for (String lang : this.languages) {
            String value = this.columnValue(resultsTable, columnNameMap, row, lang + "_prefLabel");
            keywordBean.setValue(value, lang);
            String definition = this.columnValue(resultsTable, columnNameMap, row, lang + "_note");
            keywordBean.setDefinition(definition, lang);
        }
        return keywordBean;
    }

    private Pair<String, String> parseCorner(QueryResultsTable resultsTable, BiMap<String, Integer> columnNameMap, int row, String columnName) {
        String corner = this.columnValue(resultsTable, columnNameMap, row, columnName);
        String[] parts = corner.split(" ");
        if (parts.length == 2) {
            return Pair.read((Object)parts[0], (Object)parts[1]);
        }
        return Pair.read((Object)"", (Object)"");
    }

    private String columnValue(QueryResultsTable resultsTable, BiMap<String, Integer> columnNameMap, int row, String columnName) {
        Value value;
        Integer columnIdx = (Integer)columnNameMap.get((Object)columnName);
        String prefLabel = "";
        if (columnIdx != null && (value = resultsTable.getValue(row, columnIdx.intValue())) != null) {
            prefLabel = value.toString();
        }
        return prefLabel;
    }

    private BiMap<String, Integer> createColumnNameMap(QueryResultsTable resultsTable) {
        String[] columnNames = resultsTable.getColumnNames();
        HashBiMap map = HashBiMap.create();
        for (int i = 0; i < columnNames.length; ++i) {
            map.put((Object)columnNames[i], (Object)i);
        }
        return map;
    }
}

