/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.attachments;

import java.io.InputStream;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.records.attachments.AbstractStore;
import org.fao.geonet.api.records.attachments.Store;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.MetadataFileDownload;
import org.fao.geonet.domain.MetadataFileUpload;
import org.fao.geonet.domain.MetadataResource;
import org.fao.geonet.domain.MetadataResourceContainer;
import org.fao.geonet.domain.MetadataResourceVisibility;
import org.fao.geonet.repository.MetadataFileDownloadRepository;
import org.fao.geonet.repository.MetadataFileUploadRepository;
import org.fao.geonet.util.ThreadPool;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.dao.EmptyResultDataAccessException;

public class ResourceLoggerStore
extends AbstractStore {
    private Store decoratedStore;
    @Autowired
    private ThreadPool threadPool;

    public ResourceLoggerStore() {
    }

    public ResourceLoggerStore(Store decoratedStore) {
        this.decoratedStore = decoratedStore;
    }

    @Override
    public List<MetadataResource> getResources(ServiceContext context, String metadataUuid, MetadataResourceVisibility metadataResourceVisibility, String filter, Boolean approved) throws Exception {
        if (this.decoratedStore != null) {
            return this.decoratedStore.getResources(context, metadataUuid, metadataResourceVisibility, filter, approved);
        }
        return null;
    }

    @Override
    public Store.ResourceHolder getResource(ServiceContext context, String metadataUuid, MetadataResourceVisibility visibility, String resourceId, Boolean approved) throws Exception {
        if (this.decoratedStore != null) {
            Store.ResourceHolder holder = this.decoratedStore.getResource(context, metadataUuid, visibility, resourceId, approved);
            if (holder != null) {
                this.storeGetRequest(context, metadataUuid, holder.getMetadata().getId(), "", "", "", "", new ISODate().toString(), approved);
            }
            return holder;
        }
        return null;
    }

    @Override
    public Store.ResourceHolder getResourceInternal(String metadataUuid, MetadataResourceVisibility visibility, String resourceId, Boolean approved) throws Exception {
        throw new UnsupportedOperationException("ResourceLoggerStore does not support getResourceInternal.");
    }

    @Override
    public MetadataResource putResource(ServiceContext context, String metadataUuid, String filename, InputStream is, @Nullable Date changeDate, MetadataResourceVisibility visibility, Boolean approved) throws Exception {
        if (this.decoratedStore != null) {
            MetadataResource resource = this.decoratedStore.putResource(context, metadataUuid, filename, is, changeDate, visibility, approved);
            if (resource != null) {
                this.storePutRequest(context, metadataUuid, resource.getId(), resource.getSize(), approved);
            }
            return resource;
        }
        return null;
    }

    @Override
    public MetadataResource patchResourceStatus(ServiceContext context, String metadataUuid, String resourceId, MetadataResourceVisibility metadataResourceVisibility, Boolean approved) throws Exception {
        if (this.decoratedStore != null) {
            return this.decoratedStore.patchResourceStatus(context, metadataUuid, resourceId, metadataResourceVisibility, approved);
        }
        return null;
    }

    @Override
    public String delResources(ServiceContext context, String metadataUuid, Boolean approved) throws Exception {
        if (this.decoratedStore != null) {
            return this.decoratedStore.delResources(context, metadataUuid, approved);
        }
        return null;
    }

    @Override
    public String delResources(ServiceContext context, int metadataId) throws Exception {
        if (this.decoratedStore != null) {
            return this.decoratedStore.delResources(context, metadataId);
        }
        return null;
    }

    @Override
    public String delResource(ServiceContext context, String metadataUuid, String resourceId, Boolean approved) throws Exception {
        String response;
        if (this.decoratedStore != null && (response = this.decoratedStore.delResource(context, metadataUuid, resourceId, approved)) != null) {
            this.storeDeleteRequest(metadataUuid, resourceId, approved);
        }
        return null;
    }

    @Override
    public String delResource(ServiceContext context, String metadataUuid, MetadataResourceVisibility metadataResourceVisibility, String resourceId, Boolean approved) throws Exception {
        String response;
        if (this.decoratedStore != null && (response = this.decoratedStore.delResource(context, metadataUuid, metadataResourceVisibility, resourceId, approved)) != null) {
            this.storeDeleteRequest(metadataUuid, resourceId, approved);
        }
        return null;
    }

    @Override
    public MetadataResource getResourceDescription(ServiceContext context, String metadataUuid, MetadataResourceVisibility visibility, String filename, Boolean approved) throws Exception {
        if (this.decoratedStore != null) {
            return this.decoratedStore.getResourceDescription(context, metadataUuid, visibility, filename, approved);
        }
        return null;
    }

    @Override
    public MetadataResourceContainer getResourceContainerDescription(ServiceContext context, String metadataUuid, Boolean approved) throws Exception {
        if (this.decoratedStore != null) {
            return this.decoratedStore.getResourceContainerDescription(context, metadataUuid, approved);
        }
        return null;
    }

    private void storeGetRequest(ServiceContext context, final String metadataUuid, final String resourceId, final String requesterName, final String requesterMail, final String requesterOrg, final String requesterComments, final String downloadDate, Boolean approved) throws Exception {
        final int metadataId = ResourceLoggerStore.getAndCheckMetadataId(metadataUuid, approved);
        final MetadataFileUploadRepository uploadRepository = context.getBean(MetadataFileUploadRepository.class);
        final MetadataFileDownloadRepository repo = context.getBean(MetadataFileDownloadRepository.class);
        final String userName = context.getUserSession().getUsername();
        this.threadPool.runTask(new Runnable(){

            @Override
            public void run() {
                MetadataFileUpload metadataFileUpload;
                try {
                    metadataFileUpload = uploadRepository.findByMetadataIdAndFileNameNotDeleted(metadataId, resourceId);
                }
                catch (EmptyResultDataAccessException ex) {
                    Log.debug((String)"geonetwork.resources", (Object)String.format("No references in FileNameNotDeleted repository for metadata '%s', resource id '%s'. Get request will not be saved.", metadataUuid, resourceId));
                    metadataFileUpload = null;
                }
                if (metadataFileUpload != null) {
                    MetadataFileDownload metadataFileDownload = new MetadataFileDownload();
                    metadataFileDownload.setMetadataId(metadataId);
                    metadataFileDownload.setFileName(resourceId);
                    metadataFileDownload.setRequesterName(requesterName);
                    metadataFileDownload.setRequesterMail(requesterMail);
                    metadataFileDownload.setRequesterOrg(requesterOrg);
                    metadataFileDownload.setRequesterComments(requesterComments);
                    metadataFileDownload.setDownloadDate(downloadDate);
                    metadataFileDownload.setUserName(userName);
                    metadataFileDownload.setFileUploadId(metadataFileUpload.getId());
                    repo.save((Object)metadataFileDownload);
                }
            }
        });
    }

    private void storeDeleteRequest(String metadataUuid, String fileName, Boolean approved) throws Exception {
        ConfigurableApplicationContext context = ApplicationContextHolder.get();
        int metadataId = ResourceLoggerStore.getAndCheckMetadataId(metadataUuid, approved);
        MetadataFileUploadRepository repo = (MetadataFileUploadRepository)context.getBean(MetadataFileUploadRepository.class);
        try {
            MetadataFileUpload metadataFileUpload = repo.findByMetadataIdAndFileNameNotDeleted(metadataId, fileName);
            metadataFileUpload.setDeletedDate(new ISODate().toString());
            repo.save((Object)metadataFileUpload);
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            // empty catch block
        }
    }

    private void storePutRequest(ServiceContext context, String metadataUuid, String fileName, double fileSize, Boolean approved) throws Exception {
        MetadataFileUploadRepository repo = context.getBean(MetadataFileUploadRepository.class);
        int metadataId = ResourceLoggerStore.getAndCheckMetadataId(metadataUuid, approved);
        this.storeDeleteRequest(metadataUuid, fileName, approved);
        MetadataFileUpload metadataFileUpload = new MetadataFileUpload();
        metadataFileUpload.setMetadataId(metadataId);
        metadataFileUpload.setFileName(fileName);
        metadataFileUpload.setFileSize(Double.valueOf(fileSize));
        metadataFileUpload.setUploadDate(new ISODate().toString());
        metadataFileUpload.setUserName(context.getUserSession().getUsername());
        repo.save((Object)metadataFileUpload);
    }

    @Override
    public void copyResources(ServiceContext context, String sourceUuid, String targetUuid, MetadataResourceVisibility metadataResourceVisibility, boolean sourceApproved, boolean targetApproved) throws Exception {
        if (this.decoratedStore != null) {
            this.decoratedStore.copyResources(context, sourceUuid, targetUuid, metadataResourceVisibility, sourceApproved, targetApproved);
        }
    }
}

