/*
 * Decompiled with CFR 0.152.
 */
package jeeves.server.sources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jeeves.server.dispatchers.ServiceManager;
import jeeves.server.sources.ServiceRequest;
import jeeves.server.sources.http.HttpServiceRequest;
import org.fao.geonet.Constants;
import org.fao.geonet.exceptions.FileUploadTooBigEx;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartRequest;
import org.springframework.web.multipart.support.AbstractMultipartHttpServletRequest;

public final class ServiceRequestFactory {
    private static final String JSON_URL_FLAG = "_content_type=json";
    private static String DEBUG_URL_FLAG = "!";

    private ServiceRequestFactory() {
    }

    public static ServiceRequest create(HttpServletRequest req, HttpServletResponse res, String portal, String lang, String service, Path uploadDir, long maxUploadSize) throws Exception {
        ServiceRequest.InputMethod input;
        String url = req.getPathInfo();
        String encoding = req.getCharacterEncoding();
        try {
            Charset.forName(encoding);
        }
        catch (Exception e) {
            encoding = null;
        }
        if (encoding == null) {
            try {
                req.setCharacterEncoding(Constants.ENCODING);
            }
            catch (UnsupportedEncodingException ex) {
                Log.error((String)"jeeves", (String)("Create request error: " + ex.getMessage()), (Throwable)ex);
            }
        }
        HttpServiceRequest srvReq = new HttpServiceRequest(res);
        srvReq.setDebug(ServiceRequestFactory.extractDebug(url));
        srvReq.setLanguage(lang);
        srvReq.setService(service);
        srvReq.setJSONOutput(ServiceRequestFactory.extractJSONFlag(req.getQueryString()));
        String ip = ServiceManager.getRequestIpAddress(req);
        srvReq.setAddress(ip);
        srvReq.setOutputStream((OutputStream)res.getOutputStream());
        String accept = req.getHeader("Accept");
        if (accept != null) {
            int soapNDX = accept.indexOf("application/soap+xml");
            int xmlNDX = accept.indexOf("application/xml");
            int htmlNDX = accept.indexOf("html");
            if (soapNDX != -1) {
                srvReq.setOutputMethod(ServiceRequest.OutputMethod.SOAP);
            } else if (xmlNDX != -1 && htmlNDX == -1) {
                srvReq.setOutputMethod(ServiceRequest.OutputMethod.XML);
            }
        }
        if ("POST".equals(req.getMethod())) {
            srvReq.setInputMethod(ServiceRequest.InputMethod.POST);
            String contType = req.getContentType();
            if (contType != null) {
                if (contType.indexOf("application/soap+xml") != -1) {
                    srvReq.setInputMethod(ServiceRequest.InputMethod.SOAP);
                    srvReq.setOutputMethod(ServiceRequest.OutputMethod.SOAP);
                } else if (contType.indexOf("application/xml") != -1 || contType.indexOf("text/xml") != -1) {
                    srvReq.setInputMethod(ServiceRequest.InputMethod.XML);
                }
            }
        }
        if ((input = srvReq.getInputMethod()) == ServiceRequest.InputMethod.XML || input == ServiceRequest.InputMethod.SOAP) {
            if (req.getMethod().equals("GET")) {
                srvReq.setParams(ServiceRequestFactory.extractParameters(req, uploadDir, maxUploadSize));
            } else {
                srvReq.setParams(ServiceRequestFactory.extractXmlParameters(req));
            }
        } else {
            srvReq.setParams(ServiceRequestFactory.extractParameters(req, uploadDir, maxUploadSize));
        }
        srvReq.setHeaders(ServiceRequestFactory.extractHeaders(req));
        return srvReq;
    }

    private static Map<String, String> extractHeaders(HttpServletRequest req) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        Enumeration e = req.getHeaderNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            headerMap.put(key, req.getHeader(key));
        }
        if (req.getRemoteUser() != null) {
            headerMap.put("REMOTE_USER", req.getRemoteUser());
        }
        return headerMap;
    }

    private static boolean extractDebug(String url) {
        if (url == null) {
            return false;
        }
        return url.indexOf(DEBUG_URL_FLAG) != -1;
    }

    private static boolean extractJSONFlag(String url) {
        if (url == null) {
            return false;
        }
        return url.indexOf(JSON_URL_FLAG) != -1;
    }

    private static String extractService(String url) {
        int pos;
        if (url == null) {
            return null;
        }
        if (url.endsWith(DEBUG_URL_FLAG)) {
            url = url.substring(0, url.length() - 1);
        }
        if (url.endsWith(JSON_URL_FLAG)) {
            url = url.substring(0, url.length() - JSON_URL_FLAG.length());
        }
        if ((pos = url.lastIndexOf(47)) == -1) {
            return null;
        }
        return url.substring(pos + 1);
    }

    private static Element extractXmlParameters(HttpServletRequest req) throws IOException, JDOMException {
        return Xml.loadStream((InputStream)req.getInputStream());
    }

    private static Element extractParameters(HttpServletRequest req, Path uploadDir, long maxUploadSize) throws Exception {
        if (req instanceof MultipartRequest) {
            AbstractMultipartHttpServletRequest request = (AbstractMultipartHttpServletRequest)req;
            return ServiceRequestFactory.getMultipartParams(request, uploadDir, maxUploadSize);
        }
        Element params = new Element("request");
        ServiceRequestFactory.convertParamToElem(req, params);
        return params;
    }

    private static void convertParamToElem(HttpServletRequest req, Element params) {
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.equals("") || params.getChild(name) != null) continue;
            for (String value : req.getParameterValues(name)) {
                params.addContent((Content)new Element(name).setText(value));
            }
        }
    }

    private static Element getMultipartParams(AbstractMultipartHttpServletRequest req, Path uploadDir, long maxUploadSize) throws Exception {
        Element params = new Element("params");
        long maxSizeInBytes = maxUploadSize * 1024L * 1024L;
        ServiceRequestFactory.convertParamToElem((HttpServletRequest)req, params);
        Map fileMap = req.getFileMap();
        for (Map.Entry fileEntry : fileMap.entrySet()) {
            MultipartFile multipartFile = (MultipartFile)fileEntry.getValue();
            long size = multipartFile.getSize();
            if (size > maxSizeInBytes) {
                throw new FileUploadTooBigEx();
            }
            String file = ((MultipartFile)fileEntry.getValue()).getOriginalFilename();
            String type = multipartFile.getContentType();
            if (Log.isDebugEnabled((String)"jeeves.request")) {
                Log.debug((String)"jeeves.request", (Object)("Uploading file " + file + " type: " + type + " size: " + size));
            }
            file = ServiceRequestFactory.simplifyName(file);
            if (Log.isDebugEnabled((String)"jeeves.request")) {
                Log.debug((String)"jeeves.request", (Object)("File is called " + file + " after simplification"));
            }
            multipartFile.transferTo(uploadDir.resolve(file).toFile());
            Element elem = new Element(multipartFile.getName()).setAttribute("type", "file").setAttribute("size", Long.toString(size)).setText(file);
            if (type != null) {
                elem.setAttribute("content-type", type);
            }
            if (Log.isDebugEnabled((String)"jeeves.request")) {
                Log.debug((String)"jeeves.request", (Object)("Adding to parameters: " + Xml.getString((Element)elem)));
            }
            params.addContent((Content)elem);
        }
        return params;
    }

    private static String simplifyName(String file) {
        int pos2;
        int pos1 = (file = new File(file).getName()).lastIndexOf("\\");
        int pos = Math.max(pos1, pos2 = file.lastIndexOf(47));
        if (pos != -1) {
            file = file.substring(pos + 1).trim();
        }
        try {
            byte[] utf8Bytes = file.getBytes("UTF8");
            file = new String(utf8Bytes, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            Log.error((String)"jeeves", (String)e.getMessage(), (Throwable)e);
        }
        file = file.replaceAll("\\s", "_");
        file = file.replaceAll("[^\\w&&[^,_.-]]", "");
        return file;
    }
}

