/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml2.bindings;

import java.math.BigDecimal;
import javax.xml.namespace.QName;
import org.geotools.gml2.GML;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequenceFactory;

public class GMLCoordTypeBinding
extends AbstractComplexBinding {
    CoordinateSequenceFactory csFactory;

    public GMLCoordTypeBinding(CoordinateSequenceFactory csFactory) {
        this.csFactory = csFactory;
    }

    public QName getTarget() {
        return GML.CoordType;
    }

    public Class getType() {
        return Coordinate.class;
    }

    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        double x = ((BigDecimal)node.getChild("X").getValue()).doubleValue();
        double y = Double.NaN;
        double z = Double.NaN;
        if (!node.getChildren("Y").isEmpty()) {
            y = ((BigDecimal)node.getChild("Y").getValue()).doubleValue();
        }
        if (!node.getChildren("Z").isEmpty()) {
            z = ((BigDecimal)node.getChild("Z").getValue()).doubleValue();
        }
        return new Coordinate(x, y, z);
    }

    public Object getProperty(Object object, QName name) throws Exception {
        Coordinate c = (Coordinate)object;
        if ("X".equals(name.getLocalPart())) {
            return c.x;
        }
        if ("Y".equals(name.getLocalPart())) {
            return c.y;
        }
        if ("Z".equals(name.getLocalPart()) && !Double.valueOf(c.getZ()).isNaN()) {
            return c.getZ();
        }
        return null;
    }
}

