/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.resource.authentication;

import java.time.Instant;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.server.resource.BearerTokenAuthenticationToken;
import org.springframework.security.oauth2.server.resource.InvalidBearerTokenException;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthentication;
import org.springframework.security.oauth2.server.resource.introspection.BadOpaqueTokenException;
import org.springframework.security.oauth2.server.resource.introspection.OAuth2IntrospectionException;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenIntrospector;
import org.springframework.util.Assert;

public final class OpaqueTokenAuthenticationProvider
implements AuthenticationProvider {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final OpaqueTokenIntrospector introspector;

    public OpaqueTokenAuthenticationProvider(OpaqueTokenIntrospector introspector) {
        Assert.notNull((Object)introspector, (String)"introspector cannot be null");
        this.introspector = introspector;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (!(authentication instanceof BearerTokenAuthenticationToken)) {
            return null;
        }
        BearerTokenAuthenticationToken bearer = (BearerTokenAuthenticationToken)authentication;
        OAuth2AuthenticatedPrincipal principal = this.getOAuth2AuthenticatedPrincipal(bearer);
        AbstractAuthenticationToken result = this.convert(principal, bearer.getToken());
        result.setDetails(bearer.getDetails());
        this.logger.debug((Object)"Authenticated token");
        return result;
    }

    private OAuth2AuthenticatedPrincipal getOAuth2AuthenticatedPrincipal(BearerTokenAuthenticationToken bearer) {
        try {
            return this.introspector.introspect(bearer.getToken());
        }
        catch (BadOpaqueTokenException failed) {
            this.logger.debug((Object)"Failed to authenticate since token was invalid");
            throw new InvalidBearerTokenException(failed.getMessage(), failed);
        }
        catch (OAuth2IntrospectionException failed) {
            throw new AuthenticationServiceException(failed.getMessage(), (Throwable)failed);
        }
    }

    public boolean supports(Class<?> authentication) {
        return BearerTokenAuthenticationToken.class.isAssignableFrom(authentication);
    }

    private AbstractAuthenticationToken convert(OAuth2AuthenticatedPrincipal principal, String token) {
        Instant iat = (Instant)principal.getAttribute("iat");
        Instant exp = (Instant)principal.getAttribute("exp");
        OAuth2AccessToken accessToken = new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, token, iat, exp);
        return new BearerTokenAuthentication(principal, accessToken, principal.getAuthorities());
    }
}

