/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.simple;

import org.geotools.gml2.simple.GMLWriter;
import org.geotools.gml2.simple.GeometryEncoder;
import org.geotools.gml2.simple.QualifiedName;
import org.geotools.gml3.simple.PolygonEncoder;
import org.geotools.xsd.Encoder;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

class MultiPolygonEncoder
extends GeometryEncoder<MultiPolygon> {
    static final QualifiedName MULTI_SURFACE = new QualifiedName("http://www.opengis.net/gml", "MultiSurface", "gml");
    static final QualifiedName SURFACE_MEMBER = new QualifiedName("http://www.opengis.net/gml", "surfaceMember", "gml");
    QualifiedName multiSurface;
    QualifiedName surfaceMember;
    PolygonEncoder pe;

    protected MultiPolygonEncoder(Encoder encoder, String gmlPrefix, String gmlUri) {
        super(encoder);
        this.pe = new PolygonEncoder(encoder, gmlPrefix, gmlUri);
        this.init(gmlPrefix, gmlUri);
    }

    protected MultiPolygonEncoder(Encoder encoder, String gmlPrefix, String gmlUri, boolean encodeGmlId) {
        super(encoder, encodeGmlId);
        this.pe = new PolygonEncoder(encoder, gmlPrefix, gmlUri, encodeGmlId);
        this.init(gmlPrefix, gmlUri);
    }

    private void init(String gmlPrefix, String gmlUri) {
        this.multiSurface = MULTI_SURFACE.derive(gmlPrefix, gmlUri);
        this.surfaceMember = SURFACE_MEMBER.derive(gmlPrefix, gmlUri);
    }

    public void encode(MultiPolygon geometry, AttributesImpl atts, GMLWriter handler, String gmlId) throws Exception {
        atts = this.cloneWithGmlId(atts, gmlId);
        handler.startElement(this.multiSurface, (Attributes)atts);
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            handler.startElement(this.surfaceMember, null);
            this.pe.encode((Polygon)geometry.getGeometryN(i), null, handler, gmlId + "." + (i + 1));
            handler.endElement(this.surfaceMember);
        }
        handler.endElement(this.multiSurface);
    }
}

